/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.fields;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.fields.ByteArrayHolder;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class TestByteArray
extends SingleEMTestCase {
    boolean runTest = false;

    @Override
    public void setUp() {
        super.setUp();
        OpenJPAEntityManagerFactorySPI ojpaEmf = this.emf;
        JDBCConfiguration conf = (JDBCConfiguration)ojpaEmf.getConfiguration();
        if (conf.getDBDictionaryInstance() instanceof DB2Dictionary) {
            this.runTest = true;
            super.setUp(ByteArrayHolder.class, CLEAR_TABLES);
        }
    }

    public void testByteArray() {
        if (!this.runTest) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        byte[] ba = new byte[]{-96, 27, 1, 31, 56, -49, 103, 53, 85, 67, -39, -10, 113, 94, 0, 0};
        ByteArrayHolder holder = new ByteArrayHolder();
        holder.setTkiid(ba);
        try {
            em.getTransaction().begin();
            em.persist((Object)holder);
            em.getTransaction().commit();
        }
        catch (Throwable t) {
            t.printStackTrace();
            TestByteArray.fail((String)"Error: Task insert failed");
        }
        Query q = em2.createQuery("select e from ByteArrayHolder e");
        List elist = q.getResultList();
        for (ByteArrayHolder e : elist) {
            String baFromH = new String(e.getTkiid());
            TestByteArray.assertEquals((String)new String(ba), (String)baFromH);
        }
        holder = (ByteArrayHolder)em.find(ByteArrayHolder.class, (Object)holder.getTaskId());
        String baFromH = new String(holder.getTkiid());
        TestByteArray.assertEquals((String)new String(ba), (String)baFromH);
        this.closeEM((EntityManager)em);
        this.closeEM((EntityManager)em2);
    }
}

