/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.generationtype;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.generationtype.EntityE2;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestNativeSeqGenerator
extends SQLListenerTestCase {
    OpenJPAEntityManager em;
    JDBCConfiguration conf;
    DBDictionary dict;
    EntityE2 entityE2;

    @Override
    public void setUp() throws Exception {
        super.setUp(EntityE2.class, DROP_TABLES);
        TestNativeSeqGenerator.assertNotNull((Object)this.emf);
        this.conf = (JDBCConfiguration)this.emf.getConfiguration();
        this.dict = this.conf.getDBDictionaryInstance();
        boolean supportsNativeSequence = this.dict.nextSequenceQuery != null;
        this.setTestsDisabled(!supportsNativeSequence);
        if (supportsNativeSequence) {
            this.em = this.emf.createEntityManager();
            TestNativeSeqGenerator.assertNotNull((Object)this.em);
        } else {
            this.getLog().trace((Object)((Object)((Object)this) + " is disabled because " + this.dict.getClass().getSimpleName() + " does not support native sequences."));
        }
    }

    public void createEntityE2() {
        this.entityE2 = new EntityE2("e name");
    }

    public void testGetIdGeneratorSeqGen() {
        this.createEntityE2();
        this.em.getTransaction().begin();
        this.em.persist((Object)this.entityE2);
        this.em.getTransaction().commit();
        int genId = this.entityE2.getId();
        int nextId = (int)((Long)this.em.getIdGenerator(EntityE2.class).next()).longValue();
        TestNativeSeqGenerator.assertTrue((String)"Next value should depend on previous genid", (nextId >= genId + 1 ? 1 : 0) != 0);
        this.em.close();
    }

    public void testAllocationSize() {
        this.dict.setBatchLimit(0);
        this.em.getTransaction().begin();
        this.resetSQL();
        for (int i = 0; i < 51; ++i) {
            this.createEntityE2();
            this.em.persist((Object)this.entityE2);
        }
        this.em.getTransaction().commit();
        TestNativeSeqGenerator.assertEquals((String)"54 statements should be executed.", (int)54, (int)this.getSQLCount());
        String[] statements = new String[54];
        statements[0] = "ALTER .*";
        statements[1] = ".*";
        statements[2] = ".*";
        for (int i = 3; i < 54; ++i) {
            statements[i] = "INSERT .*";
        }
        this.assertAllExactSQLInOrder(statements);
        this.em.close();
    }
}

