/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.graph.PersistentGraph;
import org.apache.openjpa.persistence.graph.PersistentRelation;
import org.apache.openjpa.persistence.graph.Relation;

@Entity
public class RelationGraph<E>
extends PersistentGraph<E> {
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REFRESH})
    private Set<PersistentRelation<E, E>> relations = new HashSet<PersistentRelation<E, E>>();
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$graph$PersistentGraph;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$graph$RelationGraph;
    private static final long serialVersionUID;

    @Override
    public <V1 extends E, V2 extends E> Relation<V1, V2> link(V1 source, V2 target) {
        if (source == null) {
            throw new NullPointerException("Can not link from a null source vertex");
        }
        if (target == null) {
            throw new NullPointerException("Can not link to a null target vertex");
        }
        Relation<V1, V2> r = this.getRelation(source, target);
        if (r == null) {
            r = new PersistentRelation<V1, V2>(source, target);
            RelationGraph.pcGetrelations(this).add((PersistentRelation)r);
        }
        return r;
    }

    @Override
    public <V1 extends E, V2 extends E> Relation<V1, V2> delink(V1 source, V2 target) {
        Relation<V1, V2> r = this.getRelation(source, target);
        if (r != null) {
            RelationGraph.pcGetrelations(this).remove(r);
        }
        return r;
    }

    @Override
    public <V1 extends E, V2 extends E> Relation<V1, V2> getRelation(V1 source, V2 target) {
        for (PersistentRelation r : RelationGraph.pcGetrelations(this)) {
            if (!r.getSource().equals(source) || r.getTarget() == null || !r.getTarget().equals(target)) continue;
            return r;
        }
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return this.getNodes().iterator();
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public <V extends E> Set<Relation<V, E>> getRelationsFrom(V source) {
        HashSet<Relation<V, PersistentRelation>> rs = new HashSet<Relation<V, PersistentRelation>>();
        for (PersistentRelation r : RelationGraph.pcGetrelations(this)) {
            if (!r.getSource().equals(source) || r.getTarget() == null) continue;
            rs.add(r);
        }
        return rs;
    }

    @Override
    public <V extends E> Set<Relation<E, V>> getRelationsTo(V target) {
        HashSet<Relation<PersistentRelation, V>> rs = new HashSet<Relation<PersistentRelation, V>>();
        for (PersistentRelation r : RelationGraph.pcGetrelations(this)) {
            if (r.getTarget() == null || !r.getTarget().equals(target)) continue;
            rs.add(r);
        }
        return rs;
    }

    @Override
    public Set<E> getSources(Object target) {
        HashSet sources = new HashSet();
        for (PersistentRelation r : RelationGraph.pcGetrelations(this)) {
            if (r.getTarget() == null || !r.getTarget().equals(target)) continue;
            sources.add(r.getSource());
        }
        return sources;
    }

    @Override
    public Set<E> getTargets(Object source) {
        HashSet targets = new HashSet();
        for (PersistentRelation r : RelationGraph.pcGetrelations(this)) {
            if (!r.getSource().equals(source) || r.getTarget() == null) continue;
            targets.add(r.getTarget());
        }
        return targets;
    }

    public Set<E> getNodes() {
        HashSet<Object> all = new HashSet<Object>();
        for (PersistentRelation r : RelationGraph.pcGetrelations(this)) {
            all.add(r.getSource());
            if (r.getTarget() == null) continue;
            all.add(r.getTarget());
        }
        return all;
    }

    @Override
    public boolean add(E e) {
        if (this.contains(e)) {
            return false;
        }
        RelationGraph.pcGetrelations(this).add(new PersistentRelation<E, Object>(e, null));
        return true;
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1674154;
    }

    static {
        serialVersionUID = 6870379269957185321L;
        pcInheritedFieldCount = PersistentGraph.pcGetManagedFieldCount();
        Class clazz = class$Lorg$apache$openjpa$persistence$graph$PersistentGraph != null ? class$Lorg$apache$openjpa$persistence$graph$PersistentGraph : (class$Lorg$apache$openjpa$persistence$graph$PersistentGraph = RelationGraph.class$("org.apache.openjpa.persistence.graph.PersistentGraph"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"relations"};
        Class[] classArray = new Class[1];
        Class clazz2 = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = RelationGraph.class$("java.util.Set"));
        classArray[0] = clazz2;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{5};
        Class clazz3 = class$Lorg$apache$openjpa$persistence$graph$RelationGraph != null ? class$Lorg$apache$openjpa$persistence$graph$RelationGraph : (class$Lorg$apache$openjpa$persistence$graph$RelationGraph = RelationGraph.class$("org.apache.openjpa.persistence.graph.RelationGraph"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"RelationGraph", new RelationGraph());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.relations = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        RelationGraph<E> relationGraph = new RelationGraph<E>();
        if (bl) {
            relationGraph.pcClearFields();
        }
        relationGraph.pcStateManager = stateManager;
        relationGraph.pcCopyKeyFieldsFromObjectId(object);
        return relationGraph;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        RelationGraph<E> relationGraph = new RelationGraph<E>();
        if (bl) {
            relationGraph.pcClearFields();
        }
        relationGraph.pcStateManager = stateManager;
        return relationGraph;
    }

    protected static int pcGetManagedFieldCount() {
        return 1 + PersistentGraph.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.relations = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.relations);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(RelationGraph relationGraph, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(relationGraph, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.relations = relationGraph.relations;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        RelationGraph relationGraph = (RelationGraph)object;
        if (relationGraph.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(relationGraph, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$openjpa$persistence$graph$RelationGraph != null ? class$Lorg$apache$openjpa$persistence$graph$RelationGraph : (class$Lorg$apache$openjpa$persistence$graph$RelationGraph = RelationGraph.class$("org.apache.openjpa.persistence.graph.RelationGraph"));
        return clazz;
    }

    private static final Set pcGetrelations(RelationGraph relationGraph) {
        if (relationGraph.pcStateManager == null) {
            return relationGraph.relations;
        }
        int n = pcInheritedFieldCount + 0;
        relationGraph.pcStateManager.accessingField(n);
        return relationGraph.relations;
    }

    private static final void pcSetrelations(RelationGraph relationGraph, Set set) {
        if (relationGraph.pcStateManager == null) {
            relationGraph.relations = set;
            return;
        }
        relationGraph.pcStateManager.settingObjectField((PersistenceCapable)relationGraph, pcInheritedFieldCount + 0, relationGraph.relations, (Object)set, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

