/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.graph;

import java.sql.Date;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.FieldStrategy;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.ValueHandler;
import org.apache.openjpa.jdbc.meta.strats.HandlerFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.HandlerHandlerMapTableFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.UntypedPCValueHandler;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.graph.City;
import org.apache.openjpa.persistence.graph.Graph;
import org.apache.openjpa.persistence.graph.People;
import org.apache.openjpa.persistence.graph.PersistentGraph;
import org.apache.openjpa.persistence.graph.PersistentRelation;
import org.apache.openjpa.persistence.graph.Relation;
import org.apache.openjpa.persistence.graph.RelationGraph;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestPersistentGraph
extends SingleEMFTestCase {
    private static final long[] SSN = new long[]{123456781L, 123456782L, 123456783L, 123456784L, 123456785L};
    private static final String[] PERSON_NAMES = new String[]{"P1", "P2", "P3", "P4", "P5"};
    private static final String[] CITY_NAMES = new String[]{"San Francisco", "Paris", "Rome"};
    private static final String ATTR_SINCE = "since";
    private static final Date SINCE = new Date(90, 1, 27);
    private static final String ATTR_EMOTION = "feels";
    private static final Emotion[][] EMOTIONS = new Emotion[][]{{null, Emotion.LOVES, Emotion.HATES, null, Emotion.KNOWS}, {Emotion.LOVES, null, Emotion.LOVES, null, Emotion.LOVES}, {Emotion.HATES, Emotion.LOVES, null, null, Emotion.KNOWS}, {Emotion.LOVES, Emotion.HATES, Emotion.KNOWS, Emotion.LOVES, Emotion.LOVES}, {null, Emotion.LOVES, Emotion.KNOWS, Emotion.KNOWS, null}};
    private static final String ATTR_DISTANCE = "distance";
    private static final int[][] ATTR_DISTANCE_VALUE = new int[][]{{0, 200, 400}, {200, 0, 500}, {400, 500, 0}};
    private EntityManager em;
    private PersistentGraph<Object> graph;

    @Override
    public void setUp() throws Exception {
        super.setUp(CLEAR_TABLES, PersistentGraph.class, RelationGraph.class, PersistentRelation.class, People.class, City.class);
        this.em = this.emf.createEntityManager();
        this.graph = this.createData();
        this.em.clear();
    }

    public void testMapping() {
        this.assertStrategy(PersistentRelation.class, "source", HandlerFieldStrategy.class, UntypedPCValueHandler.class);
        this.assertStrategy(PersistentRelation.class, "target", HandlerFieldStrategy.class, UntypedPCValueHandler.class);
        this.assertStrategy(PersistentRelation.class, "attrs", HandlerHandlerMapTableFieldStrategy.class, null);
    }

    private void printMapping(FieldMapping fm) {
        System.err.println("Field :" + fm.getName());
        System.err.println("Type :" + fm.getTypeCode() + " " + fm.getType());
        System.err.println("Type (declared):" + fm.getDeclaredTypeCode() + " " + fm.getDeclaredType());
        System.err.println("Type Override :" + fm.getTypeOverride());
        System.err.println("Key type  :" + fm.getKey().getType());
        System.err.println("Key declared type  :" + fm.getKey().getDeclaredType());
        System.err.println("Element type  :" + fm.getElement().getType());
        System.err.println("Element declared type  :" + fm.getElement().getDeclaredType());
    }

    FieldMapping getFieldMapping(Class<?> pcClass, String field) {
        MappingRepository repos = (MappingRepository)this.emf.getConfiguration().getMetaDataRepositoryInstance();
        ClassMapping cmd = repos.getMapping(pcClass, null, true);
        TestPersistentGraph.assertNotNull((String)("No metadata found for " + pcClass), (Object)cmd);
        FieldMapping fmd = cmd.getFieldMapping(field);
        TestPersistentGraph.assertNotNull((String)("No metadata found for " + pcClass.getName() + "." + field + " Fields are " + Arrays.toString(cmd.getFieldNames())), (Object)fmd);
        return fmd;
    }

    void assertStrategy(Class<?> pcClass, String field, Class<? extends FieldStrategy> strategy, Class<? extends ValueHandler> handler) {
        FieldMapping fmd = this.getFieldMapping(pcClass, field);
        FieldStrategy actualStrategy = fmd.getStrategy();
        TestPersistentGraph.assertEquals(strategy, actualStrategy.getClass());
        ValueHandler actualHandler = fmd.getHandler();
        if (handler == null) {
            if (actualHandler != null) {
                this.printMapping(fmd);
                TestPersistentGraph.fail((String)("Expected no value handler for " + pcClass.getName() + "." + field + " but found " + actualHandler));
            }
        } else {
            if (actualHandler == null) {
                this.printMapping(fmd);
                TestPersistentGraph.fail((String)("Expected a value handler for " + pcClass.getName() + "." + field + " but found null"));
            }
            if (!handler.getClass().equals(actualHandler.getClass())) {
                this.printMapping(fmd);
                TestPersistentGraph.assertEquals(handler, fmd.getHandler().getClass());
            }
        }
    }

    FieldStrategy getStrategy(Class<?> cls, String field) {
        MetaDataRepository repos = this.emf.getConfiguration().getMetaDataRepositoryInstance();
        ClassMetaData cmd = repos.getMetaData(cls, null, true);
        TestPersistentGraph.assertNotNull((String)("No metadat found for " + cls), (Object)cmd);
        FieldMetaData fmd = cmd.getField(field);
        TestPersistentGraph.assertNotNull((String)("No metadata found for " + cls.getName() + "." + field + " Fields are " + Arrays.toString(cmd.getFieldNames())), (Object)fmd);
        FieldStrategy strategy = ((FieldMapping)fmd).getStrategy();
        System.err.println(cls.getName() + "." + field + ":" + strategy.getClass().getSimpleName());
        return strategy;
    }

    public void testCreateGraph() {
        this.em.getTransaction().begin();
        TestPersistentGraph.assertFalse((boolean)this.em.contains(this.graph));
        this.graph = (PersistentGraph)this.em.find(PersistentGraph.class, (Object)this.graph.getId());
        TestPersistentGraph.assertNotNull(this.graph);
        People[] people = new People[SSN.length];
        for (int i = 0; i < SSN.length; ++i) {
            People p = (People)this.em.find(People.class, (Object)SSN[i]);
            TestPersistentGraph.assertNotNull((Object)p);
            people[i] = p;
        }
        City[] cities = new City[CITY_NAMES.length];
        for (int i = 0; i < CITY_NAMES.length; ++i) {
            City c = (City)this.em.find(City.class, (Object)CITY_NAMES[i]);
            TestPersistentGraph.assertNotNull((Object)c);
            cities[i] = c;
        }
        this.assertDataEquals(this.graph, people, cities);
        this.em.getTransaction().rollback();
    }

    public void testQueryRelation() {
        String jpql = "select r from PersistentRelation r";
        List relations = this.em.createQuery(jpql, PersistentRelation.class).getResultList();
        for (PersistentRelation r : relations) {
            int j;
            int i;
            Object source = r.getSource();
            Object target = r.getTarget();
            if (source instanceof People) {
                i = this.indexOf((People)source);
                if (target instanceof People) {
                    j = this.indexOf((People)target);
                    TestPersistentGraph.assertNotNull((Object)((Object)EMOTIONS[i][j]));
                    TestPersistentGraph.assertEquals((Object)EMOTIONS[i][j].toString(), (Object)r.getAttribute(ATTR_EMOTION));
                    continue;
                }
                if (target instanceof City) {
                    j = this.indexOf((City)target);
                    TestPersistentGraph.assertEquals((int)(i % CITY_NAMES.length), (int)j);
                    TestPersistentGraph.assertTrue((boolean)r.getAttributes().isEmpty());
                    continue;
                }
                if (target == null) continue;
                TestPersistentGraph.fail((String)("Unexpected relation " + r));
                continue;
            }
            if (!(source instanceof City)) continue;
            i = this.indexOf((City)source);
            if (target instanceof City) {
                j = this.indexOf((City)target);
                TestPersistentGraph.assertEquals((Object)("" + ATTR_DISTANCE_VALUE[i][j]), (Object)r.getAttribute(ATTR_DISTANCE));
                continue;
            }
            if (target == null) continue;
            TestPersistentGraph.fail((String)("Unexpected relation " + r));
        }
    }

    public void testQueryRelationOnSourceParameter() {
        People p1 = (People)this.em.find(People.class, (Object)SSN[0]);
        String jpql = "select r from PersistentRelation r where r.source = :node";
        List result = this.em.createQuery(jpql, PersistentRelation.class).setParameter("node", (Object)p1).getResultList();
        TestPersistentGraph.assertFalse((String)("Result of [" + jpql + "] on source = " + p1 + " should not be empty"), (boolean)result.isEmpty());
    }

    public void testQueryRelationOnSingleAttributeKey() {
        String jpql = "select r from PersistentRelation r join r.attrs a where key(a) = :key";
        List result = this.em.createQuery(jpql, PersistentRelation.class).setParameter("key", (Object)ATTR_EMOTION).getResultList();
        TestPersistentGraph.assertFalse((String)("Result of [" + jpql + "] on key = " + ATTR_EMOTION + " should not be empty"), (boolean)result.isEmpty());
    }

    public void testQueryRelationOnSingleAttributeKeyValue() {
        String jpql = "select r from PersistentRelation r join r.attrs a where key(a) = :key and value(a) = :value";
        String value = EMOTIONS[0][2].toString();
        List result = this.em.createQuery(jpql, PersistentRelation.class).setParameter("key", (Object)ATTR_EMOTION).setParameter("value", (Object)value).getResultList();
        TestPersistentGraph.assertFalse((String)("Result of [" + jpql + "] on key-value (" + ATTR_EMOTION + "," + value + ") should not be empty"), (boolean)result.isEmpty());
    }

    public void testQueryRelationOnMultipleAttributeKeyValuePairs() {
        String jpql = "select r from PersistentRelation r join r.attrs a1 join r.attrs a2 where key(a1) = :key1 and value(a1) = :value1 and key(a2) = :key2 and value(a2) = :value2";
        String value = EMOTIONS[0][2].toString();
        List result = this.em.createQuery(jpql, PersistentRelation.class).setParameter("key1", (Object)ATTR_EMOTION).setParameter("value1", (Object)value).setParameter("key2", (Object)ATTR_SINCE).setParameter("value2", (Object)SINCE.toString()).getResultList();
        TestPersistentGraph.assertFalse((String)("Result of [" + jpql + "] on key-value = (" + ATTR_EMOTION + "," + value + ") and key-value=(" + ATTR_SINCE + "," + SINCE + ") should not be empty"), (boolean)result.isEmpty());
        String wrongJPQL = "select r from PersistentRelation r join r.attrs a where key(a) = :key1 and value(a) = :value1 and key(a) = :key2 and value(a) = :value2";
        List result2 = this.em.createQuery(wrongJPQL, PersistentRelation.class).setParameter("key1", (Object)ATTR_EMOTION).setParameter("value1", (Object)value).setParameter("key2", (Object)ATTR_SINCE).setParameter("value2", (Object)SINCE.toString()).getResultList();
        TestPersistentGraph.assertTrue((String)("Result of [" + jpql + "] on key-value = (" + ATTR_EMOTION + "," + value + ") and key-value=(" + ATTR_SINCE + "," + SINCE + ") should be empty"), (boolean)result2.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddRemoveAttribute() {
        this.em.getTransaction().begin();
        People p1 = (People)this.em.find(People.class, (Object)SSN[0]);
        String jpql = "select r from PersistentRelation r where r.source = :node";
        List r = this.em.createQuery(jpql, PersistentRelation.class).setHint("openjpa.hint.IgnorePreparedQuery", (Object)true).setParameter("node", (Object)p1).getResultList();
        TestPersistentGraph.assertFalse((boolean)r.isEmpty());
        ((PersistentRelation)r.get(0)).addAttribute("new-key", "new-value");
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
        jpql = "select r from PersistentRelation r join r.attrs a where key(a) = :key";
        Relation newR = (Relation)this.em.createQuery(jpql, PersistentRelation.class).setParameter("key", (Object)"new-key").getSingleResult();
        TestPersistentGraph.assertNotNull((Object)newR);
        TestPersistentGraph.assertEquals((Object)"new-value", (Object)newR.getAttribute("new-key"));
        newR.removeAttribute("new-key");
        this.em.getTransaction().commit();
        this.em.getTransaction().begin();
        jpql = "select r from PersistentRelation r join r.attrs a where key(a) = :key";
        try {
            newR = (Relation)this.em.createQuery(jpql, PersistentRelation.class).setParameter("key", (Object)"new-key").getSingleResult();
            TestPersistentGraph.fail((String)(jpql + " with new-key expected no result"));
        }
        catch (NoResultException nre) {
        }
        finally {
            this.em.getTransaction().rollback();
        }
    }

    boolean isPopulated() {
        return (Long)this.em.createQuery("select count(p) from People p", Long.class).getSingleResult() > 0L;
    }

    PersistentGraph<Object> createData() {
        int i;
        RelationGraph<Object> graph = new RelationGraph<Object>();
        this.em.getTransaction().begin();
        People[] people = new People[SSN.length];
        for (int i2 = 0; i2 < SSN.length; ++i2) {
            People p = new People();
            ((AbstractCollection)graph).add(p);
            p.setSsn(SSN[i2]);
            p.setName(PERSON_NAMES[i2]);
            people[i2] = p;
        }
        City[] cities = new City[CITY_NAMES.length];
        for (i = 0; i < CITY_NAMES.length; ++i) {
            City c = new City();
            ((AbstractCollection)graph).add(c);
            c.setName(CITY_NAMES[i]);
            cities[i] = c;
        }
        for (i = 0; i < people.length; ++i) {
            for (int j = 0; j < people.length; ++j) {
                if (EMOTIONS[i][j] == null) continue;
                Relation<People, People> r = graph.link(people[i], people[j]).addAttribute(ATTR_EMOTION, (Object)EMOTIONS[i][j]);
                if (i != 0 || j != 2) continue;
                r.addAttribute(ATTR_SINCE, SINCE);
            }
        }
        for (i = 0; i < cities.length; ++i) {
            for (int j = 0; j < cities.length; ++j) {
                graph.link(cities[i], cities[j]).addAttribute(ATTR_DISTANCE, ATTR_DISTANCE_VALUE[i][j]);
            }
        }
        for (i = 0; i < people.length; ++i) {
            graph.link(people[i], cities[i % CITY_NAMES.length]);
        }
        this.em.persist(graph);
        this.em.getTransaction().commit();
        return graph;
    }

    void assertDataEquals(Graph<Object> graph, People[] people, City[] cities) {
        Relation<People, PersistenceCapable> r;
        int j;
        People p;
        int i;
        TestPersistentGraph.assertEquals((int)SSN.length, (int)people.length);
        TestPersistentGraph.assertEquals((int)CITY_NAMES.length, (int)cities.length);
        for (i = 0; i < people.length; ++i) {
            p = people[i];
            TestPersistentGraph.assertEquals((long)SSN[i], (long)p.getSsn());
            TestPersistentGraph.assertEquals((String)PERSON_NAMES[i], (String)p.getName());
        }
        for (i = 0; i < cities.length; ++i) {
            City c = cities[i];
            TestPersistentGraph.assertEquals((String)CITY_NAMES[i], (String)c.getName());
        }
        for (i = 0; i < people.length; ++i) {
            People p1 = people[i];
            for (j = 0; j < people.length; ++j) {
                People p2 = people[j];
                r = graph.getRelation(p1, p2);
                if (EMOTIONS[i][j] != null) {
                    TestPersistentGraph.assertNotNull(r);
                    TestPersistentGraph.assertEquals((Object)EMOTIONS[i][j].toString(), (Object)r.getAttribute(ATTR_EMOTION));
                    continue;
                }
                TestPersistentGraph.assertNull(r);
            }
        }
        for (i = 0; i < cities.length; ++i) {
            City c1 = cities[i];
            for (j = 0; j < cities.length; ++j) {
                City c2 = cities[j];
                Relation<City, City> r12 = graph.getRelation(c1, c2);
                TestPersistentGraph.assertNotNull(r12);
                TestPersistentGraph.assertEquals((Object)("" + ATTR_DISTANCE_VALUE[i][j]), (Object)r12.getAttribute(ATTR_DISTANCE));
            }
        }
        for (i = 0; i < people.length; ++i) {
            p = people[i];
            for (j = 0; j < cities.length; ++j) {
                City c = cities[j];
                r = graph.getRelation(p, c);
                if (i % CITY_NAMES.length == j) {
                    TestPersistentGraph.assertNotNull(r);
                    continue;
                }
                TestPersistentGraph.assertNull(r);
            }
        }
    }

    int indexOf(People p) {
        for (int i = 0; i < SSN.length; ++i) {
            if (SSN[i] != p.getSsn()) continue;
            return i;
        }
        return -1;
    }

    int indexOf(City c) {
        for (int i = 0; i < CITY_NAMES.length; ++i) {
            if (!CITY_NAMES[i].equals(c.getName())) continue;
            return i;
        }
        return -1;
    }

    private static enum Emotion {
        LOVES,
        HATES,
        KNOWS;

    }
}

