/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.hugariannotation;

import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.hugariannotation.HungarianNotationFieldDuplicates;
import org.apache.openjpa.persistence.hugariannotation.HungarianNotationFields;
import org.apache.openjpa.persistence.hugariannotation.OtherClass;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestHungarianNotationRemoval
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(HungarianNotationFieldDuplicates.class, HungarianNotationFields.class, OtherClass.class, CLEAR_TABLES, "openjpa.jdbc.MappingDefaults", "removeHungarianNotation=true");
    }

    public void testSimpleColumnNameTruncation() {
        ClassMapping cm = (ClassMapping)JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, HungarianNotationFields.class);
        FieldMapping[] fieldMappings = cm.getFieldMappings();
        for (int i = 0; i < fieldMappings.length; ++i) {
            String name = fieldMappings[i].getColumns()[0].getName();
            if (fieldMappings[i].getName().equals("m_intFooBar7")) continue;
            TestHungarianNotationRemoval.assertTrue((String)("Failed to removed Hungarian Notation, resulting column name : " + name), (boolean)name.toUpperCase().startsWith("FOOBAR"));
        }
    }

    public void testCustomNameNotAltered() {
        ClassMapping cm = (ClassMapping)JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, HungarianNotationFields.class);
        TestHungarianNotationRemoval.assertEquals((String)"M_INTFOOBAR7_CUSTOM_NAME", (String)cm.getFieldMapping("m_intFooBar7").getColumns()[0].getName());
    }
}

