/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance;

import java.util.List;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.inheritance.AbstractBase;
import org.apache.openjpa.persistence.inheritance.ConcreteSubclass;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestFindAbstractClass
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(AbstractBase.class, ConcreteSubclass.class, CLEAR_TABLES);
        ConcreteSubclass e = new ConcreteSubclass();
        e.setId("id");
        e.setSubclassData(1);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)e);
        em.getTransaction().commit();
        em.close();
    }

    public void testEntityTypeInheritanceTypeJoined() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select c from AbstractBase c where TYPE(c) = ConcreteSubclass";
        List rs = em.createQuery(query).getResultList();
        TestFindAbstractClass.assertTrue((boolean)(rs.get(0) instanceof ConcreteSubclass));
        query = "select c from AbstractBase c";
        rs = em.createQuery(query).getResultList();
        TestFindAbstractClass.assertTrue((boolean)(rs.get(0) instanceof ConcreteSubclass));
        em.close();
    }

    public void testFind() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        AbstractBase e = (AbstractBase)em.find(AbstractBase.class, (Object)"id");
        TestFindAbstractClass.assertNotNull((Object)e);
        TestFindAbstractClass.assertTrue((boolean)(e instanceof ConcreteSubclass));
        TestFindAbstractClass.assertEquals((int)1, (int)((ConcreteSubclass)e).getSubclassData());
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestFindAbstractClass.class);
    }
}

