/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance;

import java.util.Iterator;
import java.util.List;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.inheritance.entities.EntityMapping;
import org.apache.openjpa.persistence.inheritance.entities.testinterfaces.RootEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestInheritanceWithMSCID
extends SingleEMFTestCase {
    private EntityMapping.InheritanceEntityMapping[][] allEntityGroups = new EntityMapping.InheritanceEntityMapping[][]{EntityMapping.PIdJTIDMSC, EntityMapping.PIdJTCDMSC, EntityMapping.PIdJTSDMSC, EntityMapping.PIdSTIDMSC, EntityMapping.PIdSTCDMSC, EntityMapping.PIdSTSDMSC};
    private boolean[][] queryLogic001AcceptenceMapping = new boolean[][]{{true, true, true, true, true, true, true, true, true}, {false, true, false, false, false, false, false, false, false}, {false, false, true, true, true, false, false, false, false}, {false, false, false, true, false, false, false, false, false}, {false, false, false, false, true, false, false, false, false}, {false, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, true, true, true}, {false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, true}};

    @Override
    public void setUp() {
        EntityMapping.InheritanceEntityMapping[] entityClassEnums = EntityMapping.InheritanceEntityMapping.values();
        Class[] entityClassTypes = new Class[entityClassEnums.length];
        int idx = 0;
        for (EntityMapping.InheritanceEntityMapping eEnum : entityClassEnums) {
            entityClassTypes[idx] = eEnum.getEntityClass();
            ++idx;
        }
        this.setUp(entityClassTypes);
    }

    public void testPersistableWithEntitiesInL1Cache() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        for (EntityMapping.InheritanceEntityMapping[] tEntities : this.allEntityGroups) {
            int idx = 0;
            try {
                for (EntityMapping.InheritanceEntityMapping tEntity : tEntities) {
                    RootEntity entity = (RootEntity)EntityMapping.createEntityObjectInstance(tEntity);
                    entity.updateId(new Integer(idx++));
                    entity.setRootEntityData("Root " + (idx - 1));
                    em.getTransaction().begin();
                    em.persist((Object)entity);
                    em.getTransaction().commit();
                }
            }
            catch (Exception e) {
                TestInheritanceWithMSCID.fail((String)("Test failed with Exception\n" + e));
            }
            List resultList = em.createQuery("SELECT e FROM " + tEntities[0].getEntityName() + " e ORDER BY e.id").getResultList();
            TestInheritanceWithMSCID.assertEquals((int)tEntities.length, (int)resultList.size());
            idx = 0;
            Iterator i$ = resultList.iterator();
            while (i$.hasNext()) {
                RootEntity obj;
                RootEntity entity = obj = (RootEntity)i$.next();
                Class<?> actualType = entity.getClass();
                Class expectedType = tEntities[idx].getEntityClass();
                TestInheritanceWithMSCID.assertEquals((String)("Assert Entity " + (idx + 1) + "is entity of type " + expectedType), (Object)expectedType, actualType);
                ++idx;
            }
        }
        em.close();
    }

    public void testPersistableWithEntitiesClearedFromL1Cache() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        for (EntityMapping.InheritanceEntityMapping[] tEntities : this.allEntityGroups) {
            int idx = 0;
            try {
                for (EntityMapping.InheritanceEntityMapping tEntity : tEntities) {
                    RootEntity entity = (RootEntity)EntityMapping.createEntityObjectInstance(tEntity);
                    entity.updateId(new Integer(idx++));
                    entity.setRootEntityData("Root " + (idx - 1));
                    em.getTransaction().begin();
                    em.persist((Object)entity);
                    em.getTransaction().commit();
                    em.clear();
                }
            }
            catch (Exception e) {
                TestInheritanceWithMSCID.fail((String)("Test failed with Exception\n" + e));
            }
            List resultList = em.createQuery("SELECT e FROM " + tEntities[0].getEntityName() + " e ORDER BY e.id").getResultList();
            TestInheritanceWithMSCID.assertEquals((int)tEntities.length, (int)resultList.size());
            idx = 0;
            Iterator i$ = resultList.iterator();
            while (i$.hasNext()) {
                RootEntity obj;
                RootEntity entity = obj = (RootEntity)i$.next();
                Class<?> actualType = entity.getClass();
                Class expectedType = tEntities[idx].getEntityClass();
                TestInheritanceWithMSCID.assertEquals((String)("Assert Entity " + (idx + 1) + "is entity of type " + expectedType), (Object)expectedType, actualType);
                ++idx;
            }
        }
        em.close();
    }

    private void query001TestLogic(boolean clearL1Cache) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        boolean[][] acceptenceMapping = this.queryLogic001AcceptenceMapping;
        for (EntityMapping.InheritanceEntityMapping[] tEntities : this.allEntityGroups) {
            int idx = 0;
            try {
                for (EntityMapping.InheritanceEntityMapping tEntity : tEntities) {
                    RootEntity entity = (RootEntity)EntityMapping.createEntityObjectInstance(tEntity);
                    entity.updateId(new Integer(idx++));
                    entity.setRootEntityData("Root " + (idx - 1));
                    em.getTransaction().begin();
                    em.persist((Object)entity);
                    em.getTransaction().commit();
                    if (!clearL1Cache) continue;
                    em.clear();
                }
            }
            catch (Exception exception) {
                TestInheritanceWithMSCID.fail((String)("Test failed with Exception\n" + exception));
            }
            idx = 0;
            for (boolean[] acceptenceMap : acceptenceMapping) {
                int expectedQueryResultListSize = 0;
                for (boolean acceptence : acceptenceMap) {
                    if (!acceptence) continue;
                    ++expectedQueryResultListSize;
                }
                String queryStr = "SELECT e FROM " + tEntities[idx].getEntityName() + " e";
                List resultList = em.createQuery(queryStr).getResultList();
                TestInheritanceWithMSCID.assertEquals((String)("Assert the following query creates a result list with " + expectedQueryResultListSize + " entities: " + "\"" + queryStr + "\".  "), (int)expectedQueryResultListSize, (int)resultList.size());
                ++idx;
                if (!clearL1Cache) continue;
                em.clear();
            }
        }
        em.close();
    }

    public void testQuery001WithL1() {
        this.query001TestLogic(false);
    }

    public void testQuery001NoL1() {
        this.query001TestLogic(true);
    }
}

