/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance.jointable;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.inheritance.jointable.Contractor;
import org.apache.openjpa.persistence.inheritance.jointable.Department;
import org.apache.openjpa.persistence.inheritance.jointable.Employee;
import org.apache.openjpa.persistence.inheritance.jointable.FulltimeEmployee;
import org.apache.openjpa.persistence.inheritance.jointable.ParttimeEmployee;
import org.apache.openjpa.persistence.inheritance.jointable.Person;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestInheritanceTypeJoinedQuery
extends SQLListenerTestCase {
    private int numPTEmployees = 1;
    private int numFTEmployees = 2;
    private int numContractors = 3;

    @Override
    public void setUp() {
        this.setUp(Contractor.class, Employee.class, Department.class, Person.class, FulltimeEmployee.class, ParttimeEmployee.class, CLEAR_TABLES);
        this.populate();
    }

    public void populate() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Department d = new Department("IT");
        for (i = 0; i < this.numContractors; ++i) {
            Contractor c = new Contractor("ctr" + i);
            c.setDept(d);
            em.persist((Object)c);
        }
        em.persist((Object)d);
        for (i = 0; i < this.numFTEmployees; ++i) {
            FulltimeEmployee f = new FulltimeEmployee("ftemp" + i);
            f.setDept(d);
            em.persist((Object)f);
        }
        for (i = 0; i < this.numPTEmployees; ++i) {
            ParttimeEmployee p = new ParttimeEmployee("ptemp" + i);
            p.setDept(d);
            em.persist((Object)p);
        }
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.close();
    }

    public void testInheritanceJoinedTypeOperator() {
        Object obj;
        int i;
        int i2;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = null;
        String qS = null;
        List rs = null;
        qS = "SELECT p FROM Person p where TYPE(p) <> Contractor";
        q = em.createQuery(qS);
        rs = q.getResultList();
        TestInheritanceTypeJoinedQuery.assertEquals((int)(this.numPTEmployees + this.numFTEmployees), (int)rs.size());
        for (i2 = 0; i2 < rs.size(); ++i2) {
            Object obj2 = rs.get(i2);
            TestInheritanceTypeJoinedQuery.assertTrue((obj2 instanceof ParttimeEmployee || obj2 instanceof FulltimeEmployee ? 1 : 0) != 0);
        }
        qS = "SELECT p FROM Person p where TYPE(p) = Contractor";
        q = em.createQuery(qS);
        rs = q.getResultList();
        TestInheritanceTypeJoinedQuery.assertEquals((int)this.numContractors, (int)rs.size());
        for (i2 = 0; i2 < rs.size(); ++i2) {
            TestInheritanceTypeJoinedQuery.assertTrue((boolean)(rs.get(i2) instanceof Contractor));
        }
        qS = "select p from Person p where TYPE(p) in (?1) order by p.name";
        q = em.createQuery(qS).setParameter(1, Contractor.class);
        rs = q.getResultList();
        TestInheritanceTypeJoinedQuery.assertEquals((int)this.numContractors, (int)rs.size());
        for (i2 = 0; i2 < rs.size(); ++i2) {
            TestInheritanceTypeJoinedQuery.assertTrue((boolean)(rs.get(i2) instanceof Contractor));
        }
        qS = "select p from Person p where TYPE(p) in ?1 order by p.name";
        ArrayList<Class> params = new ArrayList<Class>(2);
        params.add(Contractor.class);
        params.add(Employee.class);
        try {
            q = em.createQuery(qS).setParameter(1, params);
            rs = q.getResultList();
        }
        catch (ArgumentException e) {
            // empty catch block
        }
        qS = "SELECT p FROM Person p where TYPE(p) = Contractor AND p.name = 'Name ctr0'";
        q = em.createQuery(qS);
        rs = q.getResultList();
        TestInheritanceTypeJoinedQuery.assertEquals((int)1, (int)rs.size());
        for (i = 0; i < rs.size(); ++i) {
            TestInheritanceTypeJoinedQuery.assertTrue((boolean)(rs.get(i) instanceof Contractor));
        }
        qS = "select p from Person p where TYPE(p) in (?1, ?2) and p.name = ?3 order by p.name";
        q = em.createQuery(qS);
        q.setParameter(1, Contractor.class);
        q.setParameter(2, FulltimeEmployee.class);
        q.setParameter(3, (Object)"Name ctr0");
        rs = q.getResultList();
        TestInheritanceTypeJoinedQuery.assertEquals((int)1, (int)rs.size());
        for (i = 0; i < rs.size(); ++i) {
            obj = rs.get(i);
            TestInheritanceTypeJoinedQuery.assertTrue((obj instanceof Contractor || obj instanceof FulltimeEmployee ? 1 : 0) != 0);
        }
        qS = "select p from Person p where TYPE(p) in (?1, ?2) order by p.name";
        q = em.createQuery(qS);
        q.setParameter(1, Contractor.class);
        q.setParameter(2, FulltimeEmployee.class);
        rs = q.getResultList();
        TestInheritanceTypeJoinedQuery.assertEquals((int)(this.numContractors + this.numFTEmployees), (int)rs.size());
        for (i = 0; i < rs.size(); ++i) {
            obj = rs.get(i);
            TestInheritanceTypeJoinedQuery.assertTrue((obj instanceof Contractor || obj instanceof FulltimeEmployee ? 1 : 0) != 0);
        }
        qS = "select p from Person p where TYPE(p) not in (Contractor) order by p.name";
        q = em.createQuery(qS);
        rs = q.getResultList();
        TestInheritanceTypeJoinedQuery.assertEquals((int)(this.numPTEmployees + this.numFTEmployees), (int)rs.size());
        for (i = 0; i < rs.size(); ++i) {
            obj = rs.get(i);
            TestInheritanceTypeJoinedQuery.assertTrue((obj instanceof ParttimeEmployee || obj instanceof FulltimeEmployee ? 1 : 0) != 0);
        }
        qS = "select p from Person p where TYPE(p) not in (?1) order by p.name";
        q = em.createQuery(qS);
        q.setParameter(1, Contractor.class);
        rs = q.getResultList();
        TestInheritanceTypeJoinedQuery.assertEquals((int)(this.numPTEmployees + this.numFTEmployees), (int)rs.size());
        for (i = 0; i < rs.size(); ++i) {
            obj = rs.get(i);
            TestInheritanceTypeJoinedQuery.assertTrue((obj instanceof ParttimeEmployee || obj instanceof FulltimeEmployee ? 1 : 0) != 0);
        }
        qS = "select p from Person p where TYPE(p) not in (?1, ?2) order by p.name";
        q = em.createQuery(qS);
        q.setParameter(1, Contractor.class);
        q.setParameter(2, FulltimeEmployee.class);
        rs = q.getResultList();
        TestInheritanceTypeJoinedQuery.assertEquals((int)this.numPTEmployees, (int)rs.size());
        for (i = 0; i < rs.size(); ++i) {
            obj = rs.get(i);
            TestInheritanceTypeJoinedQuery.assertTrue((obj instanceof ParttimeEmployee || obj instanceof FulltimeEmployee ? 1 : 0) != 0);
        }
        em.close();
    }

    public void testInheritanceTypeJoinedQuery() {
        Long oid;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = null;
        String qS = null;
        Department dept = null;
        qS = "SELECT c.OID, c.dept FROM Department d, Contractor c where d.OID = c.dept.OID and d.description = 'IT'";
        q = em.createQuery(qS);
        List lResult = q.getResultList();
        for (Object resultElement : lResult) {
            oid = (Long)resultElement[0];
            dept = (Department)resultElement[1];
        }
        qS = "SELECT c.OID FROM Department d, Contractor c where d.OID = c.dept.OID and d.description = 'IT'";
        q = em.createQuery(qS);
        for (Object resultElement : q.getResultList()) {
            oid = (Long)resultElement;
        }
        qS = "SELECT d FROM Department d, Contractor c where d.OID = c.dept.OID and d.description = 'IT'";
        q = em.createQuery(qS);
        for (Object aResult : q.getResultList()) {
            TestInheritanceTypeJoinedQuery.assertEquals((long)dept.getOID(), (long)((Department)aResult).getOID());
        }
        qS = "SELECT c FROM Department d, Contractor c  where d.OID = c.dept.OID and d.description = 'IT'";
        q = em.createQuery(qS);
        for (Object aResult : q.getResultList()) {
            TestInheritanceTypeJoinedQuery.assertEquals((long)dept.getOID(), (long)((Contractor)aResult).getDept().getOID());
        }
        qS = "SELECT c FROM Contractor c, Department d  where d.OID = c.dept.OID and d.description = 'IT'";
        q = em.createQuery(qS);
        for (Object aResult : q.getResultList()) {
            TestInheritanceTypeJoinedQuery.assertEquals((long)dept.getOID(), (long)((Contractor)aResult).getDept().getOID());
        }
        qS = "SELECT c, c.OID FROM Department d, Contractor c where d.OID = c.dept.OID and d.description = 'IT'";
        q = em.createQuery(qS);
        List cResult = q.getResultList();
        Contractor contractor = null;
        for (Object[] resultElement : cResult) {
            contractor = (Contractor)resultElement[0];
            Long oid2 = (Long)resultElement[1];
            TestInheritanceTypeJoinedQuery.assertTrue((contractor.getOID() == oid2.longValue() ? 1 : 0) != 0);
            TestInheritanceTypeJoinedQuery.assertEquals((long)dept.getOID(), (long)contractor.getDept().getOID());
        }
        qS = "SELECT c.OID, c FROM Contractor c, Department d where d.OID = c.dept.OID and d.description = 'IT'";
        q = em.createQuery(qS);
        List dResult = q.getResultList();
        for (Object[] resultElement : dResult) {
            Long oid3 = (Long)resultElement[0];
            contractor = (Contractor)resultElement[1];
            TestInheritanceTypeJoinedQuery.assertTrue((contractor.getOID() == oid3.longValue() ? 1 : 0) != 0);
            TestInheritanceTypeJoinedQuery.assertEquals((long)dept.getOID(), (long)contractor.getDept().getOID());
        }
        qS = "SELECT c, c.OID FROM Department d, Contractor c where d.OID = c.dept.OID and d.description = 'IT'";
        q = em.createQuery(qS);
        List eResult = q.getResultList();
        for (Object[] resultElement : eResult) {
            Long oid4 = (Long)resultElement[1];
            contractor = (Contractor)resultElement[0];
            TestInheritanceTypeJoinedQuery.assertTrue((contractor.getOID() == oid4.longValue() ? 1 : 0) != 0);
            TestInheritanceTypeJoinedQuery.assertEquals((long)dept.getOID(), (long)contractor.getDept().getOID());
        }
        qS = "SELECT c.OID, c FROM Department d, Contractor c where d.OID = c.dept.OID and d.description = 'IT'";
        q = em.createQuery(qS);
        List fResult = q.getResultList();
        for (Object[] resultElement : fResult) {
            Long oid5 = (Long)resultElement[0];
            Contractor c = (Contractor)resultElement[1];
            TestInheritanceTypeJoinedQuery.assertTrue((oid5.longValue() == c.getOID() ? 1 : 0) != 0);
            TestInheritanceTypeJoinedQuery.assertEquals((long)dept.getOID(), (long)c.getDept().getOID());
        }
        qS = "SELECT d,c FROM Department d, Contractor c where d.OID = c.dept.OID and d.description = 'IT'  and c = ?1";
        q = em.createQuery(qS);
        q.setParameter(1, (Object)contractor);
        for (Object[] aResult : q.getResultList()) {
            System.out.println(((Department)aResult[0]).getOID() + ", " + ((Contractor)aResult[1]).getOID());
            TestInheritanceTypeJoinedQuery.assertTrue((boolean)contractor.equals(aResult[1]));
        }
        qS = "SELECT c,d FROM Contractor c, Department d where d.OID = c.dept.OID and d.description = 'IT'  and c = ?1";
        q = em.createQuery(qS);
        q.setParameter(1, (Object)contractor);
        for (Object[] aResult : q.getResultList()) {
            System.out.println(((Contractor)aResult[0]).getOID() + ", " + ((Department)aResult[1]).getOID());
            TestInheritanceTypeJoinedQuery.assertTrue((boolean)contractor.equals(aResult[0]));
        }
        qS = "SELECT p FROM Person p ";
        q = em.createQuery(qS);
        List rs = q.getResultList();
        TestInheritanceTypeJoinedQuery.assertEquals((int)(this.numPTEmployees + this.numFTEmployees + this.numContractors), (int)rs.size());
        for (Object aResult : rs) {
            TestInheritanceTypeJoinedQuery.assertTrue((boolean)(aResult instanceof Person));
        }
        em.close();
    }
}

