/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance.jointable.onetomany;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityTransaction;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.inheritance.jointable.onetomany.UMLClass;
import org.apache.openjpa.persistence.inheritance.jointable.onetomany.UMLNamed;
import org.apache.openjpa.persistence.inheritance.jointable.onetomany.UMLPackage;
import org.apache.openjpa.persistence.inheritance.jointable.onetomany.UMLPrimitiveType;
import org.apache.openjpa.persistence.inheritance.jointable.onetomany.UMLType;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestJointableOneToMany
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(UMLType.class, UMLPrimitiveType.class, UMLClass.class, UMLPackage.class, UMLNamed.class, CLEAR_TABLES);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            UMLPackage aPackage = (UMLPackage)em.find(UMLPackage.class, (Object)"org.apache.openjpa");
            if (null == aPackage) {
                EntityTransaction tx = em.getTransaction();
                tx.begin();
                aPackage = new UMLPackage();
                aPackage.setId("org.apache.openjpa");
                aPackage.setName("org.apache.openjpa");
                aPackage.setOwnedType(new ArrayList<UMLType>());
                em.persist((Object)aPackage);
                UMLClass aClass = new UMLClass();
                aClass.setId("org.apache.openjpa.ATestClass");
                aClass.setName("TesClass");
                aClass.setOwnerPackage(aPackage);
                em.persist((Object)aClass);
                aPackage.getOwnedType().add(aClass);
                em.merge((Object)aPackage);
                UMLPrimitiveType primitiveType = new UMLPrimitiveType();
                primitiveType.setId("String");
                primitiveType.setName("String");
                primitiveType.setOwnerPackage(aPackage);
                em.persist((Object)primitiveType);
                aPackage.getOwnedType().add(primitiveType);
                em.merge((Object)aPackage);
                tx.commit();
            }
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            UMLClass aClass = (UMLClass)em.find(UMLClass.class, (Object)"org.apache.openjpa.ATestClass");
            TestJointableOneToMany.assertNotNull((Object)aClass);
            TestJointableOneToMany.assertEquals((String)"org.apache.openjpa", (String)aClass.getOwnerPackage().getName());
            UMLPrimitiveType aPrimitiveType = (UMLPrimitiveType)em.find(UMLPrimitiveType.class, (Object)"String");
            TestJointableOneToMany.assertNotNull((Object)aPrimitiveType);
            TestJointableOneToMany.assertEquals((String)"org.apache.openjpa", (String)aPrimitiveType.getOwnerPackage().getName());
            UMLPackage aPackage = (UMLPackage)em.find(UMLPackage.class, (Object)"org.apache.openjpa");
            TestJointableOneToMany.assertNotNull((Object)aPackage);
            List<UMLType> ownedType = aPackage.getOwnedType();
            TestJointableOneToMany.assertNotNull(ownedType);
            TestJointableOneToMany.assertEquals((int)2, (int)ownedType.size());
        }
        finally {
            em.close();
        }
    }
}

