/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance.jointable.onetomany;

import javax.persistence.EntityTransaction;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.common.apps.Part;
import org.apache.openjpa.persistence.common.apps.PartPK;
import org.apache.openjpa.persistence.common.apps.Shirt;
import org.apache.openjpa.persistence.common.apps.Textile;
import org.apache.openjpa.persistence.common.apps.TextilePK;
import org.apache.openjpa.persistence.common.apps.Trousers;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMapsIdWithAutoGeneratedKey
extends SingleEMFTestCase {
    boolean disabled = true;

    @Override
    public void setUp() {
        super.setUp(DROP_TABLES, Textile.class, TextilePK.class, Shirt.class, Trousers.class, Part.class, PartPK.class);
        DBDictionary dic = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
        if (dic.supportsAutoAssign && (dic instanceof DB2Dictionary || dic instanceof DerbyDictionary)) {
            this.disabled = false;
        }
    }

    public void testPersistShirtWithPart() {
        if (this.disabled) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tx = em.getTransaction();
        int nPart = 3;
        tx.begin();
        Shirt shirt = new Shirt();
        String name = "Shirt: " + System.currentTimeMillis();
        shirt.setTxeName(name);
        String size = "L";
        shirt.setSzeId(size);
        int pid = (int)System.currentTimeMillis();
        for (int i = 0; i < nPart; ++i) {
            Part part = new Part();
            part.setPartName("Part");
            part.getId().setPartNumber(pid++);
            part.setShirt(shirt);
            shirt.getParts().add(part);
        }
        em.persist((Object)shirt);
        tx.commit();
        em.close();
        int sid = shirt.getTextileId();
        em = this.emf.createEntityManager();
        shirt = (Shirt)em.find(Shirt.class, (Object)sid);
        TestMapsIdWithAutoGeneratedKey.assertNotNull((Object)shirt);
        TestMapsIdWithAutoGeneratedKey.assertNotNull(shirt.getParts());
        TestMapsIdWithAutoGeneratedKey.assertEquals((int)nPart, (int)shirt.getParts().size());
    }
}

