/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance.serializable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.inheritance.serializable.Employee;
import org.apache.openjpa.persistence.inheritance.serializable.Person;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestSerialization
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(Person.class, Employee.class, DROP_TABLES, "openjpa.DetachState", "fgs(DetachedStateField=true)");
    }

    public void testDetachedUpdate() {
        Employee emp = new Employee();
        emp.setFirstName("John");
        emp.setLastName("Doe");
        emp.setSalary(15000.0f);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)emp);
        em.refresh((Object)emp);
        int id = emp.getId();
        em.getTransaction().commit();
        em.clear();
        emp.setFirstName("Jane");
        Employee deserialized = (Employee)this.serializeObject(emp);
        TestSerialization.assertNotNull((Object)deserialized);
        TestSerialization.assertEquals((Object)emp, (Object)deserialized);
        em.getTransaction().begin();
        em.merge((Object)deserialized);
        em.getTransaction().commit();
        em.clear();
        emp = (Employee)em.find(Employee.class, (Object)id);
        TestSerialization.assertEquals((Object)deserialized, (Object)emp);
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object serializeObject(Object orig) {
        Object deserialized = null;
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(orig);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ois = new ObjectInputStream(bais);
            deserialized = ois.readObject();
        }
        catch (Exception e) {
            TestSerialization.fail((String)e.toString());
        }
        finally {
            try {
                oos.close();
                ois.close();
            }
            catch (IOException e) {}
        }
        return deserialized;
    }
}

