/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.regexp.RE;

public class SQLSniffer {
    private static Map<String, RE> cache = new HashMap<String, RE>();

    public static boolean matches(List<String> SQLs, String ... regexes) {
        if (SQLs == null || regexes == null) {
            return false;
        }
        for (String sql : SQLs) {
            boolean matched = true;
            for (String key : regexes) {
                RE regex = SQLSniffer.getRegularExpression(key);
                if (regex.match(sql)) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return true;
        }
        return false;
    }

    private static RE getRegularExpression(String regex) {
        if (cache.containsKey(regex)) {
            return cache.get(regex);
        }
        RE re = new RE(regex);
        cache.put(regex, re);
        return re;
    }
}

