/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import junit.framework.TestCase;
import org.apache.openjpa.jdbc.kernel.EagerFetchModes;
import org.apache.openjpa.jdbc.kernel.LRSSizes;
import org.apache.openjpa.jdbc.sql.JoinSyntaxes;
import org.apache.openjpa.persistence.jdbc.FetchDirection;
import org.apache.openjpa.persistence.jdbc.FetchMode;
import org.apache.openjpa.persistence.jdbc.JoinSyntax;
import org.apache.openjpa.persistence.jdbc.LRSSizeAlgorithm;
import org.apache.openjpa.persistence.jdbc.ResultSetType;

public class TestJDBCEnumToKernelConstantMappings
extends TestCase {
    public void testEagerFetchModes() {
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)0, (int)FetchMode.NONE.toKernelConstant());
        TestJDBCEnumToKernelConstantMappings.assertEquals((Object)FetchMode.NONE, (Object)FetchMode.fromKernelConstant((int)0));
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)FetchMode.NONE.toKernelConstant(), (int)FetchMode.NONE.ordinal());
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)1, (int)FetchMode.JOIN.toKernelConstant());
        TestJDBCEnumToKernelConstantMappings.assertEquals((Object)FetchMode.JOIN, (Object)FetchMode.fromKernelConstant((int)1));
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)FetchMode.JOIN.toKernelConstant(), (int)FetchMode.JOIN.ordinal());
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)2, (int)FetchMode.PARALLEL.toKernelConstant());
        TestJDBCEnumToKernelConstantMappings.assertEquals((Object)FetchMode.PARALLEL, (Object)FetchMode.fromKernelConstant((int)2));
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)FetchMode.PARALLEL.toKernelConstant(), (int)FetchMode.PARALLEL.ordinal());
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)this.getConstantCount(EagerFetchModes.class), (int)FetchMode.values().length);
    }

    public void testLRSSizeType() {
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)0, (int)LRSSizeAlgorithm.UNKNOWN.toKernelConstant());
        TestJDBCEnumToKernelConstantMappings.assertEquals((Object)LRSSizeAlgorithm.UNKNOWN, (Object)LRSSizeAlgorithm.fromKernelConstant((int)0));
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)LRSSizeAlgorithm.UNKNOWN.toKernelConstant(), (int)LRSSizeAlgorithm.UNKNOWN.ordinal());
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)1, (int)LRSSizeAlgorithm.LAST.toKernelConstant());
        TestJDBCEnumToKernelConstantMappings.assertEquals((Object)LRSSizeAlgorithm.LAST, (Object)LRSSizeAlgorithm.fromKernelConstant((int)1));
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)LRSSizeAlgorithm.LAST.toKernelConstant(), (int)LRSSizeAlgorithm.LAST.ordinal());
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)2, (int)LRSSizeAlgorithm.QUERY.toKernelConstant());
        TestJDBCEnumToKernelConstantMappings.assertEquals((Object)LRSSizeAlgorithm.QUERY, (Object)LRSSizeAlgorithm.fromKernelConstant((int)2));
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)LRSSizeAlgorithm.QUERY.toKernelConstant(), (int)LRSSizeAlgorithm.QUERY.ordinal());
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)this.getConstantCount(LRSSizes.class), (int)LRSSizeAlgorithm.values().length);
    }

    public void testJoinSyntaxType() {
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)0, (int)JoinSyntax.SQL92.toKernelConstant());
        TestJDBCEnumToKernelConstantMappings.assertEquals((Object)JoinSyntax.SQL92, (Object)JoinSyntax.fromKernelConstant((int)0));
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)JoinSyntax.SQL92.toKernelConstant(), (int)JoinSyntax.SQL92.ordinal());
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)1, (int)JoinSyntax.TRADITIONAL.toKernelConstant());
        TestJDBCEnumToKernelConstantMappings.assertEquals((Object)JoinSyntax.TRADITIONAL, (Object)JoinSyntax.fromKernelConstant((int)1));
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)JoinSyntax.TRADITIONAL.toKernelConstant(), (int)JoinSyntax.TRADITIONAL.ordinal());
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)2, (int)JoinSyntax.DATABASE.toKernelConstant());
        TestJDBCEnumToKernelConstantMappings.assertEquals((Object)JoinSyntax.DATABASE, (Object)JoinSyntax.fromKernelConstant((int)2));
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)JoinSyntax.DATABASE.toKernelConstant(), (int)JoinSyntax.DATABASE.ordinal());
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)this.getConstantCount(JoinSyntaxes.class), (int)JoinSyntax.values().length);
    }

    public void testResultSetType() {
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)1003, (int)ResultSetType.FORWARD_ONLY.toKernelConstant());
        TestJDBCEnumToKernelConstantMappings.assertEquals((Object)ResultSetType.FORWARD_ONLY, (Object)ResultSetType.fromKernelConstant((int)1003));
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)1004, (int)ResultSetType.SCROLL_INSENSITIVE.toKernelConstant());
        TestJDBCEnumToKernelConstantMappings.assertEquals((Object)ResultSetType.SCROLL_INSENSITIVE, (Object)ResultSetType.fromKernelConstant((int)1004));
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)1005, (int)ResultSetType.SCROLL_SENSITIVE.toKernelConstant());
        TestJDBCEnumToKernelConstantMappings.assertEquals((Object)ResultSetType.SCROLL_SENSITIVE, (Object)ResultSetType.fromKernelConstant((int)1005));
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)3, (int)ResultSetType.values().length);
    }

    public void testFetchDirection() {
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)1000, (int)FetchDirection.FORWARD.toKernelConstant());
        TestJDBCEnumToKernelConstantMappings.assertEquals((Object)FetchDirection.FORWARD, (Object)FetchDirection.fromKernelConstant((int)1000));
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)1001, (int)FetchDirection.REVERSE.toKernelConstant());
        TestJDBCEnumToKernelConstantMappings.assertEquals((Object)FetchDirection.REVERSE, (Object)FetchDirection.fromKernelConstant((int)1001));
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)1002, (int)FetchDirection.UNKNOWN.toKernelConstant());
        TestJDBCEnumToKernelConstantMappings.assertEquals((Object)FetchDirection.UNKNOWN, (Object)FetchDirection.fromKernelConstant((int)1002));
        TestJDBCEnumToKernelConstantMappings.assertEquals((int)3, (int)FetchDirection.values().length);
    }

    private int getConstantCount(Class cls) {
        return cls.getDeclaredFields().length;
    }
}

