/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import javax.persistence.Query;
import javax.persistence.RollbackException;
import junit.framework.AssertionFailedError;
import org.apache.openjpa.jdbc.sql.SybaseDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.kernel.common.apps.Blobs;
import org.apache.openjpa.persistence.kernel.common.apps.Lobs;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestLobs
extends SingleEMFTestCase {
    public static Byte randomByte() {
        return new Byte((byte)(Math.random() * 127.0));
    }

    @Override
    public void setUp() throws Exception {
        super.setUp(DROP_TABLES, Lobs.class, Blobs.class);
    }

    public void testBlobSetToNull() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Blobs lobs = new Blobs();
        lobs.setLobNotNullable(null);
        lobs.setLobNullable(null);
        em.persist((Object)lobs);
        try {
            em.getTransaction().commit();
            TestLobs.fail((String)"Expected a RollbackException");
        }
        catch (Exception e) {
            this.assertError(e, RollbackException.class);
        }
        em.close();
    }

    public void testBlobPersistQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Blobs lobs = new Blobs();
        byte[] bytes = new byte[10];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = TestLobs.randomByte();
        }
        em.getTransaction().begin();
        lobs.setLobNotNullable(bytes);
        lobs.setLobNullable(null);
        em.persist((Object)lobs);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createQuery("select e from Blobs e");
        lobs = (Blobs)query.getSingleResult();
        TestLobs.assertTrue((lobs.getLobNullable() == null || lobs.getLobNullable().length == 0 ? 1 : 0) != 0);
        em.remove((Object)lobs);
        em.getTransaction().commit();
        em.close();
    }

    public void testBlobZeroLengthByteArray() throws Exception {
        byte[] bytes = new byte[]{};
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Blobs lobs = new Blobs();
        em.getTransaction().begin();
        lobs.setLobNotNullable(bytes);
        lobs.setLobNullable(bytes);
        em.persist((Object)lobs);
        try {
            em.getTransaction().commit();
        }
        catch (Exception e) {
            if (this.getDBDictionary() instanceof SybaseDictionary) {
                TestLobs.assertTrue((boolean)(e instanceof RollbackException));
                return;
            }
            throw e;
        }
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createQuery("select e from Blobs e");
        lobs = (Blobs)query.getSingleResult();
        TestLobs.assertTrue((lobs.getLobNullable() == null || lobs.getLobNullable().length == 0 ? 1 : 0) != 0);
        TestLobs.assertTrue((lobs.getLobNotNullable() == null || lobs.getLobNotNullable().length == 0 ? 1 : 0) != 0);
        for (int i = 0; i < bytes.length; ++i) {
            TestLobs.assertEquals((byte)bytes[i], (byte)lobs.getLobNullable()[i]);
        }
        em.remove((Object)lobs);
        em.getTransaction().commit();
        em.close();
    }

    public void testBlobLargeData() {
        byte[] bytes = new byte[5000];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = TestLobs.randomByte();
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Blobs lobs = new Blobs();
        em.getTransaction().begin();
        lobs.setLobNotNullable(bytes);
        lobs.setLobNullable(bytes);
        em.persist((Object)lobs);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createQuery("select e from Blobs e");
        lobs = (Blobs)query.getSingleResult();
        for (int i = 0; i < 5000; ++i) {
            TestLobs.assertEquals((byte)lobs.getLobNullable()[i], (byte)lobs.getLobNotNullable()[i]);
            TestLobs.assertEquals((byte)bytes[i], (byte)lobs.getLobNullable()[i]);
        }
        em.remove((Object)lobs);
        em.getTransaction().commit();
        em.close();
    }

    public void testLobPersistQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Lobs lobs = new Lobs();
        em.getTransaction().begin();
        lobs.setLobNotNullable("test");
        lobs.setLobNullable(null);
        em.persist((Object)lobs);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createQuery("select e from Lobs e");
        lobs = (Lobs)query.getSingleResult();
        TestLobs.assertTrue((lobs.getLobNullable() == null || lobs.getLobNullable().length() == 0 ? 1 : 0) != 0);
        em.remove((Object)lobs);
        em.getTransaction().commit();
        em.close();
    }

    public void testLobSetToNull() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Lobs lobs = new Lobs();
        lobs.setLobNotNullable(null);
        lobs.setLobNullable(null);
        em.persist((Object)lobs);
        try {
            em.getTransaction().commit();
            TestLobs.fail((String)"Expected a RollbackException");
        }
        catch (Exception e) {
            this.assertError(e, RollbackException.class);
        }
        em.close();
    }

    public void testLobEmptyString() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Lobs lobs = new Lobs();
        em.getTransaction().begin();
        lobs.setLobNullable("");
        em.persist((Object)lobs);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createQuery("select e from Lobs e");
        lobs = (Lobs)query.getSingleResult();
        if (lobs.getLobNullable() != null) {
            if (this.getDBDictionary() instanceof SybaseDictionary) {
                TestLobs.assertEquals((String)" ", (String)lobs.getLobNullable());
            } else {
                TestLobs.assertEquals((int)0, (int)lobs.getLobNullable().length());
            }
        }
        if (lobs.getLobNotNullable() != null) {
            if (this.getDBDictionary() instanceof SybaseDictionary) {
                TestLobs.assertEquals((String)" ", (String)lobs.getLobNotNullable());
            } else {
                TestLobs.assertEquals((int)0, (int)lobs.getLobNotNullable().length());
            }
        }
        TestLobs.assertEquals((String)lobs.getLobNullable(), (String)lobs.getLobNotNullable());
        em.remove((Object)lobs);
        em.getTransaction().commit();
        em.close();
    }

    public void testLobLargeData() {
        String temp = "";
        for (int i = 0; i < 500; ++i) {
            temp = temp + "1234567890";
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Lobs lobs = new Lobs();
        em.getTransaction().begin();
        lobs.setLobNotNullable(temp);
        lobs.setLobNullable(temp);
        em.persist((Object)lobs);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createQuery("select e from Lobs e");
        lobs = (Lobs)query.getSingleResult();
        TestLobs.assertEquals((String)lobs.getLobNullable(), (String)lobs.getLobNotNullable());
        TestLobs.assertEquals((String)temp, (String)lobs.getLobNullable());
        em.remove((Object)lobs);
        em.getTransaction().commit();
        em.close();
    }

    void assertError(Throwable actual, Class<? extends Throwable> expected) {
        if (!expected.isAssignableFrom(actual.getClass())) {
            actual.printStackTrace();
            throw new AssertionFailedError(actual.getClass().getName() + " was raised but expected " + expected.getName());
        }
    }
}

