/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.HSQLDictionary;
import org.apache.openjpa.persistence.InvalidStateException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestOptimizeForClause
extends SQLListenerTestCase {
    @Override
    public void setUp() {
        this.setUp(AllFieldTypes.class);
    }

    public void testOptimizeForClauseViaGetSingleResult() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        DBDictionary dict = ((JDBCConfiguration)em.getConfiguration()).getDBDictionaryInstance();
        em.getTransaction().begin();
        AllFieldTypes a = new AllFieldTypes();
        a.setIntField(123);
        em.persist((Object)a);
        em.getTransaction().commit();
        em.clear();
        this.sql.clear();
        Object result = em.createQuery("select o from AllFieldTypes o where o.intField = 123").getSingleResult();
        TestOptimizeForClause.assertNotNull((Object)result);
        if (dict instanceof DB2Dictionary) {
            this.assertContainsSQL(" optimize for 1 row");
        }
        em.close();
    }

    public void testOptimizeForClauseViaHint() {
        this.tstOptimizeForClause(true, false, false);
    }

    public void testOptimizeForClauseViaFind() {
        this.tstOptimizeForClause(false, true, false);
    }

    public void testOptimizeForClauseViaQueryHint() {
        this.tstOptimizeForClause(false, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tstOptimizeForClause(boolean hint, boolean find, boolean queryHint) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        DBDictionary dict = ((JDBCConfiguration)em.getConfiguration()).getDBDictionaryInstance();
        if (dict instanceof HSQLDictionary) {
            return;
        }
        this.sql.clear();
        try {
            em.getTransaction().begin();
            if (hint || queryHint) {
                if (hint) {
                    OpenJPAQuery q = em.createQuery("select o from AllFieldTypes o where o.intField = :p");
                    q.setParameter("p", (Object)0);
                    q.setHint("openjpa.hint.OptimizeResultCount", (Object)new Integer(8));
                    q.getResultList();
                } else {
                    OpenJPAQuery q = OpenJPAPersistence.cast((Query)em.createQuery("select o from AllFieldTypes o where o.intField = :p"));
                    q.setParameter("p", (Object)0);
                    q.setHint("openjpa.hint.OptimizeResultCount", (Object)new Integer(8));
                    q.getResultList();
                }
                if (dict instanceof DB2Dictionary) {
                    TestOptimizeForClause.assertEquals((int)1, (int)this.sql.size());
                    this.assertContainsSQL(" optimize for 8 row");
                }
            } else {
                em.find(AllFieldTypes.class, (Object)0);
                if (dict instanceof DB2Dictionary) {
                    TestOptimizeForClause.assertEquals((int)1, (int)this.sql.size());
                    this.assertContainsSQL(" optimize for 1 row");
                }
            }
        }
        catch (InvalidStateException pe) {
            if (dict instanceof DB2Dictionary) {
                throw pe;
            }
        }
        finally {
            em.getTransaction().rollback();
            em.close();
        }
    }
}

