/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.HSQLDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestSelectForUpdateOverride
extends SQLListenerTestCase {
    @Override
    public void setUp() {
        this.setUp(AllFieldTypes.class, "openjpa.Optimistic", "false", "openjpa.LockManager", "pessimistic", "openjpa.ReadLockLevel", "none");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSelectForUpdateOverride() {
        OpenJPAEntityManagerSPI em = (OpenJPAEntityManagerSPI)OpenJPAPersistence.cast((EntityManager)this.emf.createEntityManager());
        DBDictionary dict = ((JDBCConfiguration)em.getConfiguration()).getDBDictionaryInstance();
        if (dict instanceof HSQLDictionary) {
            return;
        }
        this.sql.clear();
        try {
            em.getTransaction().begin();
            OpenJPAPersistence.cast((EntityManager)em).getFetchPlan().setReadLockMode(LockModeType.WRITE);
            em.find(AllFieldTypes.class, (Object)0);
            TestSelectForUpdateOverride.assertEquals((int)1, (int)this.sql.size());
            if (dict instanceof DB2Dictionary) {
                int db2server = ((DB2Dictionary)dict).getDb2ServerType();
                if (db2server == 1 || db2server == 2) {
                    TestSelectForUpdateOverride.assertEquals((int)1, (int)this.sql.size());
                    this.assertContainsSQL(" optimize for 1 row FOR UPDATE");
                } else if (db2server == 3 || db2server == 4) {
                    TestSelectForUpdateOverride.assertEquals((int)1, (int)this.sql.size());
                    this.assertContainsSQL(" optimize for 1 row FOR READ ONLY WITH RS USE AND KEEP UPDATE LOCKS");
                } else if (db2server == 5) {
                    TestSelectForUpdateOverride.assertEquals((int)1, (int)this.sql.size());
                    this.assertContainsSQL(" optimize for 1 row FOR READ ONLY WITH RS USE AND KEEP EXCLUSIVE LOCKS");
                } else {
                    TestSelectForUpdateOverride.fail((String)"OpenJPA currently only supports per-query isolation level configuration on the following databases: DB2");
                }
            }
        }
        finally {
            em.getTransaction().rollback();
            em.close();
        }
    }
}

