/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import javax.persistence.InheritanceType;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.annotations.AnnoTest1;
import org.apache.openjpa.persistence.jdbc.annotations.AnnoTest2;
import org.apache.openjpa.persistence.jdbc.annotations.Flat1;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestEnumerated
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(AnnoTest1.class, AnnoTest2.class, Flat1.class, CLEAR_TABLES);
    }

    public void testMapping() {
        ClassMapping cls = (ClassMapping)this.emf.getConfiguration().getMetaDataRepositoryInstance().getMetaData(AnnoTest1.class, null, true);
        FieldMapping fm = cls.getDeclaredFieldMapping("enumeration");
        TestEnumerated.assertNotNull((Object)fm);
        TestEnumerated.assertEquals((int)3, (int)fm.getManagement());
        TestEnumerated.assertEquals((int)32, (int)fm.getTypeCode());
        TestEnumerated.assertEquals((int)7, (int)fm.getColumns()[0].getJavaType());
        fm = cls.getDeclaredFieldMapping("ordinalEnumeration");
        TestEnumerated.assertNotNull((Object)fm);
        TestEnumerated.assertEquals((int)3, (int)fm.getManagement());
        TestEnumerated.assertEquals((int)32, (int)fm.getTypeCode());
        TestEnumerated.assertEquals((int)7, (int)fm.getColumns()[0].getJavaType());
        fm = cls.getDeclaredFieldMapping("stringEnumeration");
        TestEnumerated.assertNotNull((Object)fm);
        TestEnumerated.assertEquals((int)3, (int)fm.getManagement());
        TestEnumerated.assertEquals((int)32, (int)fm.getTypeCode());
        TestEnumerated.assertEquals((int)9, (int)fm.getColumns()[0].getJavaType());
    }

    public void testBehavior() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 pc = new AnnoTest1(1L);
        pc.setEnumeration(InheritanceType.TABLE_PER_CLASS);
        pc.setOrdinalEnumeration(InheritanceType.TABLE_PER_CLASS);
        pc.setStringEnumeration(InheritanceType.JOINED);
        em.persist((Object)pc);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)new Long(1L));
        TestEnumerated.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)pc.getEnumeration());
        TestEnumerated.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)pc.getOrdinalEnumeration());
        TestEnumerated.assertEquals((Object)InheritanceType.JOINED, (Object)pc.getStringEnumeration());
        em.getTransaction().begin();
        pc.setEnumeration(InheritanceType.JOINED);
        pc.setOrdinalEnumeration(InheritanceType.JOINED);
        pc.setStringEnumeration(InheritanceType.TABLE_PER_CLASS);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)new Long(1L));
        TestEnumerated.assertEquals((Object)InheritanceType.JOINED, (Object)pc.getEnumeration());
        TestEnumerated.assertEquals((Object)InheritanceType.JOINED, (Object)pc.getOrdinalEnumeration());
        TestEnumerated.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)pc.getStringEnumeration());
        em.close();
    }
}

