/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.strats.RelationMapInverseKeyFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationMapTableFieldStrategy;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.annotations.AnnoTest1;
import org.apache.openjpa.persistence.jdbc.annotations.AnnoTest2;
import org.apache.openjpa.persistence.jdbc.annotations.Flat1;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMapKey
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(Flat1.class, AnnoTest1.class, AnnoTest2.class, CLEAR_TABLES);
    }

    public void testDefaultMapKeyMapping() {
        ClassMapping mapping = ((JDBCConfiguration)this.emf.getConfiguration()).getMappingRepositoryInstance().getMapping(AnnoTest1.class, null, true);
        FieldMapping fm = mapping.getFieldMapping("defaultMapKey");
        TestMapKey.assertTrue((boolean)(fm.getStrategy() instanceof RelationMapTableFieldStrategy));
        TestMapKey.assertEquals((String)"pk", (String)fm.getKey().getValueMappedBy());
        TestMapKey.assertEquals((Object)mapping.getRepository().getMetaData(Flat1.class, null, true).getField("pk"), (Object)fm.getKey().getValueMappedByMetaData());
    }

    public void testNamedMapKeyMapping() {
        ClassMapping mapping = ((JDBCConfiguration)this.emf.getConfiguration()).getMappingRepositoryInstance().getMapping(AnnoTest1.class, null, true);
        FieldMapping fm = mapping.getFieldMapping("namedMapKey");
        TestMapKey.assertTrue((boolean)(fm.getStrategy() instanceof RelationMapTableFieldStrategy));
        TestMapKey.assertEquals((String)"basic", (String)fm.getKey().getValueMappedBy());
        TestMapKey.assertEquals((Object)mapping.getRepository().getMetaData(Flat1.class, null, true).getField("basic"), (Object)fm.getKey().getValueMappedByMetaData());
    }

    public void testInverseOwnerMapKeyMapping() {
        ClassMapping mapping = ((JDBCConfiguration)this.emf.getConfiguration()).getMappingRepositoryInstance().getMapping(AnnoTest1.class, null, true);
        FieldMapping fm = mapping.getFieldMapping("inverseOwnerMapKey");
        TestMapKey.assertTrue((boolean)(fm.getStrategy() instanceof RelationMapInverseKeyFieldStrategy));
        TestMapKey.assertEquals((String)"basic", (String)fm.getKey().getValueMappedBy());
        TestMapKey.assertEquals((Object)mapping.getRepository().getMetaData(AnnoTest2.class, null, true).getField("basic"), (Object)fm.getKey().getValueMappedByMetaData());
    }

    public void testInsertAndRetrieve() {
        Flat1 f1 = new Flat1(1);
        f1.setBasic(100);
        Flat1 f2 = new Flat1(2);
        f2.setBasic(200);
        AnnoTest2 a1 = new AnnoTest2(1L, "1");
        a1.setBasic("100");
        AnnoTest2 a2 = new AnnoTest2(2L, "2");
        a2.setBasic("200");
        AnnoTest1 pc = new AnnoTest1(1L);
        pc.getDefaultMapKey().put(f1.getPk(), f1);
        pc.getDefaultMapKey().put(f2.getPk(), f2);
        pc.getNamedMapKey().put(f1.getBasic(), f1);
        pc.getNamedMapKey().put(f2.getBasic(), f2);
        pc.getInverseOwnerMapKey().put(a1.getBasic(), a1);
        pc.getInverseOwnerMapKey().put(a2.getBasic(), a2);
        a1.setOneManyOwner(pc);
        a2.setOneManyOwner(pc);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persistAll(new Object[]{pc, f1, f2, a1, a2});
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)new Long(1L));
        TestMapKey.assertEquals((int)2, (int)pc.getDefaultMapKey().size());
        TestMapKey.assertEquals((int)1, (int)pc.getDefaultMapKey().get(1).getPk());
        TestMapKey.assertEquals((int)2, (int)pc.getDefaultMapKey().get(2).getPk());
        TestMapKey.assertEquals((int)2, (int)pc.getNamedMapKey().size());
        TestMapKey.assertEquals((int)100, (int)pc.getNamedMapKey().get(100).getBasic());
        TestMapKey.assertEquals((int)200, (int)pc.getNamedMapKey().get(200).getBasic());
        TestMapKey.assertEquals((int)2, (int)pc.getInverseOwnerMapKey().size());
        TestMapKey.assertEquals((String)"100", (String)pc.getInverseOwnerMapKey().get("100").getBasic());
        TestMapKey.assertEquals((String)"200", (String)pc.getInverseOwnerMapKey().get("200").getBasic());
        em.close();
    }
}

