/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import java.awt.Point;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.strats.ClassNameDiscriminatorStrategy;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.PostgresDictionary;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.annotations.EmbedValue;
import org.apache.openjpa.persistence.jdbc.annotations.EmbedValue2;
import org.apache.openjpa.persistence.jdbc.annotations.EmbedValue3;
import org.apache.openjpa.persistence.jdbc.annotations.ExtensionsEntity;
import org.apache.openjpa.persistence.jdbc.annotations.NonstandardMappingEntity;
import org.apache.openjpa.persistence.jdbc.annotations.NonstandardMappingEntity3;
import org.apache.openjpa.persistence.jdbc.annotations.NonstandardMappingEntity4;
import org.apache.openjpa.persistence.jdbc.annotations.NonstandardMappingMappedSuper;
import org.apache.openjpa.persistence.jdbc.annotations.NonstandardMappingMappedSuper4;
import org.apache.openjpa.persistence.jdbc.annotations.PointHandler;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestNonstandardMappingAnnotations
extends SingleEMFTestCase {
    private ClassMapping _mapping;
    private DBDictionary _dict;

    @Override
    public void setUp() {
        this.setUp(NonstandardMappingEntity.class, NonstandardMappingEntity3.class, ExtensionsEntity.class, NonstandardMappingMappedSuper.class, EmbedValue2.class, EmbedValue3.class, EmbedValue.class, NonstandardMappingEntity4.class, NonstandardMappingMappedSuper4.class, CLEAR_TABLES, "Retain data after test run");
        this.emf.createEntityManager().close();
        JDBCConfiguration conf = (JDBCConfiguration)this.emf.getConfiguration();
        this._dict = conf.getDBDictionaryInstance();
        this._mapping = (ClassMapping)JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, NonstandardMappingEntity.class);
    }

    public void testNonpolymorphic() {
        FieldMapping fm = this._mapping.getFieldMapping("superRel");
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getPolymorphic());
        ValueMapping vm = this._mapping.getFieldMapping("joinCollection").getElementMapping();
        TestNonstandardMappingAnnotations.assertEquals((int)2, (int)vm.getPolymorphic());
        vm = this._mapping.getFieldMapping("joinMap").getKeyMapping();
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)vm.getPolymorphic());
        vm = this._mapping.getFieldMapping("joinMap").getElementMapping();
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)vm.getPolymorphic());
    }

    public void testDataStoreIdColumn() {
        TestNonstandardMappingAnnotations.assertEquals((String)"NONSTD_ENTITY", (String)this._mapping.getTable().getName());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)this._mapping.getIdentityType());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)this._mapping.getPrimaryKeyColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"OID", (String)this._mapping.getPrimaryKeyColumns()[0].getName());
    }

    public void testDiscriminator() {
        Discriminator disc = this._mapping.getDiscriminator();
        TestNonstandardMappingAnnotations.assertTrue((boolean)(disc.getStrategy() instanceof ClassNameDiscriminatorStrategy));
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)disc.getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"DISCRIM", (String)disc.getColumns()[0].getName());
    }

    public void testSuperclassOverride() {
        FieldMapping fm = this._mapping.getFieldMapping("superCollection");
        TestNonstandardMappingAnnotations.assertEquals((String)"SUP_COLL", (String)fm.getTable().getName());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getJoinForeignKey().getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"OWNER", (String)fm.getJoinForeignKey().getColumns()[0].getName());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getElementMapping().getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"SUP_ELEM", (String)fm.getElementMapping().getColumns()[0].getName());
        TestNonstandardMappingAnnotations.assertNull((Object)fm.getElementMapping().getValueIndex());
        TestNonstandardMappingAnnotations.assertNotNull((Object)fm.getJoinIndex());
    }

    public void testCustomField() {
        FieldMapping fm = this._mapping.getFieldMapping("custom");
        TestNonstandardMappingAnnotations.assertTrue((boolean)(fm.getHandler() instanceof PointHandler));
        TestNonstandardMappingAnnotations.assertEquals((int)2, (int)fm.getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"X_COL", (String)fm.getColumns()[0].getName());
        TestNonstandardMappingAnnotations.assertEquals((String)"Y_COL", (String)fm.getColumns()[1].getName());
        TestNonstandardMappingAnnotations.assertNotNull((Object)fm.getValueIndex());
    }

    public void testValueCollection() {
        FieldMapping fm = this._mapping.getFieldMapping("stringCollection");
        TestNonstandardMappingAnnotations.assertEquals((String)"STRINGS_COLL", (String)fm.getTable().getName());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getJoinForeignKey().getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"OWNER", (String)fm.getJoinForeignKey().getColumns()[0].getName());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getElementMapping().getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"STR_ELEM", (String)fm.getElementMapping().getColumns()[0].getName());
        TestNonstandardMappingAnnotations.assertEquals((int)127, (int)fm.getElementMapping().getColumns()[0].getSize());
        TestNonstandardMappingAnnotations.assertNotNull((Object)fm.getElementMapping().getValueIndex());
        TestNonstandardMappingAnnotations.assertNull((Object)fm.getJoinIndex());
    }

    public void testJoinCollection() {
        FieldMapping fm = this._mapping.getFieldMapping("joinCollection");
        TestNonstandardMappingAnnotations.assertEquals((String)"JOIN_COLL", (String)fm.getTable().getName());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getJoinForeignKey().getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"OWNER", (String)fm.getJoinForeignKey().getColumns()[0].getName());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getElementMapping().getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"JOIN_ELEM", (String)fm.getElementMapping().getColumns()[0].getName());
        this.assertForeignKey(fm.getJoinForeignKey());
        this.assertForeignKey(fm.getElementMapping().getForeignKey());
    }

    private void assertForeignKey(ForeignKey fk) {
        if (this._dict.supportsForeignKeys) {
            TestNonstandardMappingAnnotations.assertEquals((int)2, (int)fk.getDeleteAction());
        }
    }

    public void testValueMap() {
        FieldMapping fm = this._mapping.getFieldMapping("stringMap");
        TestNonstandardMappingAnnotations.assertEquals((String)"STRINGS_MAP", (String)fm.getTable().getName());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getJoinForeignKey().getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"OWNER", (String)fm.getJoinForeignKey().getColumns()[0].getName());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getKeyMapping().getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"STR_KEY", (String)fm.getKeyMapping().getColumns()[0].getName());
        TestNonstandardMappingAnnotations.assertEquals((int)127, (int)fm.getKeyMapping().getColumns()[0].getSize());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getElementMapping().getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"STR_VAL", (String)fm.getElementMapping().getColumns()[0].getName());
        TestNonstandardMappingAnnotations.assertEquals((int)127, (int)fm.getElementMapping().getColumns()[0].getSize());
        TestNonstandardMappingAnnotations.assertNull((Object)fm.getJoinIndex());
        TestNonstandardMappingAnnotations.assertNotNull((Object)fm.getKeyMapping().getValueIndex());
        TestNonstandardMappingAnnotations.assertNotNull((Object)fm.getElementMapping().getValueIndex());
    }

    public void testJoinMap() {
        FieldMapping fm = this._mapping.getFieldMapping("joinMap");
        TestNonstandardMappingAnnotations.assertEquals((String)"JOIN_MAP", (String)fm.getTable().getName());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getJoinForeignKey().getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"OWNER", (String)fm.getJoinForeignKey().getColumns()[0].getName());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getKeyMapping().getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"JOIN_KEY", (String)fm.getKeyMapping().getColumns()[0].getName());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getElementMapping().getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"JOIN_VAL", (String)fm.getElementMapping().getColumns()[0].getName());
        this.assertForeignKey(fm.getJoinForeignKey());
        this.assertForeignKey(fm.getKeyMapping().getForeignKey());
        this.assertForeignKey(fm.getElementMapping().getForeignKey());
    }

    public void testEmbeddedOverride() {
        FieldMapping fm = this._mapping.getFieldMapping("embed");
        TestNonstandardMappingAnnotations.assertTrue((boolean)fm.isEmbedded());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getColumns().length);
        TestNonstandardMappingAnnotations.assertTrue((boolean)"UUID_HEX".equalsIgnoreCase(fm.getColumns()[0].getName()));
        ClassMapping embed = fm.getEmbeddedMapping();
        fm = embed.getFieldMapping("rel");
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"EM_REL_ID", (String)fm.getColumns()[0].getName());
        fm = embed.getFieldMapping("eager");
        TestNonstandardMappingAnnotations.assertEquals((String)"EM_EAGER", (String)fm.getTable().getName());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getElementMapping().getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"ELEM_EAGER_ID", (String)fm.getElementMapping().getColumns()[0].getName());
    }

    public void testEmbeddedElementOverride() {
        FieldMapping fm = this._mapping.getFieldMapping("embedCollection");
        TestNonstandardMappingAnnotations.assertTrue((boolean)fm.getElement().isEmbedded());
        TestNonstandardMappingAnnotations.assertEquals((String)"EMBED_COLL", (String)fm.getTable().getName());
        TestNonstandardMappingAnnotations.assertEquals((int)0, (int)fm.getElementMapping().getColumns().length);
        ClassMapping embed = fm.getElementMapping().getEmbeddedMapping();
        fm = embed.getFieldMapping("basic");
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)fm.getColumns().length);
        TestNonstandardMappingAnnotations.assertEquals((String)"EM_BASIC", (String)fm.getColumns()[0].getName());
    }

    public void testInsertAndRetrieve() {
        if (this._dict instanceof PostgresDictionary) {
            return;
        }
        NonstandardMappingEntity pc = new NonstandardMappingEntity();
        pc.getSuperCollection().add("super");
        pc.setCustom(new Point(1, 2));
        pc.getStringCollection().add("string");
        NonstandardMappingEntity pc2 = new NonstandardMappingEntity();
        pc.getJoinCollection().add(pc2);
        pc.getStringMap().put("stringKey", "stringValue");
        NonstandardMappingEntity pc3 = new NonstandardMappingEntity();
        pc.getJoinMap().put(pc2, pc3);
        ExtensionsEntity embed = new ExtensionsEntity();
        embed.setExternalValues('M');
        embed.setExternalizer(String.class);
        pc.setEmbed(embed);
        EmbedValue2 embed2 = new EmbedValue2();
        embed2.setBasic("basic");
        pc.getEmbedCollection().add(embed2);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persistAll(new Object[]{pc, pc2, pc3});
        em.getTransaction().commit();
        Object pcId = em.getObjectId((Object)pc);
        Object pc2Id = em.getObjectId((Object)pc2);
        Object pc3Id = em.getObjectId((Object)pc3);
        em.close();
        em = this.emf.createEntityManager();
        pc = (NonstandardMappingEntity)em.find(NonstandardMappingEntity.class, pcId);
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)pc.getSuperCollection().size());
        TestNonstandardMappingAnnotations.assertEquals((String)"super", (String)pc.getSuperCollection().get(0));
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)pc.getCustom().x);
        TestNonstandardMappingAnnotations.assertEquals((int)2, (int)pc.getCustom().y);
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)pc.getStringCollection().size());
        TestNonstandardMappingAnnotations.assertEquals((Object)"string", pc.getStringCollection().get(0));
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)pc.getJoinCollection().size());
        TestNonstandardMappingAnnotations.assertEquals((Object)pc2Id, (Object)em.getObjectId((Object)pc.getJoinCollection().get(0)));
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)pc.getStringMap().size());
        TestNonstandardMappingAnnotations.assertEquals((Object)"stringValue", pc.getStringMap().get("stringKey"));
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)pc.getJoinMap().size());
        Map.Entry<NonstandardMappingEntity, NonstandardMappingEntity> entry = pc.getJoinMap().entrySet().iterator().next();
        TestNonstandardMappingAnnotations.assertEquals((Object)pc2Id, (Object)em.getObjectId((Object)entry.getKey()));
        TestNonstandardMappingAnnotations.assertEquals((Object)pc3Id, (Object)em.getObjectId((Object)entry.getValue()));
        TestNonstandardMappingAnnotations.assertEquals((char)'M', (char)pc.getEmbed().getExternalValues());
        TestNonstandardMappingAnnotations.assertEquals(String.class, (Object)pc.getEmbed().getExternalizer());
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)pc.getEmbedCollection().size());
        TestNonstandardMappingAnnotations.assertEquals((String)"basic", (String)pc.getEmbedCollection().get(0).getBasic());
        em.close();
    }

    public void testInsertAndRetrieveEmbeddedCollection() {
        NonstandardMappingEntity pc = new NonstandardMappingEntity();
        EmbedValue2 embed2 = new EmbedValue2();
        embed2.setBasic("basic");
        pc.getEmbedCollection().add(embed2);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)pc);
        em.getTransaction().commit();
        Object pcId = em.getObjectId((Object)pc);
        em.close();
        em = this.emf.createEntityManager();
        pc = (NonstandardMappingEntity)em.find(NonstandardMappingEntity.class, pcId);
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)pc.getEmbedCollection().size());
        TestNonstandardMappingAnnotations.assertEquals((String)"basic", (String)pc.getEmbedCollection().get(0).getBasic());
        em.close();
    }

    public void testInsertAndRetrieveEmbeddedObjectWithStrategy() {
        NonstandardMappingEntity3 pc = new NonstandardMappingEntity3();
        EmbedValue3 embed3 = new EmbedValue3();
        embed3.setBasic("basic");
        Point point = new Point();
        point.setLocation(1, 2);
        embed3.setPoint(point);
        pc.getEmbedVal3s().add(embed3);
        pc.setEmbedVal3(embed3);
        pc.setId(1L);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)pc);
        em.getTransaction().commit();
        Object pcId = em.getObjectId((Object)pc);
        em.close();
        em = this.emf.createEntityManager();
        pc = (NonstandardMappingEntity3)em.find(NonstandardMappingEntity3.class, pcId);
        TestNonstandardMappingAnnotations.assertEquals((int)1, (int)pc.getEmbedVal3s().size());
        TestNonstandardMappingAnnotations.assertEquals((String)"basic", (String)pc.getEmbedVal3s().get(0).getBasic());
        TestNonstandardMappingAnnotations.assertEquals((Object)1.0, (Object)pc.getEmbedVal3s().get(0).getPoint().getX());
        TestNonstandardMappingAnnotations.assertEquals((Object)2.0, (Object)pc.getEmbedVal3s().get(0).getPoint().getY());
        TestNonstandardMappingAnnotations.assertEquals((Object)1.0, (Object)pc.getEmbedVal3().getPoint().getX());
        TestNonstandardMappingAnnotations.assertEquals((Object)2.0, (Object)pc.getEmbedVal3().getPoint().getY());
        em.close();
    }

    public void testInsertAndRetrieveMappedSuperWithStrategy() {
        NonstandardMappingEntity4 pc = new NonstandardMappingEntity4();
        Point point = new Point();
        point.setLocation(1, 2);
        pc.setPoint(point);
        pc.setId(1L);
        pc.setName("name1");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)pc);
        em.getTransaction().commit();
        Object pcId = em.getObjectId((Object)pc);
        em.close();
        em = this.emf.createEntityManager();
        pc = (NonstandardMappingEntity4)em.find(NonstandardMappingEntity4.class, pcId);
        TestNonstandardMappingAnnotations.assertEquals((String)"name1", (String)pc.getName());
        TestNonstandardMappingAnnotations.assertEquals((Object)1.0, (Object)pc.getPoint().getX());
        TestNonstandardMappingAnnotations.assertEquals((Object)2.0, (Object)pc.getPoint().getY());
        for (int i = 0; i < 2; ++i) {
            OpenJPAQuery query = em.createQuery("select s from NonstandardMappingEntity4 s where s.point = :point");
            query.setParameter("point", (Object)new Point(1, 2));
            List list = query.getResultList();
            for (NonstandardMappingEntity4 pc1 : list) {
                TestNonstandardMappingAnnotations.assertEquals((Object)1.0, (Object)pc1.getPoint().getX());
                TestNonstandardMappingAnnotations.assertEquals((Object)2.0, (Object)pc1.getPoint().getY());
            }
            em.clear();
        }
        em.close();
    }
}

