/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import java.util.Set;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.annotations.AnnoTest1;
import org.apache.openjpa.persistence.jdbc.annotations.AnnoTest2;
import org.apache.openjpa.persistence.jdbc.annotations.Flat1;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestOneToMany
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(AnnoTest1.class, AnnoTest2.class, Flat1.class, CLEAR_TABLES);
    }

    public void testOneToMany() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 pc = new AnnoTest1(5L);
        pc.getOneMany().add(new AnnoTest2(15L, "foo"));
        pc.getOneMany().add(new AnnoTest2(20L, "foobar"));
        em.persist((Object)pc);
        em.persistAll(pc.getOneMany());
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)new Long(5L));
        Set<AnnoTest2> many = pc.getOneMany();
        TestOneToMany.assertEquals((int)2, (int)many.size());
        block4: for (AnnoTest2 pc2 : many) {
            switch ((int)pc2.getPk1()) {
                case 15: {
                    TestOneToMany.assertEquals((String)"foo", (String)pc2.getPk2());
                    continue block4;
                }
                case 20: {
                    TestOneToMany.assertEquals((String)"foobar", (String)pc2.getPk2());
                    continue block4;
                }
            }
            TestOneToMany.fail((String)("unknown element:" + pc2.getPk1()));
        }
        em.close();
    }

    public void testInverseOwnerOneToMany() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 pc = new AnnoTest1(5L);
        AnnoTest2 pc2 = new AnnoTest2(15L, "foo");
        pc.getInverseOwnerOneMany().add(pc2);
        pc2.setOneManyOwner(pc);
        pc2 = new AnnoTest2(20L, "foobar");
        pc.getInverseOwnerOneMany().add(pc2);
        pc2.setOneManyOwner(pc);
        em.persist((Object)pc);
        em.persistAll(pc.getInverseOwnerOneMany());
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)new Long(5L));
        Set<AnnoTest2> many = pc.getInverseOwnerOneMany();
        TestOneToMany.assertEquals((int)2, (int)many.size());
        block4: for (AnnoTest2 pc3 : many) {
            TestOneToMany.assertEquals((Object)pc, (Object)pc3.getOneManyOwner());
            switch ((int)pc3.getPk1()) {
                case 15: {
                    TestOneToMany.assertEquals((String)"foo", (String)pc3.getPk2());
                    continue block4;
                }
                case 20: {
                    TestOneToMany.assertEquals((String)"foobar", (String)pc3.getPk2());
                    continue block4;
                }
            }
            TestOneToMany.fail((String)("unknown element:" + pc3.getPk1()));
        }
        em.close();
    }
}

