/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.annotations.AnnoTest1;
import org.apache.openjpa.persistence.jdbc.annotations.AnnoTest2;
import org.apache.openjpa.persistence.jdbc.annotations.Flat1;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestOneToOne
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(AnnoTest1.class, AnnoTest2.class, Flat1.class, CLEAR_TABLES);
    }

    public void testOneToOne() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 pc = new AnnoTest1(5L);
        AnnoTest2 pc2 = new AnnoTest2(15L, "foo");
        pc.setOneOne(pc2);
        em.persist((Object)pc);
        em.persist((Object)pc2);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)new Long(5L));
        pc2 = pc.getOneOne();
        TestOneToOne.assertNotNull((Object)pc2);
        TestOneToOne.assertEquals((long)15L, (long)pc2.getPk1());
        TestOneToOne.assertEquals((String)"foo", (String)pc2.getPk2());
        em.close();
    }

    public void testSelfOneToOne() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 pc = new AnnoTest1(5L);
        AnnoTest1 pc2 = new AnnoTest1(15L);
        pc.setSelfOneOne(pc2);
        em.persist((Object)pc);
        em.persist((Object)pc2);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)new Long(5L));
        pc2 = pc.getSelfOneOne();
        TestOneToOne.assertNotNull((Object)pc2);
        TestOneToOne.assertEquals((Object)new Long(15L), (Object)pc2.getPk());
        em.close();
    }

    public void testPKJoinSelfOneToOne() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 pc = new AnnoTest1(5L);
        AnnoTest1 pc2 = new AnnoTest1(15L);
        pc.setSelfOneOne(pc2);
        em.persist((Object)pc);
        em.persist((Object)pc2);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)new Long(5L));
        pc2 = pc.getSelfOneOne();
        TestOneToOne.assertNotNull((Object)pc2);
        TestOneToOne.assertEquals((Object)new Long(15L), (Object)pc2.getPk());
        em.close();
    }

    public void testOtherTableOneToOne() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 pc = new AnnoTest1(5L);
        AnnoTest2 pc2 = new AnnoTest2(15L, "foo");
        pc.setOtherTableOneOne(pc2);
        em.persist((Object)pc);
        em.persist((Object)pc2);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)new Long(5L));
        pc2 = pc.getOtherTableOneOne();
        TestOneToOne.assertNotNull((Object)pc2);
        TestOneToOne.assertEquals((long)15L, (long)pc2.getPk1());
        TestOneToOne.assertEquals((String)"foo", (String)pc2.getPk2());
        em.close();
    }

    public void testInverseOneToOne() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 pc = new AnnoTest1(5L);
        AnnoTest2 pc2 = new AnnoTest2(15L, "foo");
        pc2.setInverseOneOne(pc);
        em.persist((Object)pc);
        em.persist((Object)pc2);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)new Long(5L));
        pc2 = pc.getInverseOwnerOneOne();
        TestOneToOne.assertNotNull((Object)pc2);
        TestOneToOne.assertEquals((long)15L, (long)pc2.getPk1());
        TestOneToOne.assertEquals((String)"foo", (String)pc2.getPk2());
        TestOneToOne.assertEquals((Object)pc, (Object)pc2.getInverseOneOne());
        em.close();
    }
}

