/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.annotations.NativeORMSequenceEntity;
import org.apache.openjpa.persistence.jdbc.annotations.NativeSequenceEntity;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

@AllowFailure(value=true)
public class TestSequenceGenerator
extends SingleEMFTestCase {
    private boolean enabled = true;

    @Override
    public void setUp() throws Exception {
        this.setUp(NativeSequenceEntity.class, NativeORMSequenceEntity.class, CLEAR_TABLES);
        try {
            this.enabled = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().nextSequenceQuery != null;
        }
        catch (Throwable t) {
            this.enabled = false;
        }
    }

    @Override
    protected String getPersistenceUnitName() {
        return "native-seq-pu";
    }

    public void testSequenceSchema() {
        if (this.enabled) {
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            NativeSequenceEntity nse = new NativeSequenceEntity();
            nse.setName("Test");
            em.getTransaction().begin();
            em.persist((Object)nse);
            em.getTransaction().commit();
            em.refresh((Object)nse);
            TestSequenceGenerator.assertTrue((boolean)this.sequenceExists(em, "SEQSCHEMA", "SCHEMASEQ"));
            TestSequenceGenerator.assertTrue((nse.getId() >= 10 ? 1 : 0) != 0);
            em.close();
        }
    }

    public void testORMSequenceSchema() {
        if (this.enabled) {
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            NativeORMSequenceEntity nse = new NativeORMSequenceEntity();
            nse.setName("TestORM");
            em.getTransaction().begin();
            em.persist((Object)nse);
            em.getTransaction().commit();
            em.refresh((Object)nse);
            TestSequenceGenerator.assertTrue((boolean)this.sequenceExists(em, "ORMSCHEMA", "ORMSEQ"));
            TestSequenceGenerator.assertTrue((nse.getId() >= 2000 ? 1 : 0) != 0);
            em.close();
        }
    }

    private boolean sequenceExists(OpenJPAEntityManagerSPI em, String schema, String sequence) {
        JDBCConfiguration conf = (JDBCConfiguration)this.emf.getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        Connection conn = (Connection)em.getConnection();
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            Sequence[] seqs = dict.getSequences(dbmd, conn.getCatalog(), schema, sequence, conn);
            if (seqs != null && seqs.length == 1 && seqs[0].getName().equalsIgnoreCase(sequence) && seqs[0].getSchemaName().equalsIgnoreCase(schema)) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }
}

