/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.auto;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.jdbc.sql.SQLServerDictionary;
import org.apache.openjpa.jdbc.sql.SybaseDictionary;
import org.apache.openjpa.persistence.jdbc.auto.AutoIncrementEntity;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class TestAutoIncrement
extends SingleEMTestCase {
    boolean disabled = false;

    @Override
    public void setUp() {
        super.setUp(DROP_TABLES, AutoIncrementEntity.class);
        DBDictionary dic = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
        if (!dic.supportsAutoAssign) {
            this.disabled = true;
            return;
        }
        if (dic instanceof SQLServerDictionary || dic instanceof OracleDictionary || dic instanceof SybaseDictionary) {
            this.disabled = true;
            return;
        }
        this.createZeroIdEntity();
    }

    public void test() {
        if (this.disabled) {
            return;
        }
        this.em.getTransaction().begin();
        AutoIncrementEntity e1 = (AutoIncrementEntity)this.em.find(AutoIncrementEntity.class, (Object)0);
        TestAutoIncrement.assertNotNull((Object)e1);
        AutoIncrementEntity e2 = new AutoIncrementEntity();
        TestAutoIncrement.assertEquals(null, (Object)e2.getId());
        this.em.persist((Object)e2);
        this.em.getTransaction().commit();
        TestAutoIncrement.assertNotEquals(null, e2.getId());
    }

    public void testMergeNewEntity() {
        if (this.disabled) {
            return;
        }
        AutoIncrementEntity e2 = new AutoIncrementEntity();
        this.em.getTransaction().begin();
        AutoIncrementEntity e3 = (AutoIncrementEntity)this.em.merge((Object)e2);
        this.em.getTransaction().commit();
        TestAutoIncrement.assertNotNull((Object)e3);
    }

    private void createZeroIdEntity() {
        this.em.getTransaction().begin();
        AutoIncrementEntity aie = new AutoIncrementEntity();
        this.em.persist((Object)aie);
        this.em.flush();
        if (aie.getId() != 0) {
            this.em.createQuery("UPDATE AutoIncrementEntity a SET a.id = 0 WHERE a.id = :id").setParameter("id", (Object)aie.getId()).executeUpdate();
        }
        this.em.getTransaction().commit();
    }
}

