/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.kernel;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.Extent;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public class BaseJDBCTest
extends AbstractTestCase {
    private static Map _sysprops = new HashMap();

    public BaseJDBCTest() {
    }

    public BaseJDBCTest(String name) {
        super(name, "jdbccactusapp");
    }

    @Override
    protected String defaultPersistenceXmlResource() {
        return "org/apache/openjpa/persistence/jdbc/common/apps/META-INF/persistence.xml";
    }

    protected OpenJPAEntityManager getPM() {
        return this.currentEntityManager();
    }

    protected OpenJPAEntityManager getPM(boolean optimistic, boolean retainValues) {
        OpenJPAEntityManager em = this.currentEntityManager();
        em.setNontransactionalRead(true);
        em.setRetainState(retainValues);
        em.setOptimistic(optimistic);
        return em;
    }

    protected int deleteAll(Broker broker, Class clazz) {
        return this.deleteAll(broker, clazz, true);
    }

    protected int deleteAll(Broker broker, Class clazz, boolean subclasses) {
        boolean useDeleteByQuery = false;
        Extent extent = broker.newExtent(clazz, subclasses);
        List list = extent.list();
        int size = list.size();
        broker.deleteAll((Collection)list, null);
        return size;
    }

    protected int deleteAll(OpenJPAEntityManager pm, Class clazz) {
        return this.deleteAll(JPAFacadeHelper.toBroker((EntityManager)pm), clazz);
    }

    protected int deleteAll(OpenJPAEntityManager pm, Class clazz, boolean subclasses) {
        return this.deleteAll(JPAFacadeHelper.toBroker((EntityManager)pm), clazz, subclasses);
    }

    protected Object persist(Object ob) {
        Broker broker = this.getBrokerFactory().newBroker();
        broker.begin();
        broker.persist(ob, null);
        Object id = broker.getObjectId(ob);
        broker.commit();
        broker.close();
        return id;
    }

    protected Properties getProperties() {
        return this.getProperties(null);
    }

    protected synchronized Properties getProperties(String[] props) {
        Properties p = new Properties(System.getProperties());
        String str = p.getProperty("openjpa.properties", "kodo.properties");
        if (str != null && str.length() > 0) {
            Properties loaded = (Properties)_sysprops.get(str);
            if (loaded == null) {
                loaded = new Properties();
                ConfigurationProvider cp = (ConfigurationProvider)Configurations.getProperty((String)str, null);
                if (cp != null) {
                    loaded.putAll((Map<?, ?>)cp.getProperties());
                }
                _sysprops.put(str, loaded);
            }
            p.putAll((Map<?, ?>)loaded);
        }
        for (int i = 0; props != null && i < props.length; i += 2) {
            if (props[i + 1] != null) {
                if (props[i].startsWith("openjpa.")) {
                    p.remove("openjpa." + props[i].substring(5));
                } else if (props[i].startsWith("openjpa.")) {
                    p.remove("openjpa." + props[i].substring(8));
                }
                p.setProperty(props[i], props[i + 1]);
                continue;
            }
            p.remove(props[i]);
        }
        return p;
    }
}

