/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.kernel;

import javax.persistence.EntityTransaction;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.PersistenceException;
import org.apache.openjpa.persistence.RollbackException;
import org.apache.openjpa.persistence.jdbc.common.apps.EntityWithFailedExternalizer;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestBatchFlushWithMetadataException
extends SQLListenerTestCase {
    @Override
    public void setUp() throws Exception {
        this.setUp(DROP_TABLES, EntityWithFailedExternalizer.class);
    }

    public void testCreate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        EntityWithFailedExternalizer item1 = new EntityWithFailedExternalizer(1001, "MyName1", "description1");
        EntityWithFailedExternalizer item2 = new EntityWithFailedExternalizer(1002, "MyName2", "description2");
        item1.getExt().throwEx = true;
        EntityWithFailedExternalizer item3 = new EntityWithFailedExternalizer(1003, "MyName3", "description3");
        em.persist((Object)item1);
        em.persist((Object)item2);
        em.persist((Object)item3);
        this.commitAndValidate(tx);
        em.close();
    }

    private void commitAndValidate(EntityTransaction tx) {
        try {
            this.resetSQL();
            tx.commit();
            TestBatchFlushWithMetadataException.fail((String)"RollbackException should have been thrown from the externalizer");
        }
        catch (RollbackException rollBackException) {
            Throwable[] throwables = rollBackException.getNestedThrowables();
            TestBatchFlushWithMetadataException.assertTrue((boolean)(throwables[0] instanceof PersistenceException));
            PersistenceException persistentException = (PersistenceException)throwables[0];
            TestBatchFlushWithMetadataException.assertNotNull((Object)((Object)persistentException));
            TestBatchFlushWithMetadataException.assertEquals((int)1, (int)persistentException.getNestedThrowables().length);
        }
    }
}

