/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.kernel;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.kernel.GenericResultObjectProvider;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.ResultSetResult;
import org.apache.openjpa.kernel.AbstractPCResultObjectProvider;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.rop.EagerResultList;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.common.apps.RawSQL;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestRawSQL
extends BaseJDBCTest {
    private Object[] _oids = new Object[3];
    private String[] _strings = new String[]{"a", "b", "c"};
    private int[] _ints = new int[]{1, 2, 3};

    public TestRawSQL(String test) {
        super(test);
    }

    public void setUp() {
        this.deleteAll(RawSQL.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        Broker broker = JPAFacadeHelper.toBroker((EntityManager)em);
        broker.begin();
        for (int i = 0; i < this._oids.length; ++i) {
            RawSQL raw = new RawSQL(this._strings[i], this._ints[i]);
            broker.persist((Object)raw, null);
            this._oids[i] = broker.getUserObject((Object)raw);
        }
        broker.commit();
        broker.close();
        em.close();
    }

    public void testLoadWithResult() throws Exception {
        OpenJPAEntityManager em = this.currentEntityManager();
        Broker broker = JPAFacadeHelper.toBroker((EntityManager)em);
        JDBCStore store = (JDBCStore)broker.getStoreManager();
        Connection conn = store.getConnection();
        Statement stmnt = conn.createStatement();
        ResultSet rs = stmnt.executeQuery("SELECT * FROM RAWSQL ORDER BY INTFIELD");
        ResultSetResult res = new ResultSetResult(rs, store.getConfiguration().getDBDictionaryInstance());
        GenericResultObjectProvider rop = new GenericResultObjectProvider(RawSQL.class, store, null, (Result)res);
        EagerResultList rl = new EagerResultList((ResultObjectProvider)rop);
        this.check((ResultList)rl, broker);
        rl.close();
        broker.close();
        em.close();
    }

    public void testLoadWithPCROP() throws Exception {
        OpenJPAEntityManager em = this.currentEntityManager();
        Broker broker = JPAFacadeHelper.toBroker((EntityManager)em);
        AbstractPCResultObjectProvider rop = new AbstractPCResultObjectProvider((StoreContext)broker){
            private int _row;
            {
                this._row = -1;
            }

            public boolean supportsRandomAccess() {
                return true;
            }

            public boolean next() {
                return ++this._row < TestRawSQL.this._oids.length;
            }

            public boolean absolute(int pos) {
                this._row = pos;
                return this._row < TestRawSQL.this._oids.length;
            }

            public int size() {
                return TestRawSQL.this._oids.length;
            }

            public void close() {
            }

            public void handleCheckedException(Exception e) {
                throw new RuntimeException(e.toString());
            }

            protected Object getObjectId(ClassMetaData meta) {
                return TestRawSQL.this._oids[this._row];
            }

            protected Class getPCType() {
                return RawSQL.class;
            }

            protected void load(OpenJPAStateManager sm, FetchConfiguration fetch) {
                ClassMetaData meta = sm.getMetaData();
                sm.storeStringField(meta.getField("stringField").getIndex(), TestRawSQL.this._strings[this._row]);
                sm.storeIntField(meta.getField("intField").getIndex(), TestRawSQL.this._ints[this._row]);
            }
        };
        EagerResultList rl = new EagerResultList((ResultObjectProvider)rop);
        this.check((ResultList)rl, broker);
        rl.close();
        broker.close();
    }

    private void check(ResultList rl, Broker broker) {
        int i = 0;
        for (RawSQL raw : rl) {
            TestRawSQL.assertTrue((boolean)broker.getStateManager((Object)raw).getLoaded().get(0));
            TestRawSQL.assertTrue((boolean)broker.getStateManager((Object)raw).getLoaded().get(1));
            if (i < this._oids.length) {
                TestRawSQL.assertEquals((String)this._strings[i], (String)raw.getStringField());
                TestRawSQL.assertEquals((int)this._ints[i], (int)raw.getIntField());
            }
            ++i;
        }
        TestRawSQL.assertEquals((int)this._oids.length, (int)i);
        TestRawSQL.assertEquals((int)this._oids.length, (int)rl.size());
    }
}

