/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.m2mmapex4;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import junit.framework.Assert;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex4.Address;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex4.Division;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex4.Employee;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex4.Office;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex4.PhoneNumber;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestMany2ManyMapEx4
extends SQLListenerTestCase {
    public int numEmployees = 2;
    public int numPhoneNumbers = this.numEmployees + 1;
    public int numEmployeesPerPhoneNumber = 2;
    public int numPhoneNumbersPerEmployee = 2;
    public Map<Integer, PhoneNumber> phones = new HashMap<Integer, PhoneNumber>();
    public List<String> namedQueries = new ArrayList<String>();
    public Map<Integer, Employee> empMap = new HashMap<Integer, Employee>();
    public Map<Integer, PhoneNumber> phoneMap = new HashMap<Integer, PhoneNumber>();
    public int empId = 1;
    public int phoneId = 1;
    public int divId = 1;
    public int deptId = 1;
    public int officeId = 1;
    public int numOfficesPerDivision = 2;
    public List rsAllPhones = null;
    public List rsAllEmps = null;
    protected List<String> sql = new ArrayList<String>();
    protected int sqlCount;

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, Division.class, Employee.class, PhoneNumber.class, Office.class, Address.class);
        this.createObj();
        this.rsAllPhones = this.getAll(PhoneNumber.class);
        this.rsAllEmps = this.getAll(Employee.class);
    }

    @AllowFailure
    public void testQueryInMemoryQualifiedId() throws Exception {
        this.queryQualifiedId(true);
    }

    public void testQueryQualifiedId() throws Exception {
        this.queryQualifiedId(false);
    }

    public void setCandidate(Query q, Class clz) throws Exception {
        QueryImpl q1 = (QueryImpl)q;
        org.apache.openjpa.kernel.Query q2 = q1.getDelegate();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)q2;
        if (clz == PhoneNumber.class) {
            qi.setCandidateCollection((Collection)this.rsAllPhones);
        } else if (clz == Employee.class) {
            qi.setCandidateCollection((Collection)this.rsAllEmps);
        }
    }

    public void queryQualifiedId(boolean inMemory) throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select o.address.city from PhoneNumber p,  in (p.emps) e, in(KEY(e).offices) o";
        Query q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        List rs = q.getResultList();
        query = "select o.address.city as city from PhoneNumber p,  in (p.emps) e, in(KEY(e).offices) o order by city";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        query = "select o.address.city as city from PhoneNumber p,  in (p.emps) e, in(KEY(e).offices) o  where o.address.city like '%1'";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        query = "select KEY(e) from PhoneNumber p,  in (p.emps) e order by e.empId";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        Division d = (Division)rs.get(0);
        query = "select KEY(p) from Employee e,  in (e.phones) p";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        String k = (String)rs.get(0);
        em.clear();
        query = "select ENTRY(e) from PhoneNumber p,  in (p.emps) e order by e.empId";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        Map.Entry me = (Map.Entry)rs.get(0);
        TestMany2ManyMapEx4.assertTrue((boolean)d.equals(me.getKey()));
        em.close();
    }

    public void testQueryObject() throws Exception {
        this.queryObj();
        this.findObj();
    }

    public List<String> getSql() {
        return this.sql;
    }

    public int getSqlCount() {
        return this.sqlCount;
    }

    public void createObj() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numEmployees; ++i) {
            Employee e = this.createEmployee((EntityManager)em, this.empId++);
            this.empMap.put(e.getEmpId(), e);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public Employee createEmployee(EntityManager em, int id) {
        Employee e = new Employee();
        e.setEmpId(id);
        for (int i = 0; i < this.numPhoneNumbersPerEmployee; ++i) {
            PhoneNumber phoneNumber = new PhoneNumber();
            phoneNumber.setNumber(this.phoneId++);
            Division div = this.createDivision(em, this.divId++);
            phoneNumber.addEmployees(div, e);
            e.addPhoneNumber("String" + phoneNumber.getNumber(), phoneNumber);
            this.phoneMap.put(phoneNumber.getNumber(), phoneNumber);
            em.persist((Object)phoneNumber);
            em.persist((Object)div);
        }
        em.persist((Object)e);
        return e;
    }

    public Division createDivision(EntityManager em, int id) {
        Division d = new Division();
        d.setId(id);
        d.setName("d" + id);
        for (int i = 0; i < this.numOfficesPerDivision; ++i) {
            Office office = new Office(this.officeId++);
            Address address = new Address("street" + i, "city" + i, "state" + i, "zip" + i);
            office.setAddress(address);
            em.persist((Object)office);
            d.addOffice(office);
        }
        return d;
    }

    public void findObj() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Employee e = (Employee)em.find(Employee.class, (Object)1);
        this.assertEmployee(e);
        PhoneNumber p = (PhoneNumber)em.find(PhoneNumber.class, (Object)1);
        this.assertPhoneNumber(p);
        em.close();
    }

    public void queryObj() throws Exception {
        this.queryEmployee();
        this.queryPhoneNumber();
    }

    public void queryPhoneNumber() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select p from PhoneNumber p");
        List ps = q.getResultList();
        for (PhoneNumber p : ps) {
            this.assertPhoneNumber(p);
        }
        tran.commit();
        em.close();
    }

    public void queryEmployee() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select e from Employee e");
        List es = q.getResultList();
        for (Employee e : es) {
            this.assertEmployee(e);
        }
        tran.commit();
        em.close();
    }

    public void assertEmployee(Employee e) throws Exception {
        int id = e.getEmpId();
        Employee e0 = this.empMap.get(id);
        Map<String, PhoneNumber> phones = e.getPhoneNumbers();
        Map<String, PhoneNumber> phones0 = e0.getPhoneNumbers();
        Assert.assertEquals((int)phones0.size(), (int)phones.size());
        this.checkPhoneMap(phones0, phones);
    }

    public void assertPhoneNumber(PhoneNumber p) throws Exception {
        int number = p.getNumber();
        PhoneNumber p0 = this.phoneMap.get(number);
        Map<Division, Employee> es = p.getEmployees();
        Map<Division, Employee> es0 = p0.getEmployees();
        Assert.assertEquals((int)es0.size(), (int)es.size());
        this.checkEmpMap(es0, es);
    }

    public void checkPhoneMap(Map<String, PhoneNumber> es0, Map<String, PhoneNumber> es) throws Exception {
        Set<Map.Entry<String, PhoneNumber>> entrySets0 = es0.entrySet();
        for (Map.Entry entry : entrySets0) {
            PhoneNumber p;
            String key0 = (String)entry.getKey();
            PhoneNumber p0 = (PhoneNumber)entry.getValue();
            if (p0.equals(p = es.get(key0))) continue;
            throw new Exception("Assertion Failure");
        }
    }

    public void checkEmpMap(Map<Division, Employee> es0, Map<Division, Employee> es) throws Exception {
        Set<Map.Entry<Division, Employee>> entrySets0 = es0.entrySet();
        for (Map.Entry entry : entrySets0) {
            Employee e;
            Division key0 = (Division)entry.getKey();
            Employee e0 = (Employee)entry.getValue();
            if (e0.equals(e = es.get(key0))) continue;
            throw new Exception("Assertion failure");
        }
    }
}

