/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.spec_10_1_27_ex0;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import junit.framework.Assert;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_27_ex0.Compny1;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_27_ex0.Compny2;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_27_ex0.Division;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_27_ex0.Item1;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_27_ex0.Item2;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_27_ex0.VicePresident;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestSpec10_1_27
extends SQLListenerTestCase {
    public int numItems = 2;
    public int numImagesPerItem = 3;
    public int numCompany = 2;
    public int numDivisionsPerCo = 2;
    public int itemId = 1;
    public int compId = 1;
    public int divId = 1;
    public int vpId = 1;
    public List<Compny1> rsAllCompny1 = null;
    public List<Compny2> rsAllCompny2 = null;

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, Compny1.class, Compny2.class, Item1.class, Item2.class, Division.class, VicePresident.class);
        this.createObj((EntityManagerFactory)this.emf);
        this.rsAllCompny1 = this.getAll(Compny1.class);
        this.rsAllCompny2 = this.getAll(Compny2.class);
    }

    @AllowFailure
    public void testQueryInMemoryQualifiedId() throws Exception {
        this.queryQualifiedId(true);
    }

    public void testQueryQualifiedId() throws Exception {
        this.queryQualifiedId(false);
    }

    public void setCandidate(Query q, Class<?> clz) throws Exception {
        QueryImpl q1 = (QueryImpl)q;
        org.apache.openjpa.kernel.Query q2 = q1.getDelegate();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)q2;
        if (clz == Compny1.class) {
            qi.setCandidateCollection(this.rsAllCompny1);
        } else if (clz == Compny2.class) {
            qi.setCandidateCollection(this.rsAllCompny2);
        }
    }

    public void queryQualifiedId(boolean inMemory) throws Exception {
        Map.Entry me;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select KEY(e) from Compny1 c,  in (c.orgs) e order by c.id";
        Query q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Compny1.class);
        }
        List rs = q.getResultList();
        Division d = (Division)rs.get(0);
        Division d2 = (Division)rs.get(1);
        em.clear();
        query = "select ENTRY(e) from Compny1 c,  in (c.orgs) e order by c.id";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Compny1.class);
        }
        TestSpec10_1_27.assertTrue((d.equals((me = (Map.Entry)(rs = q.getResultList()).get(0)).getKey()) || d2.equals(me.getKey()) ? 1 : 0) != 0);
        query = "select KEY(e) from Compny2 c,  in (c.orgs) e order by c.id";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Compny2.class);
        }
        rs = q.getResultList();
        d = (Division)rs.get(0);
        d2 = (Division)rs.get(1);
        em.clear();
        query = "select ENTRY(e) from Compny2 c,  in (c.orgs) e order by c.id";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Compny2.class);
        }
        TestSpec10_1_27.assertTrue((d.equals((me = (Map.Entry)(rs = q.getResultList()).get(0)).getKey()) || d2.equals(me.getKey()) ? 1 : 0) != 0);
        em.clear();
        query = "select im from Item1 i, in (i.images) im  order by VALUE(im)";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Item1.class);
        }
        rs = q.getResultList();
        TestSpec10_1_27.assertEquals((int)(this.numItems * this.numImagesPerItem), (int)rs.size());
        em.clear();
        query = "select im from Item1 i, in (i.images) im  where VALUE(im) = 'file11'";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Item1.class);
        }
        rs = q.getResultList();
        TestSpec10_1_27.assertEquals((int)1, (int)rs.size());
        em.clear();
        query = "select im from Item1 i, in (i.images) im  group by im  having VALUE(im) like 'file1%'";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Item1.class);
        }
        rs = q.getResultList();
        TestSpec10_1_27.assertEquals((int)this.numImagesPerItem, (int)rs.size());
        em.close();
    }

    public void testQueryObj() throws Exception {
        this.queryObj((EntityManagerFactory)this.emf);
    }

    public void createObj(EntityManagerFactory emf) {
        int i;
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        for (i = 0; i < this.numItems; ++i) {
            this.createItem1(em, this.itemId++);
            em.flush();
        }
        for (i = 0; i < this.numItems; ++i) {
            this.createItem2(em, this.itemId++);
            em.flush();
        }
        for (i = 0; i < this.numCompany; ++i) {
            this.createCompany1(em, this.compId++);
            em.flush();
        }
        for (i = 0; i < this.numCompany; ++i) {
            this.createCompany2(em, this.compId++);
            em.flush();
        }
        em.flush();
        tran.commit();
        em.close();
    }

    public void createItem1(EntityManager em, int id) {
        Item1 item = new Item1();
        item.setId(id);
        for (int i = 0; i < this.numImagesPerItem; ++i) {
            item.addImage("image" + id + i, "file" + id + i);
        }
        em.persist((Object)item);
    }

    public void createItem2(EntityManager em, int id) {
        Item2 item = new Item2();
        item.setId(id);
        for (int i = 0; i < this.numImagesPerItem; ++i) {
            item.addImage("image" + id + i, "file" + id + i);
        }
        em.persist((Object)item);
    }

    public void createCompany1(EntityManager em, int id) {
        Compny1 c = new Compny1();
        c.setId(id);
        for (int i = 0; i < this.numDivisionsPerCo; ++i) {
            Division d = this.createDivision(em, this.divId++);
            VicePresident vp = this.createVicePresident(em, this.vpId++);
            c.addToOrganization(d, vp);
            em.persist((Object)d);
            em.persist((Object)vp);
        }
        em.persist((Object)c);
    }

    public void createCompany2(EntityManager em, int id) {
        Compny2 c = new Compny2();
        c.setId(id);
        for (int i = 0; i < this.numDivisionsPerCo; ++i) {
            Division d = this.createDivision(em, this.divId++);
            VicePresident vp = this.createVicePresident(em, this.vpId++);
            c.addToOrganization(d, vp);
            em.persist((Object)d);
            em.persist((Object)vp);
        }
        em.persist((Object)c);
    }

    public Division createDivision(EntityManager em, int id) {
        Division d = new Division();
        d.setId(id);
        d.setName("d" + id);
        return d;
    }

    public VicePresident createVicePresident(EntityManager em, int id) {
        VicePresident vp = new VicePresident();
        vp.setId(id);
        vp.setName("vp" + id);
        return vp;
    }

    public void findObj(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        Item1 item1 = (Item1)em.find(Item1.class, (Object)1);
        this.assertItem1(item1);
        Item2 item2 = (Item2)em.find(Item2.class, (Object)4);
        this.assertItem2(item2);
        Compny1 c1 = (Compny1)em.find(Compny1.class, (Object)1);
        this.assertCompany1(c1);
        Compny2 c2 = (Compny2)em.find(Compny2.class, (Object)3);
        this.assertCompany2(c2);
        Division d = (Division)em.find(Division.class, (Object)1);
        this.assertDivision(d);
        VicePresident vp = (VicePresident)em.find(VicePresident.class, (Object)1);
        this.assertVicePresident(vp);
        em.close();
    }

    public void assertItem1(Item1 item) {
        int id = item.getId();
        Map<String, String> images = item.getImages();
        Assert.assertEquals((int)this.numImagesPerItem, (int)images.size());
    }

    public void assertItem2(Item2 item) {
        int id = item.getId();
        Map<String, String> images = item.getImages();
        Assert.assertEquals((int)this.numImagesPerItem, (int)images.size());
    }

    public void assertCompany1(Compny1 c) {
        int id = c.getId();
        Map organization = c.getOrganization();
        Assert.assertEquals((int)2, (int)organization.size());
    }

    public void assertCompany2(Compny2 c) {
        int id = c.getId();
        Map organization = c.getOrganization();
        Assert.assertEquals((int)2, (int)organization.size());
    }

    public void assertDivision(Division d) {
        int id = d.getId();
        String name = d.getName();
    }

    public void assertVicePresident(VicePresident vp) {
        int id = vp.getId();
        String name = vp.getName();
    }

    public void queryObj(EntityManagerFactory emf) {
        this.queryItem(emf);
        this.queryCompany(emf);
        this.queryDivision(emf);
        this.queryVicePresident(emf);
    }

    public void queryItem(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q1 = em.createQuery("select i from Item1 i");
        List is1 = q1.getResultList();
        for (Item1 item : is1) {
            this.assertItem1(item);
        }
        Query q2 = em.createQuery("select i from Item2 i");
        List is2 = q2.getResultList();
        for (Item2 item : is2) {
            this.assertItem2(item);
        }
        tran.commit();
        em.close();
    }

    public void queryCompany(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q1 = em.createQuery("select c from Compny1 c");
        List cs1 = q1.getResultList();
        for (Compny1 c : cs1) {
            this.assertCompany1(c);
        }
        Query q2 = em.createQuery("select c from Compny2 c");
        List cs2 = q2.getResultList();
        for (Compny2 c : cs2) {
            this.assertCompany2(c);
        }
        tran.commit();
        em.close();
    }

    public void queryDivision(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select d from Division d");
        List ds = q.getResultList();
        for (Division d : ds) {
            this.assertDivision(d);
        }
        tran.commit();
        em.close();
    }

    public void queryVicePresident(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select vp from VicePresident vp");
        List vps = q.getResultList();
        for (VicePresident vp : vps) {
            this.assertVicePresident(vp);
        }
        tran.commit();
        em.close();
    }
}

