/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.spec_10_1_27_ex4;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import junit.framework.Assert;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_27_ex4.Company;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_27_ex4.Division;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_27_ex4.VicePresident;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestSpec10_1_27_Ex4
extends SQLListenerTestCase {
    public int numCompany = 2;
    public int numDivisionsPerCo = 2;
    public int compId = 1;
    public int divId = 1;
    public int vpId = 1;
    public int newDivId = 100;
    public int newVpId = 100;
    public List rsAllCompany = null;

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, Company.class, Division.class, VicePresident.class);
        this.createObj((EntityManagerFactory)this.emf);
        this.rsAllCompany = this.getAll(Company.class);
    }

    public void testQueryObj() throws Exception {
        this.queryObj((EntityManagerFactory)this.emf);
    }

    @AllowFailure
    public void testQueryInMemoryQualifiedId() throws Exception {
        this.queryQualifiedId(true);
    }

    public void testQueryQualifiedId() throws Exception {
        this.queryQualifiedId(false);
    }

    public void setCandidate(Query q, Class clz) throws Exception {
        QueryImpl q1 = (QueryImpl)q;
        org.apache.openjpa.kernel.Query q2 = q1.getDelegate();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)q2;
        if (clz == Company.class) {
            qi.setCandidateCollection((Collection)this.rsAllCompany);
        }
    }

    public void queryQualifiedId(boolean inMemory) throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select KEY(e) from Company c,  in (c.organization) e order by c.id";
        Query q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Company.class);
        }
        List rs = q.getResultList();
        Division d = (Division)rs.get(0);
        em.clear();
        query = "select ENTRY(e) from Company c,  in (c.organization) e order by c.id";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Company.class);
        }
        rs = q.getResultList();
        Map.Entry me = (Map.Entry)rs.get(0);
        TestSpec10_1_27_Ex4.assertEquals((Object)d, me.getKey());
        em.clear();
        query = "select KEY(e) from Company c  left join c.organization e order by c.id";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Company.class);
        }
        rs = q.getResultList();
        d = (Division)rs.get(0);
        em.clear();
        query = "select ENTRY(e) from Company c  left join c.organization e order by c.id";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Company.class);
        }
        rs = q.getResultList();
        me = (Map.Entry)rs.get(0);
        TestSpec10_1_27_Ex4.assertTrue((boolean)d.equals(me.getKey()));
        em.close();
    }

    public void createObj(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        for (int i = 0; i < this.numCompany; ++i) {
            this.createCompany(em, this.compId++);
            em.flush();
        }
        tran.commit();
        em.close();
    }

    public void createCompany(EntityManager em, int id) {
        Company c = new Company();
        c.setId(id);
        for (int i = 0; i < this.numDivisionsPerCo; ++i) {
            Division d = this.createDivision(em, this.divId++);
            VicePresident vp = this.createVicePresident(em, this.vpId++);
            c.addToOrganization(d, vp);
            em.persist((Object)d);
            em.persist((Object)vp);
        }
        em.persist((Object)c);
    }

    public Division createDivision(EntityManager em, int id) {
        Division d = new Division();
        d.setId(id);
        d.setName("d" + id);
        return d;
    }

    public VicePresident createVicePresident(EntityManager em, int id) {
        VicePresident vp = new VicePresident();
        vp.setId(id);
        vp.setName("vp" + id);
        return vp;
    }

    public void findObj(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        Company c = (Company)em.find(Company.class, (Object)1);
        this.assertCompany(c);
        Division d = (Division)em.find(Division.class, (Object)1);
        this.assertDivision(d);
        VicePresident vp = (VicePresident)em.find(VicePresident.class, (Object)1);
        this.assertVicePresident(vp);
        this.updateObj(em, c);
        em.close();
        em = emf.createEntityManager();
        c = (Company)em.find(Company.class, (Object)1);
        this.assertCompany(c);
        this.deleteObj(em, c);
        em.close();
    }

    public void updateObj(EntityManager em, Company c) {
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Map orgs = c.getOrganization();
        Set keys = orgs.keySet();
        Iterator i$ = keys.iterator();
        if (i$.hasNext()) {
            Object key = i$.next();
            Division d = (Division)key;
            VicePresident vp = c.getOrganization(d);
            vp.setCompany(null);
            em.persist((Object)vp);
            orgs.remove(d);
        }
        em.persist((Object)c);
        em.flush();
        tran.commit();
        tran.begin();
        Division d = this.createDivision(em, this.newDivId++);
        VicePresident vp = this.createVicePresident(em, this.newVpId++);
        c.addToOrganization(d, vp);
        vp.setCompany(c);
        em.persist((Object)d);
        em.persist((Object)vp);
        em.persist((Object)c);
        em.flush();
        tran.commit();
        tran.begin();
        vp = c.getOrganization(d);
        vp.setName("newAgain");
        em.persist((Object)vp);
        em.persist((Object)c);
        em.flush();
        tran.commit();
    }

    public void deleteObj(EntityManager em, Company c) {
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        em.remove((Object)c);
        tran.commit();
    }

    public void assertCompany(Company c) {
        int id = c.getId();
        Map organization = c.getOrganization();
        Assert.assertEquals((int)2, (int)organization.size());
    }

    public void assertDivision(Division d) {
        int id = d.getId();
        String name = d.getName();
    }

    public void assertVicePresident(VicePresident vp) {
        int id = vp.getId();
        String name = vp.getName();
    }

    public void queryObj(EntityManagerFactory emf) {
        this.queryCompany(emf);
        this.queryDivision(emf);
        this.queryVicePresident(emf);
    }

    public void queryCompany(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select c from Company c");
        List cs = q.getResultList();
        for (Company c : cs) {
            this.assertCompany(c);
        }
        tran.commit();
        em.close();
    }

    public void queryDivision(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select d from Division d");
        List ds = q.getResultList();
        for (Division d : ds) {
            this.assertDivision(d);
        }
        tran.commit();
        em.close();
    }

    public void queryVicePresident(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select vp from VicePresident vp");
        List vps = q.getResultList();
        for (VicePresident vp : vps) {
            this.assertVicePresident(vp);
        }
        tran.commit();
        em.close();
    }
}

