/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.update;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.maps.update.LocalizedString;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;

@Entity
@Table(name="multilingual_string")
public class MultilingualString
implements PersistenceCapable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    @Column(name="string_id")
    private long id;
    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="language_key")
    @CollectionTable(name="multilingual_string_map", joinColumns={@JoinColumn(name="string_id")})
    private Map<String, LocalizedString> map = new HashMap<String, LocalizedString>();
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$Map;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$jdbc$maps$update$MultilingualString;
    private transient Object pcDetachedState;

    public MultilingualString() {
    }

    public MultilingualString(String lang, String text) {
        this.setText(lang, text);
    }

    public long getId() {
        return MultilingualString.pcGetid(this);
    }

    public void setId(long id) {
        MultilingualString.pcSetid(this, id);
    }

    public Map<String, LocalizedString> getMap() {
        return MultilingualString.pcGetmap(this);
    }

    public void setMap(Map<String, LocalizedString> map) {
        MultilingualString.pcSetmap(this, map);
    }

    public void setText(String lang, String text) {
        MultilingualString.pcGetmap(this).put(lang, new LocalizedString(lang, text));
    }

    public String getText(String lang) {
        if (MultilingualString.pcGetmap(this).containsKey(lang)) {
            return ((LocalizedString)MultilingualString.pcGetmap(this).get(lang)).getString();
        }
        return null;
    }

    public int pcGetEnhancementContractVersion() {
        return 1674154;
    }

    static {
        pcFieldNames = new String[]{"id", "map"};
        Class[] classArray = new Class[2];
        classArray[0] = Long.TYPE;
        Class clazz = class$Ljava$util$Map != null ? class$Ljava$util$Map : (class$Ljava$util$Map = MultilingualString.class$("java.util.Map"));
        classArray[1] = clazz;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 10};
        Class clazz2 = class$Lorg$apache$openjpa$persistence$jdbc$maps$update$MultilingualString != null ? class$Lorg$apache$openjpa$persistence$jdbc$maps$update$MultilingualString : (class$Lorg$apache$openjpa$persistence$jdbc$maps$update$MultilingualString = MultilingualString.class$("org.apache.openjpa.persistence.jdbc.maps.update.MultilingualString"));
        PCRegistry.register((Class)clazz2, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"MultilingualString", (PersistenceCapable)new MultilingualString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.id = 0L;
        this.map = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        MultilingualString multilingualString = new MultilingualString();
        if (bl) {
            multilingualString.pcClearFields();
        }
        multilingualString.pcStateManager = stateManager;
        multilingualString.pcCopyKeyFieldsFromObjectId(object);
        return multilingualString;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        MultilingualString multilingualString = new MultilingualString();
        if (bl) {
            multilingualString.pcClearFields();
        }
        multilingualString.pcStateManager = stateManager;
        return multilingualString;
    }

    protected static int pcGetManagedFieldCount() {
        return 2;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.id = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.map = (Map)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.map);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(MultilingualString multilingualString, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.id = multilingualString.id;
                return;
            }
            case 1: {
                this.map = multilingualString.map;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        MultilingualString multilingualString = (MultilingualString)object;
        if (multilingualString.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(multilingualString, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeLongField(0 + pcInheritedFieldCount, longId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.id = longId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openjpa$persistence$jdbc$maps$update$MultilingualString != null ? class$Lorg$apache$openjpa$persistence$jdbc$maps$update$MultilingualString : (class$Lorg$apache$openjpa$persistence$jdbc$maps$update$MultilingualString = MultilingualString.class$("org.apache.openjpa.persistence.jdbc.maps.update.MultilingualString"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openjpa$persistence$jdbc$maps$update$MultilingualString != null ? class$Lorg$apache$openjpa$persistence$jdbc$maps$update$MultilingualString : (class$Lorg$apache$openjpa$persistence$jdbc$maps$update$MultilingualString = MultilingualString.class$("org.apache.openjpa.persistence.jdbc.maps.update.MultilingualString"));
        return new LongId(clazz, this.id);
    }

    private static final long pcGetid(MultilingualString multilingualString) {
        if (multilingualString.pcStateManager == null) {
            return multilingualString.id;
        }
        int n = pcInheritedFieldCount + 0;
        multilingualString.pcStateManager.accessingField(n);
        return multilingualString.id;
    }

    private static final void pcSetid(MultilingualString multilingualString, long l) {
        if (multilingualString.pcStateManager == null) {
            multilingualString.id = l;
            return;
        }
        multilingualString.pcStateManager.settingLongField((PersistenceCapable)multilingualString, pcInheritedFieldCount + 0, multilingualString.id, l, 0);
    }

    private static final Map pcGetmap(MultilingualString multilingualString) {
        if (multilingualString.pcStateManager == null) {
            return multilingualString.map;
        }
        int n = pcInheritedFieldCount + 1;
        multilingualString.pcStateManager.accessingField(n);
        return multilingualString.map;
    }

    private static final void pcSetmap(MultilingualString multilingualString, Map map) {
        if (multilingualString.pcStateManager == null) {
            multilingualString.map = map;
            return;
        }
        multilingualString.pcStateManager.settingObjectField((PersistenceCapable)multilingualString, pcInheritedFieldCount + 1, multilingualString.map, (Object)map, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.id != 0L) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

