/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.common.apps.EagerPC;
import org.apache.openjpa.persistence.jdbc.common.apps.HelperPC;
import org.apache.openjpa.persistence.jdbc.common.apps.HelperPC2;
import org.apache.openjpa.persistence.jdbc.kernel.TestSQLListenerTestCase;

public class TestEagerDistinct
extends TestSQLListenerTestCase {
    public TestEagerDistinct(String name) {
        super(name);
    }

    public boolean skipTest() {
        return ((JDBCConfiguration)this.getConfiguration()).getDBDictionaryInstance().joinSyntax == 1;
    }

    @Override
    public void setUpTestCase() {
        this.deleteAll(EagerPC.class);
        this.deleteAll(HelperPC.class);
        this.deleteAll(HelperPC2.class);
        HelperPC shared = new HelperPC();
        shared.setStringField("shared");
        HelperPC2 pc1 = new HelperPC2();
        pc1.setStringField("pc1");
        pc1.getHelperCollection().add(shared);
        pc1.getHelperCollection().add(new HelperPC());
        HelperPC2 pc2 = new HelperPC2();
        pc2.setStringField("pc2");
        pc2.getHelperCollection().add(shared);
        pc2.getHelperCollection().add(new HelperPC());
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc1);
        pm.persist((Object)pc2);
        this.endTx((EntityManager)pm);
        pm.close();
    }

    @Override
    public OpenJPAEntityManager getPM() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().setMaxFetchDepth(-1);
        return pm;
    }

    public void testEagerParallelWithNonDistinctQuery() throws Exception {
        this.eagerParallelWithNonDistinctQuery(-1);
    }

    public void testPagingEagerParallelWithNonDistinctQuery() throws Exception {
        this.eagerParallelWithNonDistinctQuery(0);
    }

    private void eagerParallelWithNonDistinctQuery(int fetchSize) throws Exception {
        OpenJPAEntityManager pm = this.getPM();
        OpenJPAQuery q = pm.createNativeQuery("stringField.startsWith ('pc')", HelperPC2.class);
        q.getFetchPlan().setFetchBatchSize(fetchSize);
        List res = q.getResultList();
        if (fetchSize == -1) {
            TestEagerDistinct.assertEquals((int)2, (int)sql.size());
        }
        TestEagerDistinct.assertEquals((int)2, (int)res.size());
        this.assertHelperPC2("pc1", (HelperPC2)res.get(0));
        this.assertHelperPC2("pc2", (HelperPC2)res.get(1));
        this.assertNotSQL("DISTINCT");
        pm.close();
    }

    private void assertHelperPC2(String stringField, HelperPC2 pc) {
        TestEagerDistinct.assertEquals((String)stringField, (String)pc.getStringField());
        TestEagerDistinct.assertEquals((int)2, (int)pc.getHelperCollection().size());
        TestEagerDistinct.assertEquals((String)"shared", (String)((HelperPC)pc.getHelperCollection().get(0)).getStringField());
        TestEagerDistinct.assertNull((Object)((HelperPC)pc.getHelperCollection().get(1)).getStringField());
    }

    public void testEagerParallelWithDistinctQuery() throws Exception {
        this.eagerParallelWithDistinctQuery(-1);
    }

    public void testPagingEagerParallelWithDistinctQuery() throws Exception {
        this.eagerParallelWithDistinctQuery(0);
    }

    private void eagerParallelWithDistinctQuery(int fetchSize) throws Exception {
        OpenJPAEntityManager pm = this.getPM();
        OpenJPAQuery q = pm.createNativeQuery("helperCollection.contains (h) && h.stringField == 'shared'", HelperPC2.class);
        q.getFetchPlan().setFetchBatchSize(fetchSize);
        List res = q.getResultList();
        if (fetchSize == -1) {
            sql.remove(0);
            this.assertSQL("DISTINCT");
        }
        TestEagerDistinct.assertEquals((int)2, (int)res.size());
        this.assertHelperPC2("pc1", (HelperPC2)res.get(0));
        this.assertHelperPC2("pc2", (HelperPC2)res.get(1));
        pm.close();
    }

    public void testNestedEagerParallel() throws Exception {
        this.nestedEagerParallel(-1);
    }

    public void testPagingNestedEagerParallel() throws Exception {
        this.nestedEagerParallel(0);
    }

    private void nestedEagerParallel(int fetchSize) throws Exception {
        OpenJPAEntityManager pm = this.getPM();
        OpenJPAQuery q = pm.createNativeQuery("", HelperPC2.class);
        List helpers = q.getResultList();
        EagerPC eager1 = new EagerPC();
        eager1.setStringField("eager1");
        eager1.getRecurseCollection().addAll(helpers);
        EagerPC eager2 = new EagerPC();
        eager2.setStringField("eager2");
        eager2.getRecurseCollection().addAll(helpers);
        HelperPC2 pc3 = new HelperPC2();
        pc3.setStringField("pc3");
        pc3.getHelperCollection().add(new HelperPC());
        pc3.getHelperCollection().add(new HelperPC());
        pc3.getHelperCollection().add(new HelperPC());
        eager2.getRecurseCollection().add(pc3);
        this.startTx((EntityManager)pm);
        pm.persist((Object)eager1);
        pm.persist((Object)eager2);
        this.endTx((EntityManager)pm);
        pm.createNativeQuery("", EagerPC.class).getResultList();
        pm.close();
        sql.clear();
        pm = this.getPM();
        q = pm.createNativeQuery("stringField.startsWith ('eager')", EagerPC.class);
        q.getFetchPlan().setFetchBatchSize(fetchSize);
        List res = q.getResultList();
        if (fetchSize == -1) {
            sql.remove(0);
            this.assertSQL("DISTINCT");
        }
        TestEagerDistinct.assertEquals((int)2, (int)res.size());
        eager1 = (EagerPC)res.get(0);
        TestEagerDistinct.assertEquals((String)"eager1", (String)eager1.getStringField());
        TestEagerDistinct.assertEquals((int)2, (int)eager1.getRecurseCollection().size());
        this.assertHelperPC2("pc1", (HelperPC2)eager1.getRecurseCollection().get(0));
        this.assertHelperPC2("pc2", (HelperPC2)eager1.getRecurseCollection().get(1));
        eager2 = (EagerPC)res.get(1);
        TestEagerDistinct.assertEquals((String)"eager2", (String)eager2.getStringField());
        TestEagerDistinct.assertEquals((int)3, (int)eager2.getRecurseCollection().size());
        this.assertHelperPC2("pc1", (HelperPC2)eager2.getRecurseCollection().get(0));
        this.assertHelperPC2("pc2", (HelperPC2)eager2.getRecurseCollection().get(1));
        pc3 = (HelperPC2)eager2.getRecurseCollection().get(2);
        TestEagerDistinct.assertEquals((String)"pc3", (String)pc3.getStringField());
        TestEagerDistinct.assertEquals((int)3, (int)pc3.getHelperCollection().size());
        pm.close();
    }
}

