/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.RefreshStrategyInstaller;
import org.apache.openjpa.jdbc.meta.StrategyInstaller;
import org.apache.openjpa.jdbc.meta.strats.BlobValueHandler;
import org.apache.openjpa.jdbc.meta.strats.ClobValueHandler;
import org.apache.openjpa.jdbc.meta.strats.MaxEmbeddedClobFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.StringFieldStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestJDBCType
extends BaseJDBCTest {
    public TestJDBCType(String name) {
        super(name);
    }

    public void testSchemaGeneration() {
        Class<?> cls;
        JDBCConfigurationImpl conf = new JDBCConfigurationImpl();
        DBDictionary dict = conf.getDBDictionaryInstance();
        MappingRepository repos = conf.getMappingRepositoryInstance();
        repos.setStrategyInstaller((StrategyInstaller)new RefreshStrategyInstaller(repos));
        ClassMapping mapping = repos.getMapping(Column.class, null, true);
        if (dict.getPreferredType(1006) == 1006) {
            if (dict.maxEmbeddedClobSize > 0) {
                cls = mapping.getFieldMapping("toClob").getStrategy().getClass();
                TestJDBCType.assertTrue((String)cls.getName(), (boolean)MaxEmbeddedClobFieldStrategy.class.isAssignableFrom(cls));
            } else {
                cls = mapping.getFieldMapping("toClob").getHandler().getClass();
                TestJDBCType.assertTrue((String)cls.getName(), (boolean)ClobValueHandler.class.isAssignableFrom(cls));
            }
        } else {
            TestJDBCType.assertTrue((boolean)(mapping.getFieldMapping("toClob").getStrategy() instanceof StringFieldStrategy));
        }
        cls = mapping.getFieldMapping("toBlob").getHandler().getClass();
        TestJDBCType.assertTrue((String)cls.getName(), (boolean)BlobValueHandler.class.isAssignableFrom(cls));
        SchemaGroup schema = repos.getSchemaGroup();
        Table table = schema.getSchemas()[0].getTables()[0];
        Column[] cols = table.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i].getName().equalsIgnoreCase("id") || cols[i].getName().equalsIgnoreCase("versn") || cols[i].getName().equalsIgnoreCase("typ")) continue;
            if ("longToInt".equalsIgnoreCase(cols[i].getName())) {
                TestJDBCType.assertEquals((int)dict.getPreferredType(5), (int)cols[i].getType());
                continue;
            }
            if ("longToSQL".equalsIgnoreCase(cols[i].getName())) {
                TestJDBCType.assertEquals((String)"varchar", (String)cols[i].getTypeName());
                continue;
            }
            if ("toClob".equalsIgnoreCase(cols[i].getName())) {
                TestJDBCType.assertEquals((int)dict.getPreferredType(1006), (int)cols[i].getType());
                continue;
            }
            if ("toBlob".equalsIgnoreCase(cols[i].getName())) {
                TestJDBCType.assertEquals((int)dict.getPreferredType(1003), (int)cols[i].getType());
                continue;
            }
            TestJDBCType.fail((String)("Unknown column:" + cols[i].getName()));
        }
    }
}

