/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.common.apps.MappingTest1;
import org.apache.openjpa.persistence.jdbc.common.apps.MappingTest2;
import org.apache.openjpa.persistence.jdbc.common.apps.MappingTest5;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestJoinToBaseClass
extends BaseJDBCTest {
    public TestJoinToBaseClass(String name) {
        super(name);
    }

    public void testMapping() {
        ClassMapping mapping = ((JDBCConfiguration)this.getConfiguration()).getMappingRepositoryInstance().getMapping(MappingTest5.class, null, true);
        Table supTable = mapping.getPCSuperclassMapping().getTable();
        TestJoinToBaseClass.assertTrue((mapping.getTable() != supTable ? 1 : 0) != 0);
        FieldMapping field = mapping.getFieldMapping("vertRel");
        ForeignKey fk = field.getForeignKey();
        TestJoinToBaseClass.assertEquals((Object)mapping.getTable(), (Object)fk.getTable());
        TestJoinToBaseClass.assertEquals((Object)supTable, (Object)fk.getPrimaryKeyTable());
        Column[] cols = field.getColumns();
        TestJoinToBaseClass.assertEquals((int)2, (int)cols.length);
        TestJoinToBaseClass.assertEquals((String)"V1", (String)cols[0].getName());
        TestJoinToBaseClass.assertEquals((String)"V2", (String)cols[1].getName());
    }

    public void testConstraintAnalysis() {
        Object factory = null;
        OpenJPAEntityManager pm = factory.createEntityManager();
        this.startTx((EntityManager)pm);
        this.deleteAll(MappingTest1.class, (EntityManager)pm);
        this.deleteAll(MappingTest2.class, (EntityManager)pm);
        this.endTx((EntityManager)pm);
        pm.close();
        pm = factory.createEntityManager();
        this.startTx((EntityManager)pm);
        for (int i = 0; i < 10; ++i) {
            MappingTest5 pc1 = new MappingTest5();
            pc1.setPk1(i);
            pc1.setPk2(i + 1);
            MappingTest5 pc2 = new MappingTest5();
            pc2.setPk1(i + 10);
            pc2.setPk2(i + 11);
            pc1.setVertRel(pc2);
            pc2.setVertRel(pc1);
            pm.persist((Object)pc1);
        }
        this.endTx((EntityManager)pm);
        pm.close();
        this.assertSizes(20, MappingTest5.class);
        pm = factory.createEntityManager();
        this.startTx((EntityManager)pm);
        this.deleteAll(MappingTest2.class, (EntityManager)pm);
        this.endTx((EntityManager)pm);
        pm.close();
    }

    private void assertSizes(int size, Class cls) {
        this.assertSize(size, this.currentEntityManager().createExtent(cls, true).list());
    }
}

