/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.common.apps.LRSCompoundPC;
import org.apache.openjpa.persistence.jdbc.common.apps.LRSPC;
import org.apache.openjpa.persistence.jdbc.common.apps.LRSPCIntf;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestLRSProxies
extends BaseJDBCTest {
    private Object _oid = null;
    private Object _coid = null;

    public TestLRSProxies(String casename) {
        super(casename);
    }

    public TestLRSProxies() {
    }

    public void setUp() {
        this.deleteAll(LRSPC.class);
        this.deleteAll(LRSCompoundPC.class);
        LRSPC pc = new LRSPC("main");
        pc.getStringSet().add("val1");
        pc.getStringSet().add("val2");
        pc.getStringSet().add("val3");
        pc.getRelSet().add(new LRSPC("set1"));
        pc.getRelSet().add(new LRSPC("set2"));
        pc.getRelSet().add(new LRSPC("set3"));
        pc.getStringCollection().add("val1");
        pc.getStringCollection().add("val2");
        pc.getStringCollection().add("val3");
        pc.getRelCollection().add(new LRSPC("set1"));
        pc.getRelCollection().add(new LRSPC("set2"));
        pc.getRelCollection().add(new LRSPC("set3"));
        pc.getStringMap().put("key1", "1");
        pc.getStringMap().put("key2", "2");
        pc.getStringMap().put("key3", "3");
        pc.getRelMap().put("key1", new LRSPC("map1"));
        pc.getRelMap().put("key2", new LRSPC("map2"));
        pc.getRelMap().put("key3", new LRSPC("map3"));
        LRSCompoundPC cpc = new LRSCompoundPC("main");
        cpc.getStringSet().add("val1");
        cpc.getStringSet().add("val2");
        cpc.getStringSet().add("val3");
        cpc.getRelSet().add(new LRSCompoundPC("set1"));
        cpc.getRelSet().add(new LRSCompoundPC("set2"));
        cpc.getRelSet().add(new LRSCompoundPC("set3"));
        cpc.getStringCollection().add("val1");
        cpc.getStringCollection().add("val2");
        cpc.getStringCollection().add("val3");
        cpc.getRelCollection().add(new LRSCompoundPC("set1"));
        cpc.getRelCollection().add(new LRSCompoundPC("set2"));
        cpc.getRelCollection().add(new LRSCompoundPC("set3"));
        cpc.getStringMap().put("key1", "1");
        cpc.getStringMap().put("key2", "2");
        cpc.getStringMap().put("key3", "3");
        cpc.getRelMap().put("key1", new LRSCompoundPC("map1"));
        cpc.getRelMap().put("key2", new LRSCompoundPC("map2"));
        cpc.getRelMap().put("key3", new LRSCompoundPC("map3"));
        OpenJPAEntityManager pm = this.getEm(false, false);
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        pm.persist((Object)cpc);
        this.endTx((EntityManager)pm);
        this._oid = pm.getObjectId((Object)pc);
        this._coid = pm.getObjectId((Object)cpc);
        pm.close();
    }

    public void testStringSet() {
        this.stringCollectionTest(this._oid, true, true);
        this.stringCollectionTest(this._coid, true, true);
    }

    public void testStringSetRetain() {
        this.stringCollectionTest(this._oid, false, true);
        this.stringCollectionTest(this._coid, false, true);
    }

    public void testStringCollection() {
        this.stringCollectionTest(this._oid, true, false);
        this.stringCollectionTest(this._coid, true, false);
    }

    public void testStringCollectionRetain() {
        this.stringCollectionTest(this._oid, false, false);
        this.stringCollectionTest(this._coid, false, false);
    }

    private void stringCollectionTest(Object oid, boolean close, boolean isSet) {
        OpenJPAEntityManager pm = null;
        this.startTx((EntityManager)pm);
        LRSPCIntf pc = (LRSPCIntf)pm.getObjectId(oid);
        Collection<String> set = isSet ? pc.getStringSet() : pc.getStringCollection();
        TestLRSProxies.assertEquals((int)3, (int)set.size());
        TestLRSProxies.assertTrue((boolean)set.contains("val1"));
        TestLRSProxies.assertTrue((boolean)set.contains("val2"));
        TestLRSProxies.assertTrue((boolean)set.contains("val3"));
        if (!isSet) {
            Iterator itr = set.iterator();
            TestLRSProxies.assertEquals((Object)"val1", itr.next());
            TestLRSProxies.assertEquals((Object)"val2", itr.next());
            TestLRSProxies.assertEquals((Object)"val3", itr.next());
        }
        set.remove("val1");
        set.remove("val1");
        set.add("val4");
        set.remove("val4");
        set.add("val5");
        set.add("val6");
        this.assertStringCollectionChanged(set, isSet);
        this.endTx((EntityManager)pm);
        if (close) {
            pm.close();
            pm = this.getEm(false, false);
        }
        pc = (LRSPCIntf)pm.getObjectId(oid);
        set = isSet ? pc.getStringSet() : pc.getStringCollection();
        this.assertStringCollectionChanged(set, isSet);
        pm.close();
    }

    private void assertStringCollectionChanged(Collection set, boolean isSet) {
        TestLRSProxies.assertEquals((int)4, (int)set.size());
        TestLRSProxies.assertTrue((!set.contains("val1") ? 1 : 0) != 0);
        TestLRSProxies.assertTrue((boolean)set.contains("val2"));
        TestLRSProxies.assertTrue((boolean)set.contains("val3"));
        TestLRSProxies.assertTrue((!set.contains("val4") ? 1 : 0) != 0);
        TestLRSProxies.assertTrue((boolean)set.contains("val5"));
        TestLRSProxies.assertTrue((boolean)set.contains("val6"));
        if (!isSet) {
            Iterator itr = set.iterator();
            TestLRSProxies.assertEquals((Object)"val2", itr.next());
            TestLRSProxies.assertEquals((Object)"val3", itr.next());
            TestLRSProxies.assertEquals((Object)"val5", itr.next());
            TestLRSProxies.assertEquals((Object)"val6", itr.next());
            TestLRSProxies.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        }
    }

    public void testStringMap() {
        this.stringMapTest(this._oid, true);
        this.stringMapTest(this._coid, true);
    }

    public void testStringMapRetain() {
        this.stringMapTest(this._oid, false);
        this.stringMapTest(this._coid, false);
    }

    private void stringMapTest(Object oid, boolean close) {
        OpenJPAEntityManager pm = this.getEm(!close, !close);
        this.startTx((EntityManager)pm);
        LRSPCIntf pc = (LRSPCIntf)pm.getObjectId(oid);
        Map map = pc.getStringMap();
        TestLRSProxies.assertEquals((int)3, (int)map.size());
        TestLRSProxies.assertEquals((Object)"1", map.get("key1"));
        TestLRSProxies.assertEquals((Object)"2", map.get("key2"));
        TestLRSProxies.assertEquals((Object)"3", map.get("key3"));
        map.put("key1", "1a");
        map.put("key1", "1b");
        map.put("key2", "4");
        map.remove("key2");
        map.remove("foo");
        map.put("key5", "5");
        this.assertStringMapChanged(map);
        this.endTx((EntityManager)pm);
        if (close) {
            pm.close();
            pm = this.getEm(false, false);
        }
        pc = (LRSPCIntf)pm.getObjectId(oid);
        map = pc.getStringMap();
        this.assertStringMapChanged(map);
        pm.close();
    }

    private void assertStringMapChanged(Map map) {
        TestLRSProxies.assertEquals((int)3, (int)map.size());
        TestLRSProxies.assertEquals((Object)"1b", map.get("key1"));
        TestLRSProxies.assertEquals((Object)"3", map.get("key3"));
        TestLRSProxies.assertEquals((Object)"5", map.get("key5"));
        TestLRSProxies.assertNull(map.get("key2"));
        TestLRSProxies.assertTrue((boolean)map.containsKey("key1"));
        TestLRSProxies.assertFalse((boolean)map.containsKey("key2"));
        TestLRSProxies.assertTrue((boolean)map.containsValue("5"));
        TestLRSProxies.assertFalse((boolean)map.containsValue("1"));
        Iterator itr = map.entrySet().iterator();
        int count = 0;
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            if (entry.getKey().equals("key1")) {
                TestLRSProxies.assertEquals((Object)"1b", entry.getValue());
            } else if (entry.getKey().equals("key3")) {
                TestLRSProxies.assertEquals((Object)"3", entry.getValue());
            } else if (entry.getKey().equals("key5")) {
                TestLRSProxies.assertEquals((Object)"5", entry.getValue());
            } else {
                TestLRSProxies.fail((String)("Bad key: " + entry.getKey()));
            }
            ++count;
        }
        TestLRSProxies.assertEquals((int)3, (int)count);
    }

    public void testRelSet() {
        this.relCollectionTest(this._oid, true, true);
        this.relCollectionTest(this._coid, true, true);
    }

    public void testRelSetRetain() {
        this.relCollectionTest(this._oid, false, true);
        this.relCollectionTest(this._coid, false, true);
    }

    public void testRelCollection() {
        this.relCollectionTest(this._oid, true, false);
        this.relCollectionTest(this._coid, true, false);
    }

    public void testRelCollectionRetain() {
        this.relCollectionTest(this._oid, false, false);
        this.relCollectionTest(this._coid, false, false);
    }

    private void relCollectionTest(Object oid, boolean close, boolean isSet) {
        OpenJPAEntityManager pm = this.getEm(!close, !close);
        this.startTx((EntityManager)pm);
        LRSPCIntf pc = (LRSPCIntf)pm.getObjectId(oid);
        Collection<LRSPCIntf> set = isSet ? pc.getRelSet() : pc.getRelCollection();
        TestLRSProxies.assertEquals((int)3, (int)set.size());
        TreeSet ordered = new TreeSet();
        Iterator itr = set.iterator();
        ordered.add(itr.next());
        ordered.add(itr.next());
        ordered.add(itr.next());
        TestLRSProxies.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        itr = ordered.iterator();
        LRSPCIntf set1 = (LRSPCIntf)itr.next();
        if (!isSet) {
            LRSPCIntf set2 = (LRSPCIntf)itr.next();
            LRSPCIntf set3 = (LRSPCIntf)itr.next();
            TestLRSProxies.assertEquals((String)"set1", (String)set1.getStringField());
            TestLRSProxies.assertEquals((String)"set2", (String)set2.getStringField());
            TestLRSProxies.assertEquals((String)"set3", (String)set3.getStringField());
        }
        TestLRSProxies.assertTrue((boolean)set.contains(set1));
        TestLRSProxies.assertFalse((boolean)set.contains(pc));
        set.remove(set1);
        set.remove(set1);
        LRSPCIntf set4 = pc.newInstance("set4");
        set.add(set4);
        set.remove(set4);
        LRSPCIntf set5 = pc.newInstance("set5");
        set.add(set5);
        this.assertRelCollectionChanged(pc, isSet);
        this.endTx((EntityManager)pm);
        if (close) {
            pm.close();
            pm = this.getEm(false, false);
        }
        pc = (LRSPCIntf)pm.getObjectId(oid);
        this.assertRelCollectionChanged(pc, isSet);
        pm.close();
    }

    private void assertRelCollectionChanged(LRSPCIntf pc, boolean isSet) {
        Collection set = isSet ? pc.getRelSet() : pc.getRelCollection();
        TestLRSProxies.assertEquals((int)3, (int)set.size());
        TreeSet ordered = new TreeSet();
        Iterator itr = set.iterator();
        ordered.add(itr.next());
        ordered.add(itr.next());
        ordered.add(itr.next());
        TestLRSProxies.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        itr = ordered.iterator();
        LRSPCIntf set2 = (LRSPCIntf)itr.next();
        if (!isSet) {
            LRSPCIntf set3 = (LRSPCIntf)itr.next();
            LRSPCIntf set5 = (LRSPCIntf)itr.next();
            TestLRSProxies.assertEquals((String)"set2", (String)set2.getStringField());
            TestLRSProxies.assertEquals((String)"set3", (String)set3.getStringField());
            TestLRSProxies.assertEquals((String)"set5", (String)set5.getStringField());
        }
        TestLRSProxies.assertTrue((boolean)set.contains(set2));
        TestLRSProxies.assertFalse((boolean)set.contains(pc));
    }

    public void testRelMap() {
        this.relMapTest(this._oid, true);
        this.relMapTest(this._coid, true);
    }

    public void testRelMapRetain() {
        this.relMapTest(this._oid, false);
        this.relMapTest(this._coid, false);
    }

    private void relMapTest(Object oid, boolean close) {
        OpenJPAEntityManager pm = this.getEm(!close, !close);
        this.startTx((EntityManager)pm);
        LRSPCIntf pc = (LRSPCIntf)pm.getObjectId(oid);
        Map map = pc.getRelMap();
        TestLRSProxies.assertEquals((int)3, (int)map.size());
        LRSPCIntf map1 = (LRSPCIntf)map.get("key1");
        LRSPCIntf map2 = (LRSPCIntf)map.get("key2");
        LRSPCIntf map3 = (LRSPCIntf)map.get("key3");
        TestLRSProxies.assertEquals((String)"map1", (String)map1.getStringField());
        TestLRSProxies.assertEquals((String)"map2", (String)map2.getStringField());
        TestLRSProxies.assertEquals((String)"map3", (String)map3.getStringField());
        TestLRSProxies.assertTrue((boolean)map.containsKey("key1"));
        TestLRSProxies.assertFalse((boolean)map.containsKey("key4"));
        TestLRSProxies.assertTrue((boolean)map.containsValue(map1));
        TestLRSProxies.assertFalse((boolean)map.containsValue(pc));
        LRSPCIntf map1a = pc.newInstance("map1a");
        map.put("key1", map1a);
        LRSPCIntf map1b = pc.newInstance("map1b");
        map.put("key1", map1b);
        map.remove("key2");
        map.put("key4", pc.newInstance("map4"));
        map.remove("key4");
        map.remove("foo");
        map.put("key5", pc.newInstance("map5"));
        this.assertRelMapChanged(pc);
        this.endTx((EntityManager)pm);
        if (close) {
            pm.close();
            pm = this.getEm(false, false);
        }
        pc = (LRSPCIntf)pm.getObjectId(oid);
        this.assertRelMapChanged(pc);
        pm.close();
    }

    private void assertRelMapChanged(LRSPCIntf pc) {
        Map map = pc.getRelMap();
        TestLRSProxies.assertEquals((int)3, (int)map.size());
        LRSPCIntf map1b = (LRSPCIntf)map.get("key1");
        LRSPCIntf map3 = (LRSPCIntf)map.get("key3");
        LRSPCIntf map5 = (LRSPCIntf)map.get("key5");
        TestLRSProxies.assertEquals((String)"map1b", (String)map1b.getStringField());
        TestLRSProxies.assertEquals((String)"map3", (String)map3.getStringField());
        TestLRSProxies.assertEquals((String)"map5", (String)map5.getStringField());
        TestLRSProxies.assertTrue((boolean)map.containsKey("key1"));
        TestLRSProxies.assertFalse((boolean)map.containsKey("key2"));
        TestLRSProxies.assertTrue((boolean)map.containsValue(map1b));
        TestLRSProxies.assertFalse((boolean)map.containsValue(pc));
        Iterator itr = map.entrySet().iterator();
        int count = 0;
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            if (entry.getKey().equals("key1")) {
                TestLRSProxies.assertEquals((Object)map1b, entry.getValue());
            } else if (entry.getKey().equals("key3")) {
                TestLRSProxies.assertEquals((Object)map3, entry.getValue());
            } else if (entry.getKey().equals("key5")) {
                TestLRSProxies.assertEquals((Object)map5, entry.getValue());
            } else {
                TestLRSProxies.fail((String)("Bad key: " + entry.getKey()));
            }
            ++count;
        }
        TestLRSProxies.assertEquals((int)3, (int)count);
    }

    public void testTransfer() {
        OpenJPAEntityManager pm = this.getEm(true, true);
        LRSPC pc = (LRSPC)pm.getObjectId(this._oid);
        LRSPC map1 = (LRSPC)pc.getRelMap().get("key1");
        TestLRSProxies.assertNotNull((Object)map1);
        this.startTx((EntityManager)pm);
        Map map = pc.getRelMap();
        pc.setRelMap(null);
        map1.setRelMap(map);
        try {
            this.endTx((EntityManager)pm);
            TestLRSProxies.fail((String)"Allowed transfer of lrs field");
        }
        catch (Exception jue) {
            // empty catch block
        }
        if (pm.getTransaction().isActive()) {
            pm.getTransaction().rollback();
        }
        pm.close();
    }

    public void testShare() {
        OpenJPAEntityManager pm = this.getEm(true, true);
        LRSPC pc = (LRSPC)pm.getObjectId(this._oid);
        LRSPC map1 = (LRSPC)pc.getRelMap().get("key1");
        TestLRSProxies.assertNotNull((Object)map1);
        this.startTx((EntityManager)pm);
        Map map = pc.getRelMap();
        map1.setRelMap(map);
        this.endTx((EntityManager)pm);
        TestLRSProxies.assertTrue((pc.getRelMap() != map1.getRelMap() ? 1 : 0) != 0);
        TestLRSProxies.assertEquals((int)3, (int)map1.getRelMap().size());
        TestLRSProxies.assertTrue((boolean)map1.getRelMap().containsValue(map1));
        pm.close();
        pm = this.getEm(true, true);
        pc = (LRSPC)pm.getObjectId(this._oid);
        map1 = (LRSPC)pc.getRelMap().get("key1");
        TestLRSProxies.assertEquals((Object)map1, map1.getRelMap().get("key1"));
        pm.close();
    }

    public void testRollback() {
        Object factory = null;
        OpenJPAEntityManager pm = factory.createEntityManager();
        LRSPC pc = (LRSPC)pm.getObjectId(this._oid);
        this.startTx((EntityManager)pm);
        pc.getStringCollection().remove("val2");
        pc.getStringCollection().add("val4");
        this.rollbackTx((EntityManager)pm);
        TestLRSProxies.assertTrue((boolean)pc.getStringCollection().contains("val2"));
        TestLRSProxies.assertFalse((boolean)pc.getStringCollection().contains("val4"));
        pm.close();
        factory.close();
    }

    public void testReplace() {
        OpenJPAEntityManager pm = this.getEm(false, false);
        this.startTx((EntityManager)pm);
        LRSPC pc = (LRSPC)pm.getObjectId(this._oid);
        Collection set = new HashSet<String>();
        set.add("new");
        pc.setStringCollection(set);
        this.endTx((EntityManager)pm);
        pm.close();
        pm = this.getEm(false, false);
        pc = (LRSPC)pm.getObjectId(this._oid);
        set = pc.getStringCollection();
        TestLRSProxies.assertEquals((int)1, (int)set.size());
        TestLRSProxies.assertTrue((boolean)set.contains("new"));
        pm.close();
    }

    public void testAdd() throws Exception {
    }

    private OpenJPAEntityManager getEm(boolean optimistic, boolean retainValues) {
        OpenJPAEntityManager em = this.currentEntityManager();
        em.setNontransactionalRead(true);
        em.setRetainState(retainValues);
        em.setOptimistic(optimistic);
        return em;
    }
}

