/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.strats.RelationMapInverseKeyFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationMapTableFieldStrategy;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.common.apps.HelperPC;
import org.apache.openjpa.persistence.jdbc.common.apps.InverseKeyMapPC;
import org.apache.openjpa.persistence.jdbc.common.apps.JoinTableMapPC;
import org.apache.openjpa.persistence.jdbc.common.apps.MappedByMapPC;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;
import org.apache.openjpa.util.AbstractLRSProxyMap;

public class TestMappedByKeyMaps
extends BaseJDBCTest {
    public TestMappedByKeyMaps(String name) {
        super(name);
    }

    public void testInverseKeyMapMapping() {
        JDBCConfiguration conf = (JDBCConfiguration)this.getConfiguration();
        ClassMapping pc = conf.getMappingRepositoryInstance().getMapping(InverseKeyMapPC.class, null, true);
        FieldMapping map = pc.getFieldMapping("helpers");
        ClassMapping helper = conf.getMappingRepositoryInstance().getMapping(HelperPC.class, null, true);
        FieldMapping str = helper.getFieldMapping("stringField");
        TestMappedByKeyMaps.assertEquals((String)"stringField", (String)map.getKey().getValueMappedBy());
        TestMappedByKeyMaps.assertEquals((Object)str, (Object)map.getKey().getValueMappedByMetaData());
        TestMappedByKeyMaps.assertTrue((boolean)(map.getStrategy() instanceof RelationMapInverseKeyFieldStrategy));
        TestMappedByKeyMaps.assertEquals((int)1, (int)map.getKeyMapping().getColumns().length);
        TestMappedByKeyMaps.assertEquals((Object)map.getKeyMapping().getColumns()[0], (Object)str.getColumns()[0]);
    }

    public void testJoinTableMapMapping() {
        JDBCConfiguration conf = (JDBCConfiguration)this.getConfiguration();
        ClassMapping pc = conf.getMappingRepositoryInstance().getMapping(JoinTableMapPC.class, null, true);
        FieldMapping map = pc.getFieldMapping("helpers");
        ClassMapping helper = conf.getMappingRepositoryInstance().getMapping(HelperPC.class, null, true);
        FieldMapping str = helper.getFieldMapping("stringField");
        TestMappedByKeyMaps.assertEquals((String)"stringField", (String)map.getKey().getValueMappedBy());
        TestMappedByKeyMaps.assertEquals((Object)str, (Object)map.getKey().getValueMappedByMetaData());
        TestMappedByKeyMaps.assertTrue((boolean)(map.getStrategy() instanceof RelationMapTableFieldStrategy));
        TestMappedByKeyMaps.assertEquals((int)1, (int)map.getKeyMapping().getColumns().length);
        TestMappedByKeyMaps.assertEquals((Object)map.getKeyMapping().getColumns()[0], (Object)str.getColumns()[0]);
    }

    public void testInverseKeyMap() {
        this.mappedByMap(new InverseKeyMapPC(), false);
        this.queryMap(new InverseKeyMapPC());
    }

    public void testInverseKeyLRSMap() {
        this.mappedByMap(new InverseKeyMapPC(), true);
    }

    public void testJoinTableMap() {
        this.mappedByMap(new JoinTableMapPC(), false);
        this.queryMap(new JoinTableMapPC());
    }

    public void testJoinTableLRSMap() {
        this.mappedByMap(new JoinTableMapPC(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mappedByMap(MappedByMapPC pc, boolean lrs) {
        this.deleteAll(HelperPC.class);
        this.deleteAll(pc.getClass());
        HelperPC h1 = new HelperPC();
        h1.setStringField("h1");
        pc.getHelpers().put(h1.getStringField(), h1);
        HelperPC h2 = new HelperPC();
        h2.setStringField("h2");
        pc.getHelpers().put(h2.getStringField(), h2);
        HelperPC h3 = new HelperPC();
        h3.setStringField("h3");
        pc.getHelpers().put(h3.getStringField(), h3);
        this.setLRS(pc.getClass(), lrs);
        try {
            OpenJPAEntityManager pm = this.currentEntityManager();
            this.startTx((EntityManager)pm);
            pm.persist((Object)pc);
            this.endTx((EntityManager)pm);
            Object oid = pm.getObjectId((Object)pc);
            TestMappedByKeyMaps.assertFalse((boolean)pc.getHelpers().containsKey("foo"));
            TestMappedByKeyMaps.assertNull(pc.getHelpers().get("foo"));
            TestMappedByKeyMaps.assertEquals((int)3, (int)pc.getHelpers().size());
            TestMappedByKeyMaps.assertEquals((Object)h1, pc.getHelpers().get("h1"));
            TestMappedByKeyMaps.assertEquals((Object)h2, pc.getHelpers().get("h2"));
            pm.close();
            pm = this.currentEntityManager();
            pc = (MappedByMapPC)pm.getObjectId(oid);
            if (lrs) {
                TestMappedByKeyMaps.assertTrue((boolean)(pc.getHelpers() instanceof AbstractLRSProxyMap));
            }
            TestMappedByKeyMaps.assertEquals((int)3, (int)pc.getHelpers().size());
            TestMappedByKeyMaps.assertFalse((boolean)pc.getHelpers().containsKey("foo"));
            TestMappedByKeyMaps.assertNull(pc.getHelpers().get("foo"));
            TestMappedByKeyMaps.assertEquals((String)"h1", (String)((HelperPC)pc.getHelpers().get("h1")).getStringField());
            TestMappedByKeyMaps.assertEquals((String)"h2", (String)((HelperPC)pc.getHelpers().get("h2")).getStringField());
            pm.begin();
            pc.getHelpers().remove("h1");
            TestMappedByKeyMaps.assertEquals((int)2, (int)pc.getHelpers().size());
            TestMappedByKeyMaps.assertFalse((boolean)pc.getHelpers().containsKey("h1"));
            TestMappedByKeyMaps.assertNull(pc.getHelpers().get("h1"));
            HelperPC h4 = new HelperPC();
            h4.setStringField("h4");
            pc.getHelpers().put("h4", h4);
            TestMappedByKeyMaps.assertTrue((boolean)pc.getHelpers().containsKey("h4"));
            TestMappedByKeyMaps.assertEquals((Object)h4, pc.getHelpers().get("h4"));
            TestMappedByKeyMaps.assertEquals((int)3, (int)pc.getHelpers().size());
            pm.commit();
            TestMappedByKeyMaps.assertEquals((int)3, (int)pc.getHelpers().size());
            TestMappedByKeyMaps.assertFalse((boolean)pc.getHelpers().containsKey("h1"));
            TestMappedByKeyMaps.assertNull(pc.getHelpers().get("h1"));
            TestMappedByKeyMaps.assertEquals((String)"h2", (String)((HelperPC)pc.getHelpers().get("h2")).getStringField());
            TestMappedByKeyMaps.assertEquals((String)"h4", (String)((HelperPC)pc.getHelpers().get("h4")).getStringField());
            pm.close();
            pm = this.currentEntityManager();
            pc = (MappedByMapPC)pm.getObjectId(oid);
            TestMappedByKeyMaps.assertEquals((int)3, (int)pc.getHelpers().size());
            TestMappedByKeyMaps.assertFalse((boolean)pc.getHelpers().containsKey("h1"));
            TestMappedByKeyMaps.assertNull(pc.getHelpers().get("h1"));
            TestMappedByKeyMaps.assertEquals((String)"h2", (String)((HelperPC)pc.getHelpers().get("h2")).getStringField());
            TestMappedByKeyMaps.assertEquals((String)"h4", (String)((HelperPC)pc.getHelpers().get("h4")).getStringField());
            TestMappedByKeyMaps.assertTrue((boolean)pc.getHelpers().containsValue(pc.getHelpers().get("h2")));
            Set keySet = pc.getHelpers().keySet();
            TreeSet<Object> ordered = new TreeSet<Object>();
            TestMappedByKeyMaps.assertEquals((int)3, (int)keySet.size());
            Iterator<Object> itr = keySet.iterator();
            while (itr.hasNext()) {
                ordered.add(itr.next());
            }
            TestMappedByKeyMaps.assertEquals((int)3, (int)ordered.size());
            TestMappedByKeyMaps.assertTrue((boolean)ordered.contains("h2"));
            TestMappedByKeyMaps.assertTrue((boolean)ordered.contains("h3"));
            TestMappedByKeyMaps.assertTrue((boolean)ordered.contains("h4"));
            ordered.clear();
            Collection values = pc.getHelpers().values();
            TestMappedByKeyMaps.assertEquals((int)3, (int)values.size());
            for (Object next : values) {
                TestMappedByKeyMaps.assertTrue((boolean)(next instanceof HelperPC));
                ordered.add(((HelperPC)next).getStringField());
            }
            TestMappedByKeyMaps.assertEquals((int)3, (int)ordered.size());
            TestMappedByKeyMaps.assertTrue((boolean)ordered.contains("h2"));
            TestMappedByKeyMaps.assertTrue((boolean)ordered.contains("h3"));
            TestMappedByKeyMaps.assertTrue((boolean)ordered.contains("h4"));
            pm.close();
        }
        finally {
            this.unsetLRS(pc.getClass());
        }
    }

    private void queryMap(MappedByMapPC pc) {
        HelperPC h5 = new HelperPC();
        h5.setStringField("h5");
        pc.getHelpers().put("h5", h5);
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.begin();
        pm.persist((Object)pc);
        pm.commit();
        pm.close();
        pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createNativeQuery("stringField == 'h2'", HelperPC.class);
        HelperPC h2 = (HelperPC)q.getSingleResult();
        q = pm.createNativeQuery("helpers.containsKey ('h2')", pc.getClass());
        pc = (MappedByMapPC)q.getSingleResult();
        TestMappedByKeyMaps.assertEquals((int)3, (int)pc.getHelpers().size());
        TestMappedByKeyMaps.assertEquals((Object)h2, pc.getHelpers().get("h2"));
        q = pm.createNativeQuery("helpers.containsValue (:h2)", pc.getClass());
        pc = (MappedByMapPC)q.getSingleResult();
        TestMappedByKeyMaps.assertEquals((int)3, (int)pc.getHelpers().size());
        TestMappedByKeyMaps.assertEquals((Object)h2, pc.getHelpers().get("h2"));
        pm.close();
    }

    private void setLRS(Class cls, boolean lrs) {
        ClassMapping cm = ((JDBCConfiguration)this.getConfiguration()).getMappingRepositoryInstance().getMapping(cls, null, true);
        cm.getFieldMapping("helpers").setLRS(lrs);
    }

    private void unsetLRS(Class cls) {
        ClassMapping cm = ((JDBCConfiguration)this.getConfiguration()).getMappingRepositoryInstance().getMapping(cls, null, true);
        cm.getFieldMapping("helpers").setLRS(false);
    }
}

