/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityTransaction;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;
import org.apache.openjpa.persistence.jdbc.common.apps.MultiA;
import org.apache.openjpa.persistence.jdbc.common.apps.MultiB;
import org.apache.openjpa.persistence.jdbc.common.apps.MultiC;
import org.apache.openjpa.persistence.jdbc.common.apps.MultiD;
import org.apache.openjpa.persistence.jdbc.kernel.TestSQLListenerTestCase;

public class TestMultiTableMappings
extends TestSQLListenerTestCase {
    private Object aoid;
    private Object boid;
    private Object coid;
    private Object doid;

    public TestMultiTableMappings(String name) {
        super(name);
    }

    public TestMultiTableMappings() {
    }

    @Override
    public void setUpTestCase() {
        this.deleteAll(MultiA.class);
        OpenJPAEntityManager pm = this.currentEntityManager();
        ArrayList<MultiA> os = new ArrayList<MultiA>();
        MultiA a = new MultiA();
        MultiB b = new MultiB();
        MultiC c = new MultiC();
        MultiD d = new MultiD();
        os.add(a);
        os.add(b);
        os.add(c);
        os.add(d);
        d.setA(new MultiA());
        os.add(new MultiD());
        d.setDString1("d string 1");
        OpenJPAEntityTransaction t = pm.getTransaction();
        t.begin();
        pm.persistAll(os);
        t.commit();
        this.aoid = pm.getObjectId((Object)a);
        this.boid = pm.getObjectId((Object)b);
        this.coid = pm.getObjectId((Object)c);
        this.doid = pm.getObjectId((Object)d);
        pm.close();
    }

    public void XXXtestUpdates() {
    }

    public void XXXtestInserts() {
    }

    public void XXXtestOneToOne() {
    }

    public void XXXtestQueries() {
    }

    public void testVerticalQueryModeQueries() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createNativeQuery("", MultiA.class);
        ((JDBCFetchPlan)q.getFetchPlan()).setSubclassFetchMode(2);
        sql.clear();
        TestMultiTableMappings.assertEquals((String)sql.toString(), (int)0, (int)sql.size());
        Collection c = q.getCandidateCollection();
        if (((String)sql.get(0)).startsWith("SELECT DISTINCT")) {
            TestMultiTableMappings.assertEquals((String)sql.toString(), (int)5, (int)sql.size());
        } else {
            TestMultiTableMappings.assertEquals((String)sql.toString(), (int)4, (int)sql.size());
        }
        sql.clear();
        TestMultiTableMappings.assertEquals((int)6, (int)c.size());
        if (sql.size() != 0) {
            TestMultiTableMappings.assertEquals((String)sql.toString(), (int)4, (int)sql.size());
        }
        sql.clear();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            iter.next();
        }
        TestMultiTableMappings.assertEquals((String)sql.toString(), (int)0, (int)sql.size());
        pm.close();
    }

    private void changeA(MultiA a) {
        a.setString0(a.getString0() + " changed");
        a.setInt0(a.getInt0() + 1);
    }

    private void changeB(MultiB b) {
        this.changeA(b);
        b.setBString(b.getBString() + " changed");
    }

    private void changeC(MultiC c) {
        this.changeB(c);
        c.setCString0(c.getCString0() + " changed");
    }

    private void changeD(MultiD d) {
        this.changeB(d);
        d.setDString0(d.getDString0() + " changed");
    }
}

