/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ReverseMappingTool;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.lib.util.Files;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestUseSchemaElement
extends SingleEMFTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        File f = new File("target/orm.xml");
        if (f.exists()) {
            TestUseSchemaElement.assertTrue((boolean)f.delete());
        }
        this.setSupportedDatabases(DerbyDictionary.class);
    }

    @Override
    public String getPersistenceUnitName() {
        return "rev-mapping-pu";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGettersAndSetters() throws Exception {
        JDBCConfiguration conf = (JDBCConfiguration)this.emf.getConfiguration();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query q = em.createNativeQuery("CREATE TABLE USCHEMA.USCHANTBL (ID INTEGER PRIMARY KEY)");
        try {
            q.executeUpdate();
            em.getTransaction().commit();
        }
        catch (Throwable t) {
            em.getTransaction().rollback();
            System.out.println(t.toString());
        }
        ReverseMappingTool.Flags flags = new ReverseMappingTool.Flags();
        flags.metaDataLevel = "package";
        flags.generateAnnotations = true;
        flags.accessType = "property";
        flags.nullableAsObject = true;
        flags.useSchemaName = false;
        flags.useSchemaElement = false;
        flags.packageName = "";
        flags.directory = Files.getFile((String)"./target", null);
        ReverseMappingTool.run((JDBCConfiguration)conf, (String[])new String[0], (ReverseMappingTool.Flags)flags, null);
        File uschantbl = new File("./target/Uschantbl.java");
        Scanner inFile = null;
        try {
            inFile = new Scanner(uschantbl);
            while (inFile.hasNextLine()) {
                String currentLine = inFile.nextLine();
                if (currentLine.length() > 0 && currentLine.charAt(0) != '@' || !currentLine.contains("Table(schema=")) continue;
                TestUseSchemaElement.fail((String)"Uschantbl.java still contains schema name");
            }
        }
        catch (FileNotFoundException e) {
            TestUseSchemaElement.fail((String)"Uschantbl.java not generated in ./target by ReverseMappingTool");
        }
        finally {
            if (inFile != null) {
                inFile.close();
            }
        }
        TestUseSchemaElement.assertTrue((boolean)uschantbl.delete());
        File orm = new File("target/orm.xml");
        try {
            inFile = new Scanner(orm);
            while (inFile.hasNextLine()) {
                if (!inFile.nextLine().contains("<table schema=")) continue;
                TestUseSchemaElement.fail((String)"Orm.xml still contains schema name");
            }
        }
        catch (FileNotFoundException e) {
            TestUseSchemaElement.fail((String)"Orm.xml not generated in root directory by ReverseMappingTool");
        }
        finally {
            if (inFile != null) {
                inFile.close();
            }
        }
    }
}

