/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta.horizontal;

import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.common.apps.HorizD;
import org.apache.openjpa.persistence.jdbc.common.apps.HorizJ;
import org.apache.openjpa.persistence.jdbc.common.apps.HorizK;
import org.apache.openjpa.persistence.jdbc.kernel.TestSQLListenerTestCase;

public class TestQueryAgainstEntireMappedHierarchy
extends TestSQLListenerTestCase {
    public TestQueryAgainstEntireMappedHierarchy(String name) {
        super(name);
    }

    @Override
    public void setUpTestCase() {
        TestQueryAgainstEntireMappedHierarchy.assertTrue((HorizJ.class.getSuperclass() == HorizD.class ? 1 : 0) != 0);
        TestQueryAgainstEntireMappedHierarchy.assertTrue((HorizK.class.getSuperclass() == HorizJ.class ? 1 : 0) != 0);
        this.deleteAll(HorizD.class);
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getTransaction().begin();
        HorizD d = new HorizD();
        d.setStringA("stringa-d");
        d.setStringC("stringc-d");
        pm.persist((Object)d);
        HorizJ j = new HorizJ();
        j.setStringA("stringa-j");
        j.setStringC("stringc-j");
        pm.persist((Object)j);
        HorizK k = new HorizK();
        k.setStringA("stringa-k");
        k.setStringC("stringc-k");
        pm.persist((Object)k);
        pm.getTransaction().commit();
        pm.close();
    }

    public void testQueryAgainstEntireMappedHierarchy() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        sql.clear();
        String lastStatement = (String)sql.get(sql.size() - 1);
        TestQueryAgainstEntireMappedHierarchy.assertTrue((lastStatement.toLowerCase().indexOf("in (") == -1 ? 1 : 0) != 0);
        pm.close();
    }
}

