/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta.vertical;

import java.util.Iterator;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.Extent;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.common.apps.JoinSubclassBase;
import org.apache.openjpa.persistence.jdbc.common.apps.JoinSubclassBaseSubFlat;
import org.apache.openjpa.persistence.jdbc.common.apps.JoinSubclassBaseSubVert;
import org.apache.openjpa.persistence.jdbc.kernel.TestSQLListenerTestCase;
import org.apache.openjpa.util.Id;

public class TestJoinSubclasses
extends TestSQLListenerTestCase {
    private String _outer = "OUTER";
    private Object _base = null;
    private Object _baseSubFlat = null;

    public TestJoinSubclasses(String name) {
        super(name);
    }

    public boolean skipTest() {
        return false;
    }

    @Override
    public void setUpTestCase() {
        if (((JDBCConfiguration)this.getConfiguration()).getDBDictionaryInstance().joinSyntax == 2) {
            this._outer = "(+)";
        }
        this.deleteAll(JoinSubclassBase.class);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        JoinSubclassBase base = new JoinSubclassBase();
        base.setBaseField(1);
        pm.persist((Object)base);
        JoinSubclassBaseSubVert sub1 = new JoinSubclassBaseSubVert();
        sub1.setBaseField(2);
        sub1.setBaseSubVertField(3);
        pm.persist((Object)sub1);
        JoinSubclassBaseSubFlat sub2 = new JoinSubclassBaseSubFlat();
        sub2.setBaseField(3);
        sub2.setBaseSubVertField(4);
        sub2.setBaseSubFlatField(5);
        pm.persist((Object)sub2);
        this.endTx((EntityManager)pm);
        this._base = pm.getObjectId((Object)base);
        this._baseSubFlat = pm.getObjectId((Object)sub2);
        pm.close();
    }

    public void testBaseExtentNoSubs() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Extent extent = pm.createExtent(JoinSubclassBase.class, false);
        Iterator itr = extent.iterator();
        TestJoinSubclasses.assertTrue((boolean)itr.hasNext());
        JoinSubclassBase pc = (JoinSubclassBase)itr.next();
        TestJoinSubclasses.assertEquals((int)1, (int)pc.getBaseField());
        TestJoinSubclasses.assertEquals(JoinSubclassBase.class, pc.getClass());
        TestJoinSubclasses.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        extent.closeAll();
        pm.close();
        TestJoinSubclasses.assertEquals((String)sql.toString(), (int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
    }

    public void testBaseExtentWithSubs() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Extent extent = pm.createExtent(JoinSubclassBase.class, true);
        TreeSet pcs = new TreeSet(extent.list());
        TestJoinSubclasses.assertEquals((int)3, (int)pcs.size());
        Iterator itr = pcs.iterator();
        block5: for (int i = 0; i < 2; ++i) {
            JoinSubclassBase pc = (JoinSubclassBase)itr.next();
            TestJoinSubclasses.assertEquals((int)(i + 1), (int)pc.getBaseField());
            switch (i) {
                case 0: {
                    TestJoinSubclasses.assertEquals(JoinSubclassBase.class, pc.getClass());
                    continue block5;
                }
                case 1: {
                    TestJoinSubclasses.assertEquals(JoinSubclassBaseSubVert.class, pc.getClass());
                    TestJoinSubclasses.assertEquals((int)(i + 2), (int)((JoinSubclassBaseSubVert)pc).getBaseSubVertField());
                    continue block5;
                }
                case 2: {
                    TestJoinSubclasses.assertEquals(JoinSubclassBaseSubFlat.class, pc.getClass());
                    TestJoinSubclasses.assertEquals((int)(i + 2), (int)((JoinSubclassBaseSubFlat)pc).getBaseSubVertField());
                    TestJoinSubclasses.assertEquals((int)(i + 3), (int)((JoinSubclassBaseSubFlat)pc).getBaseSubFlatField());
                }
            }
        }
        pm.close();
        TestJoinSubclasses.assertEquals((String)sql.toString(), (int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }

    public void testLeafExtent() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Extent extent = pm.createExtent(JoinSubclassBaseSubFlat.class, false);
        Iterator itr = extent.iterator();
        TestJoinSubclasses.assertTrue((boolean)itr.hasNext());
        JoinSubclassBaseSubFlat pc = (JoinSubclassBaseSubFlat)itr.next();
        TestJoinSubclasses.assertEquals((int)3, (int)pc.getBaseField());
        TestJoinSubclasses.assertEquals((int)4, (int)pc.getBaseSubVertField());
        TestJoinSubclasses.assertEquals((int)5, (int)pc.getBaseSubFlatField());
        TestJoinSubclasses.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        extent.closeAll();
        pm.close();
        TestJoinSubclasses.assertEquals((String)sql.toString(), (int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
    }

    public void testBaseGetById() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        JoinSubclassBase pc = (JoinSubclassBase)pm.getObjectId(this._base);
        TestJoinSubclasses.assertEquals((int)1, (int)pc.getBaseField());
        TestJoinSubclasses.assertEquals(JoinSubclassBase.class, pc.getClass());
        pm.close();
        TestJoinSubclasses.assertEquals((String)sql.toString(), (int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
        sql.clear();
        Id oid = new Id(JoinSubclassBase.class, ((Id)this._base).getId());
        pm = this.currentEntityManager();
        pc = (JoinSubclassBase)pm.getObjectId((Object)oid);
        TestJoinSubclasses.assertEquals((int)1, (int)pc.getBaseField());
        pm.close();
        TestJoinSubclasses.assertEquals((String)sql.toString(), (int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }

    public void testLeafGetById() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        JoinSubclassBaseSubFlat pc = (JoinSubclassBaseSubFlat)pm.getObjectId(this._baseSubFlat);
        TestJoinSubclasses.assertEquals((int)3, (int)pc.getBaseField());
        TestJoinSubclasses.assertEquals((int)4, (int)pc.getBaseSubVertField());
        TestJoinSubclasses.assertEquals((int)5, (int)pc.getBaseSubFlatField());
        pm.close();
        TestJoinSubclasses.assertEquals((String)sql.toString(), (int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
        sql.clear();
        Id oid = new Id(JoinSubclassBase.class, ((Id)this._baseSubFlat).getId());
        pm = this.currentEntityManager();
        pc = (JoinSubclassBaseSubFlat)pm.getObjectId((Object)oid);
        TestJoinSubclasses.assertEquals((int)3, (int)pc.getBaseField());
        TestJoinSubclasses.assertEquals((int)4, (int)pc.getBaseSubVertField());
        TestJoinSubclasses.assertEquals((int)5, (int)pc.getBaseSubFlatField());
        pm.close();
        TestJoinSubclasses.assertEquals((String)sql.toString(), (int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }
}

