/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta.vertical;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.common.apps.Base;
import org.apache.openjpa.persistence.jdbc.common.apps.BaseSub1;
import org.apache.openjpa.persistence.jdbc.common.apps.BaseSub1Sub1;
import org.apache.openjpa.persistence.jdbc.common.apps.BaseSub1Sub2;
import org.apache.openjpa.persistence.jdbc.common.apps.BaseSub2;
import org.apache.openjpa.persistence.jdbc.common.apps.Relations;
import org.apache.openjpa.persistence.jdbc.kernel.TestSQLListenerTestCase;

public class TestSubclassJoinRelations
extends TestSQLListenerTestCase {
    private String _outer = "OUTER";
    private Object _oid = null;

    public TestSubclassJoinRelations(String name) {
        super(name);
    }

    public boolean skipTest() {
        return false;
    }

    @Override
    public void setUpTestCase() {
        Class[] reg = new Class[]{Base.class, BaseSub1.class, BaseSub2.class, BaseSub1Sub1.class, BaseSub1Sub2.class};
        if (((JDBCConfiguration)this.getConfiguration()).getDBDictionaryInstance().joinSyntax == 2) {
            this._outer = "(+)";
        }
        this.deleteAll(Relations.class);
        this.deleteAll(Base.class);
        Relations rel = new Relations();
        BaseSub2 sub2 = new BaseSub2();
        sub2.setBaseField(3);
        sub2.setBaseSub2Field(4);
        rel.setBase(sub2);
        BaseSub1 sub1 = new BaseSub1();
        sub1.setBaseField(2);
        sub1.setBaseSub1Field(3);
        rel.setBaseSub1(sub1);
        BaseSub1Sub2 sub1sub2 = new BaseSub1Sub2();
        sub1sub2.setBaseField(4);
        sub1sub2.setBaseSub1Field(5);
        sub1sub2.setBaseSub1Sub2Field(6);
        rel.setBaseSub1Sub2(sub1sub2);
        Base base = new Base();
        base.setBaseField(1);
        rel.getBaseList().add(base);
        rel.getBaseList().add(sub2);
        rel.getBaseSub1List().add(sub1);
        rel.getBaseSub1List().add(sub1sub2);
        rel.getBaseSub1Sub2List().add(sub1sub2);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)rel);
        this.endTx((EntityManager)pm);
        this._oid = pm.getObjectId((Object)rel);
        pm.close();
    }

    public void testNullOneOne() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Relations rel = (Relations)pm.getObjectId(this._oid);
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
        sql.clear();
        TestSubclassJoinRelations.assertNull((Object)rel.getNullBase());
        pm.close();
        TestSubclassJoinRelations.assertEquals((int)0, (int)sql.size());
    }

    public void testEagerNullOneOne() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("nullBase");
        Relations rel = (Relations)pm.getObjectId(this._oid);
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
        sql.clear();
        TestSubclassJoinRelations.assertNull((Object)rel.getNullBase());
        pm.close();
        TestSubclassJoinRelations.assertEquals((int)0, (int)sql.size());
    }

    public void testEmptyBaseList() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Relations rel = (Relations)pm.getObjectId(this._oid);
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
        sql.clear();
        TestSubclassJoinRelations.assertEquals((int)0, (int)rel.getEmptyBaseList().size());
        pm.close();
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }

    public void testEagerEmptyBaseList() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("emptyBaseList");
        Relations rel = (Relations)pm.getObjectId(this._oid);
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
        sql.clear();
        TestSubclassJoinRelations.assertEquals((int)0, (int)rel.getEmptyBaseList().size());
        pm.close();
        TestSubclassJoinRelations.assertEquals((int)0, (int)sql.size());
    }

    public void testBaseOneOne() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Relations rel = (Relations)pm.getObjectId(this._oid);
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
        sql.clear();
        BaseSub2 sub2 = (BaseSub2)rel.getBase();
        TestSubclassJoinRelations.assertEquals((int)3, (int)sub2.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)4, (int)sub2.getBaseSub2Field());
        TestSubclassJoinRelations.assertEquals(BaseSub2.class, sub2.getClass());
        pm.close();
        TestSubclassJoinRelations.assertEquals((String)sql.toString(), (int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }

    public void testEagerBaseOneOne() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("base");
        Relations rel = (Relations)pm.getObjectId(this._oid);
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
        sql.clear();
        BaseSub2 sub2 = (BaseSub2)rel.getBase();
        TestSubclassJoinRelations.assertEquals((int)3, (int)sub2.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)4, (int)sub2.getBaseSub2Field());
        TestSubclassJoinRelations.assertEquals(BaseSub2.class, sub2.getClass());
        pm.close();
        TestSubclassJoinRelations.assertEquals((int)0, (int)sql.size());
    }

    public void testLeafOneOne() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Relations rel = (Relations)pm.getObjectId(this._oid);
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
        sql.clear();
        BaseSub1Sub2 sub1sub2 = rel.getBaseSub1Sub2();
        TestSubclassJoinRelations.assertEquals((int)4, (int)sub1sub2.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)5, (int)sub1sub2.getBaseSub1Field());
        TestSubclassJoinRelations.assertEquals((int)6, (int)sub1sub2.getBaseSub1Sub2Field());
        pm.close();
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
    }

    public void testEagerLeafOneOne() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("baseSub1Sub2");
        Relations rel = (Relations)pm.getObjectId(this._oid);
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
        sql.clear();
        BaseSub1Sub2 sub1sub2 = rel.getBaseSub1Sub2();
        TestSubclassJoinRelations.assertEquals((int)4, (int)sub1sub2.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)5, (int)sub1sub2.getBaseSub1Field());
        TestSubclassJoinRelations.assertEquals((int)6, (int)sub1sub2.getBaseSub1Sub2Field());
        pm.close();
        TestSubclassJoinRelations.assertEquals((int)0, (int)sql.size());
    }

    public void testMidOneOne() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Relations rel = (Relations)pm.getObjectId(this._oid);
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
        sql.clear();
        BaseSub1 sub1 = rel.getBaseSub1();
        TestSubclassJoinRelations.assertEquals((int)2, (int)sub1.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)3, (int)sub1.getBaseSub1Field());
        TestSubclassJoinRelations.assertEquals(BaseSub1.class, sub1.getClass());
        pm.close();
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }

    public void testEagerMidOneOne() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("baseSub1");
        Relations rel = (Relations)pm.getObjectId(this._oid);
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
        sql.clear();
        BaseSub1 sub1 = rel.getBaseSub1();
        TestSubclassJoinRelations.assertEquals((int)2, (int)sub1.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)3, (int)sub1.getBaseSub1Field());
        TestSubclassJoinRelations.assertEquals(BaseSub1.class, sub1.getClass());
        pm.close();
        TestSubclassJoinRelations.assertEquals((int)0, (int)sql.size());
    }

    public void testBaseList() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Relations rel = (Relations)pm.getObjectId(this._oid);
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
        sql.clear();
        List list = rel.getBaseList();
        TestSubclassJoinRelations.assertEquals((int)2, (int)list.size());
        Base base = (Base)list.get(0);
        TestSubclassJoinRelations.assertEquals((int)1, (int)base.getBaseField());
        TestSubclassJoinRelations.assertEquals(Base.class, base.getClass());
        BaseSub2 sub2 = (BaseSub2)list.get(1);
        TestSubclassJoinRelations.assertEquals((int)3, (int)sub2.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)4, (int)sub2.getBaseSub2Field());
        TestSubclassJoinRelations.assertEquals(BaseSub2.class, sub2.getClass());
        pm.close();
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }

    public void testEagerBaseList() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("baseList");
        Relations rel = (Relations)pm.getObjectId(this._oid);
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
        sql.clear();
        List list = rel.getBaseList();
        TestSubclassJoinRelations.assertEquals((int)2, (int)list.size());
        Base base = (Base)list.get(0);
        TestSubclassJoinRelations.assertEquals((int)1, (int)base.getBaseField());
        TestSubclassJoinRelations.assertEquals(Base.class, base.getClass());
        BaseSub2 sub2 = (BaseSub2)list.get(1);
        TestSubclassJoinRelations.assertEquals((int)3, (int)sub2.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)4, (int)sub2.getBaseSub2Field());
        TestSubclassJoinRelations.assertEquals(BaseSub2.class, sub2.getClass());
        pm.close();
        TestSubclassJoinRelations.assertEquals((int)0, (int)sql.size());
    }

    public void testLeafList() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Relations rel = (Relations)pm.getObjectId(this._oid);
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
        sql.clear();
        List list = rel.getBaseSub1Sub2List();
        TestSubclassJoinRelations.assertEquals((int)1, (int)list.size());
        BaseSub1Sub2 sub1sub2 = (BaseSub1Sub2)list.get(0);
        TestSubclassJoinRelations.assertEquals((int)4, (int)sub1sub2.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)5, (int)sub1sub2.getBaseSub1Field());
        TestSubclassJoinRelations.assertEquals((int)6, (int)sub1sub2.getBaseSub1Sub2Field());
        pm.close();
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
    }

    public void testEagerLeafList() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("baseSub1Sub2List");
        Relations rel = (Relations)pm.getObjectId(this._oid);
        TestSubclassJoinRelations.assertEquals((int)2, (int)sql.size());
        this.assertNotSQL(this._outer);
        sql.clear();
        List list = rel.getBaseSub1Sub2List();
        TestSubclassJoinRelations.assertEquals((int)1, (int)list.size());
        BaseSub1Sub2 sub1sub2 = (BaseSub1Sub2)list.get(0);
        TestSubclassJoinRelations.assertEquals((int)4, (int)sub1sub2.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)5, (int)sub1sub2.getBaseSub1Field());
        TestSubclassJoinRelations.assertEquals((int)6, (int)sub1sub2.getBaseSub1Sub2Field());
        pm.close();
        TestSubclassJoinRelations.assertEquals((int)0, (int)sql.size());
    }

    public void testMidList() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Relations rel = (Relations)pm.getObjectId(this._oid);
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
        sql.clear();
        List list = rel.getBaseSub1List();
        TestSubclassJoinRelations.assertEquals((int)2, (int)list.size());
        BaseSub1 sub1 = (BaseSub1)list.get(0);
        TestSubclassJoinRelations.assertEquals((int)2, (int)sub1.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)3, (int)sub1.getBaseSub1Field());
        TestSubclassJoinRelations.assertEquals(BaseSub1.class, sub1.getClass());
        BaseSub1Sub2 sub1sub2 = (BaseSub1Sub2)list.get(1);
        TestSubclassJoinRelations.assertEquals((int)4, (int)sub1sub2.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)5, (int)sub1sub2.getBaseSub1Field());
        TestSubclassJoinRelations.assertEquals((int)6, (int)sub1sub2.getBaseSub1Sub2Field());
        pm.close();
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }

    public void testEagerMidList() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getFetchPlan().addFetchGroup("baseSub1List");
        Relations rel = (Relations)pm.getObjectId(this._oid);
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
        sql.clear();
        List list = rel.getBaseSub1List();
        TestSubclassJoinRelations.assertEquals((int)2, (int)list.size());
        BaseSub1 sub1 = (BaseSub1)list.get(0);
        TestSubclassJoinRelations.assertEquals((int)2, (int)sub1.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)3, (int)sub1.getBaseSub1Field());
        TestSubclassJoinRelations.assertEquals(BaseSub1.class, sub1.getClass());
        BaseSub1Sub2 sub1sub2 = (BaseSub1Sub2)list.get(1);
        TestSubclassJoinRelations.assertEquals((int)4, (int)sub1sub2.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)5, (int)sub1sub2.getBaseSub1Field());
        TestSubclassJoinRelations.assertEquals((int)6, (int)sub1sub2.getBaseSub1Sub2Field());
        pm.close();
        TestSubclassJoinRelations.assertEquals((int)0, (int)sql.size());
    }

    public void testProjections() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createNativeQuery("", Relations.class);
        Object res = null;
        TestSubclassJoinRelations.assertNotNull(res);
        TestSubclassJoinRelations.assertEquals((int)3, (int)(res).length);
        BaseSub2 sub2 = (BaseSub2)res[0];
        TestSubclassJoinRelations.assertEquals((int)3, (int)sub2.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)4, (int)sub2.getBaseSub2Field());
        TestSubclassJoinRelations.assertEquals(BaseSub2.class, sub2.getClass());
        BaseSub1 sub1 = (BaseSub1)res[1];
        TestSubclassJoinRelations.assertEquals((int)2, (int)sub1.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)3, (int)sub1.getBaseSub1Field());
        TestSubclassJoinRelations.assertEquals(BaseSub1.class, sub1.getClass());
        BaseSub1Sub2 sub1sub2 = (BaseSub1Sub2)res[2];
        TestSubclassJoinRelations.assertEquals((int)4, (int)sub1sub2.getBaseField());
        TestSubclassJoinRelations.assertEquals((int)5, (int)sub1sub2.getBaseSub1Field());
        TestSubclassJoinRelations.assertEquals((int)6, (int)sub1sub2.getBaseSub1Sub2Field());
        pm.close();
        TestSubclassJoinRelations.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }
}

