/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.oracle;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.oracle.PObject;
import org.apache.openjpa.persistence.jdbc.oracle.PObjectNative;
import org.apache.openjpa.persistence.test.DatabasePlatform;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

@DatabasePlatform(value="oracle.jdbc.driver.OracleDriver")
public class TestAutoIncrement
extends SingleEMFTestCase {
    @Override
    public void setUp() throws Exception {
        this.setSupportedDatabases(OracleDictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        if ("testAutoIncrementIdentityWithNamedSequence".equals(this.getName())) {
            String sequence = "autoIncrementSequence";
            this.createSequence(sequence);
            super.setUp(CLEAR_TABLES, PObject.class, "openjpa.jdbc.DBDictionary", "oracle(UseTriggersForAutoAssign=true,autoAssignSequenceName=" + sequence + ")");
        } else {
            super.setUp(CLEAR_TABLES, PObjectNative.class, "openjpa.jdbc.DBDictionary", "oracle(UseTriggersForAutoAssign=true)");
        }
    }

    public void testAutoIncrementIdentityWithNamedSequence() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PObject pc1 = new PObject();
        PObject pc2 = new PObject();
        em.persist((Object)pc1);
        em.persist((Object)pc2);
        em.getTransaction().commit();
        TestAutoIncrement.assertEquals((long)1L, (long)Math.abs(pc1.getId() - pc2.getId()));
        em.close();
    }

    public void testAutoIncrementIdentityWithNativeSequence() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PObjectNative pc1 = new PObjectNative();
        PObjectNative pc2 = new PObjectNative();
        em.persist((Object)pc1);
        em.persist((Object)pc2);
        em.getTransaction().commit();
        TestAutoIncrement.assertEquals((long)1L, (long)Math.abs(pc1.getId() - pc2.getId()));
        em.close();
    }

    private void createSequence(String sequence) {
        OpenJPAEntityManagerFactorySPI factorySPI = this.createEMF(new Object[0]);
        OpenJPAEntityManagerSPI em = factorySPI.createEntityManager();
        try {
            em.getTransaction().begin();
            OpenJPAQuery q = em.createNativeQuery("CREATE SEQUENCE " + sequence + " START WITH 1");
            q.executeUpdate();
            em.getTransaction().commit();
        }
        catch (PersistenceException e) {
            em.getTransaction().rollback();
        }
        this.closeEM((EntityManager)em);
        this.closeEMF((EntityManagerFactory)factorySPI);
    }
}

