/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.order;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.order.BattingOrder;
import org.apache.openjpa.persistence.jdbc.order.BiOrderEntity;
import org.apache.openjpa.persistence.jdbc.order.BiOrderMappedByEntity;
import org.apache.openjpa.persistence.jdbc.order.Bicycle;
import org.apache.openjpa.persistence.jdbc.order.Car;
import org.apache.openjpa.persistence.jdbc.order.Course;
import org.apache.openjpa.persistence.jdbc.order.Game;
import org.apache.openjpa.persistence.jdbc.order.Home;
import org.apache.openjpa.persistence.jdbc.order.Inning;
import org.apache.openjpa.persistence.jdbc.order.Owner;
import org.apache.openjpa.persistence.jdbc.order.Person;
import org.apache.openjpa.persistence.jdbc.order.Player;
import org.apache.openjpa.persistence.jdbc.order.Student;
import org.apache.openjpa.persistence.jdbc.order.Trainer;
import org.apache.openjpa.persistence.jdbc.order.Widget;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestOrderColumn
extends SingleEMFTestCase {
    private Student[] students = new Student[12];

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, Person.class, Player.class, BattingOrder.class, Trainer.class, Game.class, Inning.class, Course.class, Student.class, Owner.class, Bicycle.class, Car.class, Home.class, Widget.class, BiOrderMappedByEntity.class, BiOrderEntity.class);
        try {
            this.createQueryData();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testOneToManyElementRemoval() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.validateOrderColumnName(BattingOrder.class, "batters", "batters_ORDER");
        Player[] players = new Player[10];
        ArrayList<Player> playersArr = new ArrayList<Player>();
        em.getTransaction().begin();
        for (int i2 = 0; i2 < 10; ++i2) {
            players[i2] = new Player("Player" + i2, i2 + 100);
            em.persist((Object)players[i2]);
            playersArr.add(players[i2]);
        }
        em.getTransaction().commitAndResume();
        BattingOrder order = new BattingOrder();
        order.setBatters(playersArr);
        em.persist((Object)order);
        em.getTransaction().commit();
        em.refresh((Object)order);
        em.clear();
        BattingOrder newOrder = (BattingOrder)em.find(BattingOrder.class, (Object)BattingOrder.pcGetid(order));
        TestOrderColumn.assertNotNull((Object)newOrder);
        for (i = 0; i < 10; ++i) {
            TestOrderColumn.assertEquals((Object)newOrder.getBatters().get(i), (Object)players[i]);
        }
        em.getTransaction().begin();
        newOrder.getBatters().remove(1);
        playersArr.remove(1);
        newOrder.getBatters().remove(5);
        playersArr.remove(5);
        em.getTransaction().commit();
        em.clear();
        newOrder = (BattingOrder)em.find(BattingOrder.class, (Object)BattingOrder.pcGetid(order));
        TestOrderColumn.assertNotNull((Object)newOrder);
        TestOrderColumn.assertNotNull(newOrder.getBatters());
        TestOrderColumn.assertEquals((int)playersArr.size(), (int)newOrder.getBatters().size());
        for (i = 0; i < playersArr.size(); ++i) {
            TestOrderColumn.assertEquals((Object)newOrder.getBatters().get(i), (Object)playersArr.get(i));
        }
        this.validateIndexAndValues(em, "BattingOrder", "batters", 0, playersArr.toArray(), "id", BattingOrder.pcGetid(order));
        em.close();
    }

    public void testOneToManyBiDirElementRemoval() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.validateOrderColumnName(BiOrderMappedByEntity.class, "bo2mEntities", "bo2mEntities_ORDER");
        BiOrderMappedByEntity bome = new BiOrderMappedByEntity();
        bome.setId(1);
        ArrayList<BiOrderEntity> boea = new ArrayList<BiOrderEntity>();
        for (int i2 = 0; i2 < 5; ++i2) {
            BiOrderEntity boe = new BiOrderEntity();
            boe.setId(i2 + 1);
            boe.setName("Entity" + i2);
            boe.setEntity(bome);
            boea.add(boe);
            bome.addBo2mEntity(boe);
        }
        em.getTransaction().begin();
        em.persist((Object)bome);
        for (BiOrderEntity boe : boea) {
            em.persist((Object)boe);
        }
        em.getTransaction().commit();
        em.refresh((Object)bome);
        em.clear();
        BiOrderMappedByEntity newBome = (BiOrderMappedByEntity)em.find(BiOrderMappedByEntity.class, (Object)bome.getId());
        TestOrderColumn.assertNotNull((Object)newBome);
        for (i = 0; i < 5; ++i) {
            TestOrderColumn.assertEquals((Object)newBome.getBo2mEntities().get(i), boea.get(i));
        }
        em.getTransaction().begin();
        newBome.getBo2mEntities().get(2).setEntity(null);
        newBome.removeBo2mEntity(2);
        boea.remove(2);
        em.getTransaction().commit();
        em.clear();
        newBome = (BiOrderMappedByEntity)em.find(BiOrderMappedByEntity.class, (Object)bome.getId());
        TestOrderColumn.assertNotNull((Object)newBome);
        TestOrderColumn.assertNotNull(newBome.getBo2mEntities());
        TestOrderColumn.assertEquals((int)boea.size(), (int)newBome.getBo2mEntities().size());
        for (i = 0; i < boea.size(); ++i) {
            TestOrderColumn.assertEquals((Object)newBome.getBo2mEntities().get(i), boea.get(i));
        }
        this.validateIndexAndValues(em, "BiOrderMappedByEntity", "bo2mEntities", 0, boea.toArray(), "id", bome.getId());
        em.close();
    }

    public void testElementCollectionElementRemoval() {
        int i;
        int i2;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Game game = new Game();
        this.validateOrderColumnName(Game.class, "rainDates", "dateOrder");
        Date[] dates = new Date[10];
        ArrayList<Date> rainDates = new ArrayList<Date>(10);
        Calendar today = Calendar.getInstance();
        for (i2 = 0; i2 < 10; ++i2) {
            today.set(2009, 1, i2 + 1);
            dates[i2] = new Date(today.getTimeInMillis());
        }
        for (i2 = 9; i2 >= 0; --i2) {
            rainDates.add(dates[i2]);
        }
        game.setRainDates(rainDates);
        em.getTransaction().begin();
        em.persist((Object)game);
        em.getTransaction().commit();
        em.clear();
        Game newGame = (Game)em.find(Game.class, (Object)game.getId());
        TestOrderColumn.assertNotNull((Object)newGame);
        for (i = 0; i < 10; ++i) {
            TestOrderColumn.assertEquals((Object)game.getRainDates().get(i), (Object)rainDates.get(i));
        }
        em.getTransaction().begin();
        newGame.getRainDates().remove(4);
        rainDates.remove(4);
        newGame.getRainDates().remove(2);
        rainDates.remove(2);
        em.getTransaction().commit();
        em.clear();
        newGame = (Game)em.find(Game.class, (Object)game.getId());
        TestOrderColumn.assertNotNull((Object)newGame);
        TestOrderColumn.assertNotNull(newGame.getRainDates());
        TestOrderColumn.assertEquals((int)8, (int)newGame.getRainDates().size());
        for (i = 0; i < newGame.getRainDates().size(); ++i) {
            TestOrderColumn.assertEquals((String)newGame.getRainDates().get(i).toString(), (String)rainDates.get(i).toString());
        }
        this.validateCollIndexAndValues(em, "Game", "rainDates", 0, newGame.getRainDates().toArray(), "id", newGame.getId());
        em.close();
    }

    public void testOneToManyElementInsert() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.validateOrderColumnName(BattingOrder.class, "batters", "batters_ORDER");
        Player[] players = new Player[10];
        ArrayList<Player> playersArr = new ArrayList<Player>();
        em.getTransaction().begin();
        for (int i = 0; i < 10; ++i) {
            players[i] = new Player("Player" + i, i + 100);
            em.persist((Object)players[i]);
            playersArr.add(players[i]);
        }
        em.getTransaction().commitAndResume();
        BattingOrder order = new BattingOrder();
        order.setBatters(playersArr);
        em.persist((Object)order);
        em.getTransaction().commitAndResume();
        em.refresh((Object)order);
        em.getTransaction().commit();
        em.clear();
        BattingOrder newOrder = (BattingOrder)em.find(BattingOrder.class, (Object)BattingOrder.pcGetid(order));
        TestOrderColumn.assertNotNull((Object)newOrder);
        for (int i = 0; i < 10; ++i) {
            TestOrderColumn.assertEquals((Object)newOrder.getBatters().get(i), (Object)players[i]);
        }
        Player p = new Player("PlayerNew", 150);
        playersArr.add(2, p);
        Player p2 = new Player("PlayerNew2", 151);
        playersArr.add(p2);
        em.getTransaction().begin();
        newOrder.getBatters().add(2, p);
        newOrder.getBatters().add(p2);
        em.getTransaction().commit();
        em.clear();
        newOrder = (BattingOrder)em.find(BattingOrder.class, (Object)BattingOrder.pcGetid(order));
        TestOrderColumn.assertNotNull((Object)newOrder);
        TestOrderColumn.assertNotNull(newOrder.getBatters());
        TestOrderColumn.assertEquals((int)playersArr.size(), (int)newOrder.getBatters().size());
        for (int i = 0; i < playersArr.size(); ++i) {
            TestOrderColumn.assertEquals((Object)newOrder.getBatters().get(i), (Object)playersArr.get(i));
        }
        this.validateIndexAndValues(em, "BattingOrder", "batters", 0, playersArr.toArray(), "id", BattingOrder.pcGetid(order));
        em.close();
    }

    public void testElementCollectionElementInsert() {
        int i;
        int i2;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Game game = new Game();
        this.validateOrderColumnName(Game.class, "rainDates", "dateOrder");
        Date[] dates = new Date[10];
        ArrayList<Date> rainDates = new ArrayList<Date>(10);
        Calendar today = Calendar.getInstance();
        for (i2 = 0; i2 < 10; ++i2) {
            today.set(2009, 1, i2 + 1);
            dates[i2] = new Date(today.getTimeInMillis());
        }
        for (i2 = 9; i2 >= 0; --i2) {
            rainDates.add(dates[i2]);
        }
        game.setRainDates(rainDates);
        em.getTransaction().begin();
        em.persist((Object)game);
        em.getTransaction().commit();
        em.clear();
        Game newGame = (Game)em.find(Game.class, (Object)game.getId());
        TestOrderColumn.assertNotNull((Object)newGame);
        for (i = 0; i < 10; ++i) {
            TestOrderColumn.assertEquals((Object)game.getRainDates().get(i), (Object)rainDates.get(i));
        }
        today.set(2009, 1, 15);
        rainDates.add(1, new Date(today.getTimeInMillis()));
        today.set(2009, 1, 20);
        rainDates.add(6, new Date(today.getTimeInMillis()));
        em.getTransaction().begin();
        game.getRainDates().add(1, rainDates.get(1));
        game.getRainDates().add(6, rainDates.get(6));
        em.getTransaction().commit();
        em.clear();
        newGame = (Game)em.find(Game.class, (Object)game.getId());
        TestOrderColumn.assertNotNull((Object)newGame);
        TestOrderColumn.assertNotNull(game.getRainDates());
        TestOrderColumn.assertEquals((int)12, (int)game.getRainDates().size());
        for (i = 0; i < game.getRainDates().size(); ++i) {
            TestOrderColumn.assertEquals((Object)game.getRainDates().get(i), (Object)rainDates.get(i));
        }
        em.close();
    }

    public void testOneToManyDefault() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.validateOrderColumnName(BattingOrder.class, "batters", "batters_ORDER");
        Player[] players = new Player[10];
        em.getTransaction().begin();
        for (int i = 0; i < 10; ++i) {
            players[i] = new Player("Player" + i, i);
            em.persist((Object)players[i]);
        }
        em.getTransaction().commitAndResume();
        ArrayList<Player> playersArr = new ArrayList<Player>();
        for (int i = 0; i < 10; ++i) {
            playersArr.add(players[9 - i]);
        }
        BattingOrder order = new BattingOrder();
        order.setBatters(playersArr);
        em.persist((Object)order);
        em.getTransaction().commit();
        em.refresh((Object)order);
        em.clear();
        BattingOrder newOrder = (BattingOrder)em.find(BattingOrder.class, (Object)BattingOrder.pcGetid(order));
        TestOrderColumn.assertNotNull((Object)newOrder);
        for (int i = 0; i < 10; ++i) {
            TestOrderColumn.assertEquals((Object)newOrder.getBatters().get(i), (Object)players[9 - i]);
        }
        Player newPlayer = new Player("New Player", 99);
        em.getTransaction().begin();
        newOrder.getBatters().add(9, newPlayer);
        em.getTransaction().commit();
        em.clear();
        newOrder = (BattingOrder)em.find(BattingOrder.class, (Object)BattingOrder.pcGetid(order));
        TestOrderColumn.assertNotNull((Object)newOrder);
        for (int i = 0; i <= 10; ++i) {
            if (i < 9) {
                TestOrderColumn.assertEquals((Object)newOrder.getBatters().get(i), (Object)players[9 - i]);
                continue;
            }
            if (i == 9) {
                TestOrderColumn.assertEquals((Object)newOrder.getBatters().get(i), (Object)newPlayer);
                continue;
            }
            if (i != 10) continue;
            TestOrderColumn.assertEquals((Object)newOrder.getBatters().get(i), (Object)players[0]);
        }
        em.close();
    }

    public void testOneToManyNamed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.validateOrderColumnName(BattingOrder.class, "pinch_hitters", "pinch_order");
        Player[] players = new Player[4];
        em.getTransaction().begin();
        for (int i = 0; i < 4; ++i) {
            players[i] = new Player("PinchHitter" + i, i);
            em.persist((Object)players[i]);
        }
        em.getTransaction().commitAndResume();
        ArrayList<Player> pinchArr = new ArrayList<Player>();
        for (int i = 0; i < players.length; ++i) {
            pinchArr.add(players[players.length - 1 - i]);
        }
        BattingOrder order = new BattingOrder();
        order.setPinchHitters(pinchArr);
        em.persist((Object)order);
        em.getTransaction().commit();
        em.clear();
        BattingOrder newOrder = (BattingOrder)em.find(BattingOrder.class, (Object)BattingOrder.pcGetid(order));
        TestOrderColumn.assertNotNull((Object)newOrder);
        for (int i = 0; i < players.length; ++i) {
            TestOrderColumn.assertEquals((Object)newOrder.getPinchHitters().get(i), (Object)players[players.length - 1 - i]);
        }
        em.close();
    }

    public void testManyToMany() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.validateOrderColumnName(Trainer.class, "playersTrained", "trainingOrder");
        Player[] players = new Player[25];
        em.getTransaction().begin();
        for (int i2 = 0; i2 < players.length; ++i2) {
            players[i2] = new Player("TrainedPlayer" + i2, i2);
            em.persist((Object)players[i2]);
        }
        em.getTransaction().commitAndResume();
        Trainer[] trainers = new Trainer[5];
        for (i = 0; i < trainers.length; ++i) {
            trainers[i] = new Trainer("Trainer" + i);
            ArrayList<Player> trained = new ArrayList<Player>();
            for (int j = i * 5 + 4; j >= i * 5; --j) {
                trained.add(players[j]);
                if (players[j].getTrainers() == null) {
                    players[j].setTrainers(new ArrayList<Trainer>());
                }
                players[j].getTrainers().add(trainers[i]);
            }
            trainers[i].setPlayersTrained(trained);
            em.persist((Object)trainers[i]);
        }
        em.getTransaction().commit();
        em.clear();
        for (i = 0; i < trainers.length; ++i) {
            Trainer trainer = (Trainer)em.find(Trainer.class, (Object)trainers[i].getId());
            TestOrderColumn.assertNotNull((Object)trainer);
            List<Player> trainedPlayers = trainer.getPlayersTrained();
            TestOrderColumn.assertNotNull(trainedPlayers);
            TestOrderColumn.assertEquals((int)trainedPlayers.size(), (int)5);
            for (int j = trainedPlayers.size() - 1; j >= 0; --j) {
                TestOrderColumn.assertEquals((Object)trainedPlayers.get(j), (Object)players[i * 5 + (4 - j)]);
            }
        }
        em.close();
    }

    public void validateBiOrderedManyToMany() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.validateOrderColumnName(Game.class, "playedIn", "playerOrder");
        this.validateOrderColumnName(Player.class, "gamesPlayedIn", "playedInOrder");
        Player[] players = new Player[25];
        em.getTransaction().begin();
        for (int i2 = 0; i2 < players.length; ++i2) {
            players[i2] = new Player("GamePlayer" + i2, i2);
            em.persist((Object)players[i2]);
        }
        em.getTransaction().commitAndResume();
        Game[] games = new Game[5];
        for (i = 0; i < games.length; ++i) {
            games[i] = new Game();
            ArrayList<Player> playedIn = new ArrayList<Player>();
            for (int j = i * 5 + 4; j >= i * 5; --j) {
                playedIn.add(players[j]);
                if (players[j].getGamesPlayedIn() == null) {
                    players[j].setGamesPlayedIn(new ArrayList<Game>());
                }
                players[j].getGamesPlayedIn().add(games[i]);
            }
            games[i].setPlayedIn(playedIn);
            em.persist((Object)games[i]);
        }
        em.getTransaction().commit();
        em.clear();
        for (i = 0; i < games.length; ++i) {
            Game game = (Game)em.find(Game.class, (Object)games[i].getId());
            TestOrderColumn.assertNotNull((Object)game);
            List<Player> playedIn = game.getPlayedIn();
            TestOrderColumn.assertNotNull(playedIn);
            TestOrderColumn.assertEquals((int)playedIn.size(), (int)5);
            for (int j = playedIn.size() - 1; j >= 0; --j) {
                Player p = playedIn.get(j);
                TestOrderColumn.assertEquals((Object)p, (Object)players[i * 5 + (4 - j)]);
                for (int k = 0; k < p.getGamesPlayedIn().size(); ++k) {
                    TestOrderColumn.assertNotNull(p.getGamesPlayedIn());
                    TestOrderColumn.assertEquals((Object)p.getGamesPlayedIn().get(k), (Object)games[k]);
                }
            }
        }
        em.close();
    }

    public void testElementCollectionBasic() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Game game = new Game();
        this.validateOrderColumnName(Game.class, "rainDates", "dateOrder");
        Date[] dates = new Date[10];
        ArrayList<Date> rainDates = new ArrayList<Date>(10);
        Calendar today = Calendar.getInstance();
        for (i = 0; i < 10; ++i) {
            today.set(2009, 1, i + 1);
            dates[i] = new Date(today.getTimeInMillis());
        }
        for (i = 9; i >= 0; --i) {
            rainDates.add(dates[i]);
        }
        game.setRainDates(rainDates);
        em.getTransaction().begin();
        em.persist((Object)game);
        em.getTransaction().commit();
        em.clear();
        Game newGame = (Game)em.find(Game.class, (Object)game.getId());
        TestOrderColumn.assertNotNull((Object)newGame);
        for (int i2 = 0; i2 < 10; ++i2) {
            TestOrderColumn.assertEquals((Object)game.getRainDates().get(i2), (Object)dates[9 - i2]);
        }
        em.close();
    }

    public void testElementCollectionEmbeddables() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Game game = new Game();
        this.validateOrderColumnName(Game.class, "innings", "inningOrder");
        Inning[] innings = new Inning[9];
        ArrayList<Inning> inningCol = new ArrayList<Inning>();
        Random rnd = new Random();
        for (i = 8; i >= 0; --i) {
            innings[i] = new Inning(i, Math.abs(rnd.nextInt()) % 10, Math.abs(rnd.nextInt()) % 10);
        }
        for (i = 8; i >= 0; --i) {
            inningCol.add(innings[i]);
        }
        game.setInnings(inningCol);
        em.getTransaction().begin();
        em.persist((Object)game);
        em.getTransaction().commit();
        em.clear();
        Game newGame = (Game)em.find(Game.class, (Object)game.getId());
        TestOrderColumn.assertNotNull((Object)newGame);
        Inning[] inningArr = game.getInnings().toArray(new Inning[9]);
        for (int i2 = 0; i2 < 9; ++i2) {
            TestOrderColumn.assertEquals((Object)inningArr[i2], (Object)innings[8 - i2]);
        }
        em.close();
    }

    public void testOrderColumnInsertable() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.validateOrderColumnName(BattingOrder.class, "titles", "titles_ORDER");
        this.validateOrderColumnInsertable(this.emf, BattingOrder.class, "fixedBatters", false);
        em.close();
    }

    public void testOrderColumnUpdateable() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.validateOrderColumnName(BattingOrder.class, "titles", "titles_ORDER");
        this.validateOrderColumnUpdatable(this.emf, BattingOrder.class, "titles", false);
        em.close();
    }

    public void testOrderColumnTable() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.validateOrderColumnTable(this.emf, Owner.class, "cars", "OC_CAR", "car_o2m_order");
        this.validateOrderColumnTable(this.emf, Owner.class, "homes", "home_o2m_table", "homes_ORDER");
        this.validateOrderColumnTable(this.emf, Owner.class, "bikeColl", "bike_table", "bike_coll_order");
        this.validateOrderColumnTable(this.emf, Owner.class, "widgets", "widget_m2m_table", "widgets_ORDER");
        Owner owner = new Owner();
        ArrayList<Car> cars = new ArrayList<Car>();
        ArrayList<Home> homes = new ArrayList<Home>();
        ArrayList<Bicycle> bicycles = new ArrayList<Bicycle>();
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        ArrayList<Owner> owners = new ArrayList<Owner>();
        owner.setCars(cars);
        owner.setHomes(homes);
        owner.setBikeColl(bicycles);
        owner.setWidgets(widgets);
        for (int i = 0; i < 5; ++i) {
            Car car = new Car(2001, "Make" + i, "Model" + i);
            car.setOwner(owner);
            cars.add(car);
            Home home = new Home(2000 + i);
            homes.add(home);
            Bicycle bike = new Bicycle("Brand" + i, "Model" + i);
            bicycles.add(bike);
            Widget widget = new Widget("Name" + i);
            widgets.add(widget);
            widget.setOwners(owners);
        }
        Object[] carArr = cars.toArray();
        Object[] homeArr = homes.toArray();
        Object[] bikeArr = bicycles.toArray();
        Object[] widgetArr = widgets.toArray();
        em.getTransaction().begin();
        em.persist((Object)owner);
        em.getTransaction().commit();
        String oid = owner.getId();
        em.clear();
        this.validateIndexAndValues(em, "Owner", "cars", 0, carArr, "id", oid);
        this.validateIndexAndValues(em, "Owner", "homes", 0, homeArr, "id", oid);
        this.validateIndexAndValues(em, "Owner", "widgets", 0, widgetArr, "id", oid);
        this.validateIndexAndValues(em, "Owner", "bikeColl", 0, bikeArr, "id", oid);
        em.close();
    }

    public void testOrderColumnPredicateQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String queryString = "SELECT w FROM Course c JOIN c.waitList w WHERE c.name = :cname AND INDEX(w) = :widx";
        OpenJPAQuery qry = em.createQuery(queryString);
        qry.setParameter("widx", (Object)0);
        qry.setParameter("cname", (Object)"Course B");
        Student idx0 = (Student)qry.getSingleResult();
        TestOrderColumn.assertNotNull((Object)idx0);
        TestOrderColumn.assertEquals((Object)idx0, (Object)this.students[10]);
        qry.setParameter("widx", (Object)1);
        idx0 = (Student)qry.getSingleResult();
        TestOrderColumn.assertNotNull((Object)idx0);
        TestOrderColumn.assertEquals((Object)idx0, (Object)this.students[11]);
        qry.setParameter("cname", (Object)"Course A");
        qry.setParameter("widx", (Object)0);
        idx0 = (Student)qry.getSingleResult();
        TestOrderColumn.assertNotNull((Object)idx0);
        TestOrderColumn.assertEquals((Object)idx0, (Object)this.students[11]);
        qry.setParameter("widx", (Object)1);
        idx0 = (Student)qry.getSingleResult();
        TestOrderColumn.assertNotNull((Object)idx0);
        TestOrderColumn.assertEquals((Object)idx0, (Object)this.students[10]);
        em.close();
    }

    public void testOrderColumnProjectionQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String queryString = "SELECT INDEX(w) FROM Course c JOIN c.waitList w WHERE c.name = :cname ORDER BY w";
        OpenJPAQuery qry = em.createQuery(queryString);
        qry.setParameter("cname", (Object)"Course A");
        List rlist = qry.getResultList();
        TestOrderColumn.assertNotNull((Object)rlist);
        TestOrderColumn.assertEquals((int)2, (int)rlist.size());
        TestOrderColumn.assertEquals((Object)0L, rlist.get(0));
        TestOrderColumn.assertEquals((Object)1L, rlist.get(1));
        queryString = "SELECT INDEX(w) FROM Course c JOIN c.waitList w WHERE c.name = :cname AND w.name = 'Student11'";
        qry = em.createQuery(queryString);
        qry.setParameter("cname", (Object)"Course B");
        Long idx = (Long)qry.getSingleResult();
        TestOrderColumn.assertNotNull((Object)idx);
        TestOrderColumn.assertEquals((Object)idx, (Object)1L);
        em.close();
    }

    private void createQueryData() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        for (int i = 0; i < 12; ++i) {
            this.students[i] = new Student("Student" + i);
        }
        Course courseA = new Course("Course A");
        Course courseB = new Course("Course B");
        HashSet<Course> courses = new HashSet<Course>();
        courses.add(courseA);
        courses.add(courseB);
        HashSet<Student> cAstudents = new HashSet<Student>();
        for (int i = 0; i < 5; ++i) {
            cAstudents.add(this.students[i]);
            this.students[i].setCourses(courses);
        }
        courseA.setStudents(cAstudents);
        ArrayList<Student> cAwaitlist = new ArrayList<Student>();
        cAwaitlist.add(this.students[11]);
        cAwaitlist.add(this.students[10]);
        courseA.setWaitList(cAwaitlist);
        HashSet<Student> cBstudents = new HashSet<Student>();
        for (int i = 5; i < 10; ++i) {
            cBstudents.add(this.students[i]);
        }
        courseB.setStudents(cBstudents);
        ArrayList<Student> cBwaitlist = new ArrayList<Student>();
        cBwaitlist.add(this.students[10]);
        cBwaitlist.add(this.students[11]);
        courseB.setWaitList(cBwaitlist);
        em.getTransaction().begin();
        em.persist((Object)courseA);
        em.persist((Object)courseB);
        em.getTransaction().commit();
        em.close();
    }

    private void validateIndexAndValues(OpenJPAEntityManagerSPI em, String entity, String indexedCol, int base, Object[] objs, String idField, Object idValue) {
        int i;
        String queryString = "SELECT INDEX(b), b FROM " + entity + " a JOIN a." + indexedCol + " b WHERE a." + idField + " = :idVal";
        em.clear();
        OpenJPAQuery qry = em.createQuery(queryString);
        qry.setParameter("idVal", idValue);
        List rlist = qry.getResultList();
        TestOrderColumn.assertNotNull((Object)rlist);
        TestOrderColumn.assertEquals((int)objs.length, (int)rlist.size());
        TreeMap<Long, Object> objMap = new TreeMap<Long, Object>();
        for (i = 0; i < objs.length; ++i) {
            Object[] rvals = (Object[])rlist.get(i);
            Long idx = (Long)rvals[0];
            Object objVal = rvals[1];
            objMap.put(idx, objVal);
        }
        for (i = 0; i < objs.length; ++i) {
            Object val = objMap.get(new Long(base + i));
            TestOrderColumn.assertEquals(val, (Object)objs[i]);
        }
    }

    private void validateCollIndexAndValues(OpenJPAEntityManagerSPI em, String entity, String indexedCol, int base, Object[] objs, String idField, Object idValue) {
        int i;
        String queryString = "SELECT INDEX(b), b FROM " + entity + " a, IN(a." + indexedCol + ") b WHERE a." + idField + " = :idVal";
        em.clear();
        OpenJPAQuery qry = em.createQuery(queryString);
        qry.setParameter("idVal", idValue);
        List rlist = qry.getResultList();
        TestOrderColumn.assertNotNull((Object)rlist);
        TestOrderColumn.assertEquals((int)objs.length, (int)rlist.size());
        TreeMap<Long, Object> objMap = new TreeMap<Long, Object>();
        for (i = 0; i < objs.length; ++i) {
            Object[] rvals = (Object[])rlist.get(i);
            Long idx = (Long)rvals[0];
            Object objVal = rvals[1];
            objMap.put(idx, objVal);
        }
        for (i = 0; i < objs.length; ++i) {
            Object val = objMap.get(new Long(base + i));
            TestOrderColumn.assertEquals(val, (Object)objs[i]);
        }
    }

    private void validateOrderColumnName(Class clazz, String fieldName, String columnName) {
        this.validateOrderColumnName(this.emf, clazz, fieldName, columnName);
    }

    private Column getOrderColumn(OpenJPAEntityManagerFactorySPI emf1, Class clazz, String fieldName) {
        JDBCConfiguration conf = (JDBCConfiguration)emf1.getConfiguration();
        ClassMapping cls = conf.getMappingRepositoryInstance().getMapping(clazz, null, true);
        FieldMapping fm = cls.getFieldMapping(fieldName);
        Column oc = fm.getOrderColumn();
        TestOrderColumn.assertNotNull((Object)oc);
        return oc;
    }

    private void validateOrderColumnName(OpenJPAEntityManagerFactorySPI emf1, Class clazz, String fieldName, String columnName) {
        Column oc = this.getOrderColumn(emf1, clazz, fieldName);
        TestOrderColumn.assertTrue((boolean)oc.getName().equalsIgnoreCase(columnName));
    }

    private void validateOrderColumnTable(OpenJPAEntityManagerFactorySPI emf1, Class clazz, String fieldName, String tableName, String columnName) {
        Column oc = this.getOrderColumn(emf1, clazz, fieldName);
        TestOrderColumn.assertTrue((boolean)oc.getTableName().equalsIgnoreCase(tableName));
        TestOrderColumn.assertTrue((boolean)this.tableAndColumnExists(emf1, null, tableName, null, columnName));
    }

    private void validateOrderColumnUpdatable(OpenJPAEntityManagerFactorySPI emf1, Class clazz, String fieldName, boolean updatable) {
        Column oc = this.getOrderColumn(emf1, clazz, fieldName);
        TestOrderColumn.assertEquals((boolean)updatable, (!oc.getFlag(16) ? 1 : 0) != 0);
    }

    private void validateOrderColumnInsertable(OpenJPAEntityManagerFactorySPI emf1, Class clazz, String fieldName, boolean insertable) {
        Column oc = this.getOrderColumn(emf1, clazz, fieldName);
        TestOrderColumn.assertEquals((boolean)insertable, (!oc.getFlag(8) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableAndColumnExists(OpenJPAEntityManagerFactorySPI emf1, OpenJPAEntityManagerSPI em, String tableName, String schemaName, String columnName) {
        JDBCConfiguration conf = (JDBCConfiguration)emf1.getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        OpenJPAEntityManagerSPI em1 = em;
        if (em1 == null) {
            em1 = emf1.createEntityManager();
        }
        Connection conn = (Connection)em1.getConnection();
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            Column[] cols = dict.getColumns(dbmd, null, null, tableName, columnName, conn);
            if (cols != null && cols.length == 1) {
                Column col = cols[0];
                String colName = col.getName();
                if (col.getTableName().equalsIgnoreCase(tableName) && (schemaName == null || col.getSchemaName().equalsIgnoreCase(schemaName)) && colName.equalsIgnoreCase(columnName)) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Throwable e) {
            TestOrderColumn.fail((String)"Unable to get column information.");
        }
        finally {
            if (em == null) {
                em1.close();
            }
        }
        return false;
    }
}

