/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.jdbc.query.domain.Chess;
import org.apache.openjpa.persistence.jdbc.query.domain.Game;
import org.apache.openjpa.persistence.jdbc.query.domain.IndoorGame;
import org.apache.openjpa.persistence.jdbc.query.domain.Scrabble;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestAggregateQueryWithNoResult
extends SingleEMFTestCase {
    EntityManager em;

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, "openjpa.Compatibility", "ReturnNullOnAggregateResult=false", Game.class, IndoorGame.class, Scrabble.class, Chess.class);
        this.em = this.emf.createEntityManager();
        TestAggregateQueryWithNoResult.assertTrue((boolean)this.em.createQuery("select p from Scrabble p").getResultList().isEmpty());
    }

    public void testSumWithNoResult() {
        String jpql = "SELECT SUM(g.nTile) FROM Scrabble g";
        Long result = (Long)this.em.createQuery(jpql).getSingleResult();
        TestAggregateQueryWithNoResult.assertNotNull((Object)result);
        TestAggregateQueryWithNoResult.assertEquals((Object)result, (Object)new Long(0L));
    }

    public void testAvgWithNoResult() {
        String jpql = "SELECT AVG(g.nTile) FROM Scrabble g";
        Integer result = (Integer)this.em.createQuery(jpql).getSingleResult();
        TestAggregateQueryWithNoResult.assertNotNull((Object)result);
        TestAggregateQueryWithNoResult.assertEquals((Object)result, (Object)new Integer(0));
    }

    public void testCountWithNoResult() {
        String jpql = "SELECT COUNT(g.nTile) FROM Scrabble g";
        Long result = (Long)this.em.createQuery(jpql).getSingleResult();
        TestAggregateQueryWithNoResult.assertNotNull((Object)result);
        TestAggregateQueryWithNoResult.assertEquals((Object)result, (Object)new Long(0L));
    }

    public void testMaxWithNoResult() {
        String jpql = "SELECT MAX(g.nTile) FROM Scrabble g";
        Integer result = (Integer)this.em.createQuery(jpql).getSingleResult();
        TestAggregateQueryWithNoResult.assertNotNull((Object)result);
        TestAggregateQueryWithNoResult.assertEquals((Object)result, (Object)new Integer(0));
    }

    public void testMinWithNoResult() {
        String jpql = "SELECT MIN(g.nTile) FROM Scrabble g";
        Integer result = (Integer)this.em.createQuery(jpql).getSingleResult();
        TestAggregateQueryWithNoResult.assertNotNull((Object)result);
        TestAggregateQueryWithNoResult.assertEquals((Object)result, (Object)new Integer(0));
    }
}

