/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query;

import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.MariaDBDictionary;
import org.apache.openjpa.jdbc.sql.MySQLDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.query.domain.TimeKeeper;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestHintedQuery
extends SQLListenerTestCase {
    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, TimeKeeper.class);
    }

    public void testHintedQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)new TimeKeeper());
        em.persist((Object)new TimeKeeper());
        em.getTransaction().commit();
        String jpql = "SELECT tk FROM TimeKeeper tk";
        String mariadbHint = "SQL_NO_CACHE";
        String mysqlHint = "SQL_NO_CACHE";
        String oracleHint = "/*+ first_rows(100) */";
        Query query = em.createQuery(jpql);
        query.setHint("openjpa.hint.MariaDBSelectHint", (Object)mariadbHint);
        query.setHint("openjpa.hint.MySQLSelectHint", (Object)mysqlHint);
        query.setHint("openjpa.hint.OracleSelectHint", (Object)oracleHint);
        List keepers = query.getResultList();
        TestHintedQuery.assertEquals((int)2, (int)keepers.size());
        DBDictionary dict = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
        if (dict instanceof MariaDBDictionary) {
            this.assertContainsSQL("SELECT " + mariadbHint + " ");
            return;
        }
        if (dict instanceof MySQLDictionary) {
            this.assertContainsSQL("SELECT " + mysqlHint + " ");
            return;
        }
        if (dict instanceof OracleDictionary) {
            this.assertContainsSQL("SELECT " + oracleHint + " ");
            return;
        }
        this.assertNotSQL(".*" + mariadbHint + ".*");
        this.assertNotSQL(".*" + mysqlHint + ".*");
        this.assertNotSQL(".*" + oracleHint + ".*");
    }
}

