/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query;

import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.query.domain.Applicant;
import org.apache.openjpa.persistence.jdbc.query.domain.Game;
import org.apache.openjpa.persistence.jdbc.query.procedure.AbstractProcedureList;
import org.apache.openjpa.persistence.jdbc.query.procedure.DerbyProcedureList;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestNativeQueryProcedures
extends SingleEMFTestCase {
    AbstractProcedureList procedureList = null;

    @Override
    public void setUp() throws Exception {
        super.setUp(Applicant.class, Game.class, CLEAR_TABLES);
        OpenJPAEntityManagerFactorySPI ojpaEmf = this.emf;
        JDBCConfiguration conf = (JDBCConfiguration)ojpaEmf.getConfiguration();
        if (conf.getDBDictionaryInstance() instanceof DerbyDictionary) {
            this.procedureList = new DerbyProcedureList();
        }
        if (this.procedureList != null) {
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            List<String> createList = this.procedureList.getCreateProcedureList();
            try {
                for (String createProcedure : createList) {
                    em.getTransaction().begin();
                    Query query = em.createNativeQuery(createProcedure);
                    query.executeUpdate();
                    em.getTransaction().commit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                em.getTransaction().commit();
            }
            em.clear();
            em.close();
        }
    }

    @Override
    public void tearDown() throws Exception {
        if (this.procedureList != null) {
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            List<String> dropList = this.procedureList.getDropProcedureList();
            try {
                for (String dropProcedure : dropList) {
                    em.getTransaction().begin();
                    Query query = em.createNativeQuery(dropProcedure);
                    query.executeUpdate();
                    em.getTransaction().commit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                em.getTransaction().commit();
            }
            em.clear();
            em.close();
        }
        super.tearDown();
    }

    public void testNoReturnNoParamProcedure() {
        if (this.procedureList != null) {
            Query query;
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            Applicant applicant1 = new Applicant();
            applicant1.setName("Charlie");
            Applicant applicant2 = new Applicant();
            applicant2.setName("Snoopy");
            em.getTransaction().begin();
            em.persist((Object)applicant1);
            em.persist((Object)applicant2);
            em.getTransaction().commit();
            String sql = this.procedureList.callAddXToCharlie();
            try {
                em.getTransaction().begin();
                query = em.createNativeQuery(sql);
                query.getSingleResult();
                em.getTransaction().commit();
                TestNativeQueryProcedures.fail((String)"Expected exception. getSingleResult() with no returns should fail.");
            }
            catch (Exception e) {
                em.getTransaction().rollback();
            }
            try {
                em.getTransaction().begin();
                query = em.createNativeQuery(sql);
                query.getResultList();
                em.getTransaction().commit();
                TestNativeQueryProcedures.fail((String)"Expected exception. getResultList() with no returns should fail.");
            }
            catch (Exception e) {
                em.getTransaction().rollback();
            }
            try {
                em.getTransaction().begin();
                query = em.createNativeQuery(sql);
                query.executeUpdate();
                em.getTransaction().commit();
            }
            catch (Exception e) {
                em.getTransaction().rollback();
                TestNativeQueryProcedures.fail((String)("Caught unexpected exception executing stored procedure: " + e.getMessage()));
            }
            em.clear();
            em.close();
            em = this.emf.createEntityManager();
            applicant1 = (Applicant)em.find(Applicant.class, (Object)applicant1.getId());
            applicant2 = (Applicant)em.find(Applicant.class, (Object)applicant2.getId());
            TestNativeQueryProcedures.assertEquals((String)"Charliex", (String)applicant1.getName());
            TestNativeQueryProcedures.assertEquals((String)"Snoopy", (String)applicant2.getName());
            em.clear();
            em.close();
        }
    }

    @AllowFailure(value=true, message="Waiting for resolution for JIRA DERBY-4558")
    public void testNoReturnMultiParamProcedure() {
        if (this.procedureList != null) {
            Query query;
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            Applicant applicant1 = new Applicant();
            applicant1.setName("Charlie");
            Applicant applicant2 = new Applicant();
            applicant2.setName("Snoopy");
            em.getTransaction().begin();
            em.persist((Object)applicant1);
            em.persist((Object)applicant2);
            em.getTransaction().commit();
            String sql = this.procedureList.callAddSuffixToName();
            try {
                em.getTransaction().begin();
                query = em.createNativeQuery(sql);
                query.setParameter(1, (Object)"Charlie");
                query.setParameter(2, (Object)"x");
                query.getSingleResult();
                em.getTransaction().commit();
                TestNativeQueryProcedures.fail((String)"Expected exception. getSingleResult() with no returns should fail.");
            }
            catch (Exception e) {
                em.getTransaction().rollback();
            }
            try {
                em.getTransaction().begin();
                query = em.createNativeQuery(sql);
                query.setParameter(1, (Object)"Charlie");
                query.setParameter(2, (Object)"x");
                query.getResultList();
                em.getTransaction().commit();
                TestNativeQueryProcedures.fail((String)"Expected exception. getResultList() with no returns should fail.");
            }
            catch (Exception e) {
                em.getTransaction().rollback();
            }
            try {
                em.getTransaction().begin();
                query = em.createNativeQuery(sql);
                query.setParameter(1, (Object)"Charlie");
                query.setParameter(2, (Object)"x");
                query.executeUpdate();
                em.getTransaction().commit();
            }
            catch (Exception e) {
                em.getTransaction().rollback();
                TestNativeQueryProcedures.fail((String)("Caught unexpected exception executing stored procedure: " + e.getMessage()));
            }
            em.clear();
            em.close();
            em = this.emf.createEntityManager();
            applicant1 = (Applicant)em.find(Applicant.class, (Object)applicant1.getId());
            applicant2 = (Applicant)em.find(Applicant.class, (Object)applicant2.getId());
            TestNativeQueryProcedures.assertEquals((String)"Charliex", (String)applicant1.getName());
            TestNativeQueryProcedures.assertEquals((String)"Snoopy", (String)applicant2.getName());
            em.clear();
            em.close();
        }
    }

    public void testOneReturnNoParamProcedure() {
        if (this.procedureList != null) {
            Query query;
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            Applicant applicant1 = new Applicant();
            applicant1.setName("Charlie");
            Applicant applicant2 = new Applicant();
            applicant2.setName("Snoopy");
            em.getTransaction().begin();
            em.persist((Object)applicant1);
            em.getTransaction().commit();
            String sql = this.procedureList.callGetAllApplicants();
            try {
                em.getTransaction().begin();
                query = em.createNativeQuery(sql, Applicant.class);
                Applicant app = (Applicant)query.getSingleResult();
                em.getTransaction().commit();
                TestNativeQueryProcedures.assertEquals((String)"Charlie", (String)app.getName());
            }
            catch (Exception e) {
                em.getTransaction().rollback();
                TestNativeQueryProcedures.fail((String)("Caught unexpected exception executing stored procedure: " + e.getMessage()));
            }
            em.getTransaction().begin();
            em.persist((Object)applicant2);
            em.getTransaction().commit();
            try {
                em.getTransaction().begin();
                query = em.createNativeQuery(sql, Applicant.class);
                List appList = query.getResultList();
                em.getTransaction().commit();
                TestNativeQueryProcedures.assertEquals((int)2, (int)appList.size());
                for (Applicant a : appList) {
                    if (a.getName().equals("Charlie") || a.getName().equals("Snoopy")) continue;
                    TestNativeQueryProcedures.fail((String)("found invalid applicant " + a.getName()));
                }
            }
            catch (Exception e) {
                em.getTransaction().rollback();
                TestNativeQueryProcedures.fail((String)("Caught unexpected exception executing stored procedure: " + e.getMessage()));
            }
            try {
                em.getTransaction().begin();
                query = em.createNativeQuery(sql, Applicant.class);
                query.executeUpdate();
                em.getTransaction().commit();
                TestNativeQueryProcedures.fail((String)"Expected exception. executeUpdate() with query procedure should fail.");
            }
            catch (Exception e) {
                em.getTransaction().rollback();
            }
            em.clear();
            em.close();
            OpenJPAEntityManagerSPI openJPAEntityManagerSPI = this.emf.createEntityManager();
        }
    }

    public void testOneReturnMultiParamProcedure() {
        if (this.procedureList != null) {
            Query query;
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            Applicant applicant1 = new Applicant();
            applicant1.setName("Charlie");
            Applicant applicant2 = new Applicant();
            applicant2.setName("Snoopy");
            Applicant applicant3 = new Applicant();
            applicant3.setName("Linus");
            Applicant applicant4 = new Applicant();
            applicant4.setName("Lucy");
            em.getTransaction().begin();
            em.persist((Object)applicant1);
            em.persist((Object)applicant3);
            em.persist((Object)applicant4);
            em.getTransaction().commit();
            String sql = this.procedureList.callGetTwoApplicants();
            try {
                em.getTransaction().begin();
                query = em.createNativeQuery(sql, Applicant.class);
                query.setParameter(1, (Object)"Charlie");
                query.setParameter(2, (Object)"Snoopy");
                Applicant app = (Applicant)query.getSingleResult();
                em.getTransaction().commit();
                TestNativeQueryProcedures.assertEquals((String)"Charlie", (String)app.getName());
            }
            catch (Exception e) {
                em.getTransaction().rollback();
                TestNativeQueryProcedures.fail((String)("Caught unexpected exception executing stored procedure: " + e.getMessage()));
            }
            em.getTransaction().begin();
            em.persist((Object)applicant2);
            em.getTransaction().commit();
            try {
                em.getTransaction().begin();
                query = em.createNativeQuery(sql, Applicant.class);
                query.setParameter(1, (Object)"Charlie");
                query.setParameter(2, (Object)"Snoopy");
                List appList = query.getResultList();
                em.getTransaction().commit();
                TestNativeQueryProcedures.assertEquals((int)2, (int)appList.size());
                for (Applicant a : appList) {
                    if (a.getName().equals("Charlie") || a.getName().equals("Snoopy")) continue;
                    TestNativeQueryProcedures.fail((String)("found invalid applicant " + a.getName()));
                }
            }
            catch (Exception e) {
                em.getTransaction().rollback();
                TestNativeQueryProcedures.fail((String)("Caught unexpected exception executing stored procedure: " + e.getMessage()));
            }
            try {
                em.getTransaction().begin();
                query = em.createNativeQuery(sql, Applicant.class);
                query.setParameter(1, (Object)"Charlie");
                query.setParameter(2, (Object)"Snoopy");
                query.executeUpdate();
                em.getTransaction().commit();
                TestNativeQueryProcedures.fail((String)"Expected exception. executeUpdate() with query procedure should fail.");
            }
            catch (Exception e) {
                em.getTransaction().rollback();
            }
            em.clear();
            em.close();
            OpenJPAEntityManagerSPI openJPAEntityManagerSPI = this.emf.createEntityManager();
        }
    }
}

