/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.common.apps.AttachA;
import org.apache.openjpa.persistence.jdbc.common.apps.AttachD;
import org.apache.openjpa.persistence.jdbc.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestSQLQueries
extends BaseJDBCTest {
    private String _tableName = null;
    private String _fullTableName = null;
    private String _pkColName = null;
    private String _intColName = null;
    private String _stringColName = null;
    private String _relColName = null;

    public TestSQLQueries(String name) {
        super(name);
    }

    public TestSQLQueries() {
    }

    public void setUp() {
        this.deleteAll(RuntimeTest1.class);
        RuntimeTest1 pc1 = new RuntimeTest1("1", 1);
        RuntimeTest1 pc2 = new RuntimeTest1("2", 2);
        pc1.setSelfOneOne(pc2);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc1);
        this.endTx((EntityManager)pm);
        JDBCConfiguration conf = (JDBCConfiguration)((OpenJPAEntityManagerFactorySPI)pm).getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        MappingRepository repos = conf.getMappingRepositoryInstance();
        ClassMapping mapping = repos.getMapping(RuntimeTest1.class, pm.getClassLoader(), true);
        this._tableName = mapping.getTable().getName();
        this._fullTableName = dict.getFullName(mapping.getTable(), false);
        this._pkColName = mapping.getTable().getPrimaryKey().getColumns()[0].getName();
        this._intColName = mapping.getFieldMapping("intField").getColumns()[0].getName();
        this._stringColName = mapping.getFieldMapping("stringField").getColumns()[0].getName();
        this._relColName = mapping.getFieldMapping("selfOneOne").getColumns()[0].getName();
        pm.close();
    }

    public void testStarQuery() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createQuery("javax.jdo.query.SQL", "select * from " + this._fullTableName + " order by " + this._intColName);
        q.setResultClass(RuntimeTest1.class);
        Iterator itr = q.getCandidateCollection().iterator();
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        TestSQLQueries.assertEquals((String)"1", (String)((RuntimeTest1)itr.next()).getStringField());
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        TestSQLQueries.assertEquals((String)"2", (String)((RuntimeTest1)itr.next()).getStringField());
        TestSQLQueries.assertFalse((boolean)itr.hasNext());
        q.closeAll();
        pm.close();
    }

    public void testCompiledQuery() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createQuery("javax.jdo.query.SQL", "select * from " + this._fullTableName + " order by " + this._intColName);
        q.setResultClass(RuntimeTest1.class);
        Iterator itr = q.getCandidateCollection().iterator();
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        TestSQLQueries.assertEquals((String)"1", (String)((RuntimeTest1)itr.next()).getStringField());
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        TestSQLQueries.assertEquals((String)"2", (String)((RuntimeTest1)itr.next()).getStringField());
        TestSQLQueries.assertFalse((boolean)itr.hasNext());
        q.closeAll();
        pm.close();
    }

    public void testCompiledLanguageQuery() throws Exception {
        OpenJPAEntityManager pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createQuery("javax.jdo.query.SQL", "select * from " + this._fullTableName + " order by " + this._intColName);
        q.setResultClass(RuntimeTest1.class);
        Iterator itr = q.getCandidateCollection().iterator();
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        TestSQLQueries.assertEquals((String)"1", (String)((RuntimeTest1)itr.next()).getStringField());
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        TestSQLQueries.assertEquals((String)"2", (String)((RuntimeTest1)itr.next()).getStringField());
        TestSQLQueries.assertFalse((boolean)itr.hasNext());
        q.closeAll();
        pm.close();
    }

    public void testTableStarQuery() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createQuery("javax.jdo.query.SQL", "select " + this._tableName + ".* from " + this._fullTableName + " order by " + this._intColName);
        q.setResultClass(RuntimeTest1.class);
        Iterator itr = q.getCandidateCollection().iterator();
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        TestSQLQueries.assertEquals((String)"1", (String)((RuntimeTest1)itr.next()).getStringField());
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        TestSQLQueries.assertEquals((String)"2", (String)((RuntimeTest1)itr.next()).getStringField());
        TestSQLQueries.assertFalse((boolean)itr.hasNext());
        q.closeAll();
        pm.close();
    }

    public void testColumnQuery() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createQuery("javax.jdo.query.SQL", "select " + this._pkColName + ", " + this._intColName + ", " + this._stringColName + " from " + this._fullTableName + " order by " + this._intColName);
        q.setResultClass(RuntimeTest1.class);
        Iterator itr = q.getCandidateCollection().iterator();
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        TestSQLQueries.assertEquals((String)"1", (String)((RuntimeTest1)itr.next()).getStringField());
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        TestSQLQueries.assertEquals((String)"2", (String)((RuntimeTest1)itr.next()).getStringField());
        TestSQLQueries.assertFalse((boolean)itr.hasNext());
        q.closeAll();
        pm.close();
    }

    public void testJoinQuery() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createQuery("javax.jdo.query.SQL", "select t0.* from " + this._fullTableName + " t0, " + this._fullTableName + " t1 where t0." + this._relColName + " = t1." + this._pkColName + " and t1." + this._intColName + " = 2");
        q.setResultClass(RuntimeTest1.class);
        Iterator itr = q.getCandidateCollection().iterator();
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        TestSQLQueries.assertEquals((String)"1", (String)((RuntimeTest1)itr.next()).getStringField());
        TestSQLQueries.assertFalse((boolean)itr.hasNext());
        q.closeAll();
        pm.close();
    }

    public void testParameters() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createQuery("javax.jdo.query.SQL", "select * from " + this._fullTableName + " where 'foo' = ? and " + this._intColName + " = ?");
        q.setResultClass(RuntimeTest1.class);
        q.closeAll();
        HashMap<Integer, Object> params = new HashMap<Integer, Object>();
        params.put(new Integer(1), "foo");
        params.put(new Integer(2), new Integer(2));
        q.closeAll();
        pm.close();
    }

    public void testOnlySelectedFieldsLoaded() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createQuery("javax.jdo.query.SQL", "select " + this._pkColName + ", " + this._intColName + ", " + this._stringColName + " from " + this._fullTableName + " order by " + this._intColName);
        q.setResultClass(RuntimeTest1.class);
        Iterator itr = q.getCandidateCollection().iterator();
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        RuntimeTest1 pc = (RuntimeTest1)itr.next();
        OpenJPAStateManager sm = this.getStateManager(pc, (EntityManager)pm);
        TestSQLQueries.assertTrue((boolean)sm.getLoaded().get(sm.getMetaData().getField("intField").getIndex()));
        TestSQLQueries.assertTrue((boolean)sm.getLoaded().get(sm.getMetaData().getField("stringField").getIndex()));
        TestSQLQueries.assertFalse((boolean)sm.getLoaded().get(sm.getMetaData().getField("longField").getIndex()));
        TestSQLQueries.assertEquals((String)"1", (String)pc.getStringField());
        TestSQLQueries.assertFalse((boolean)sm.getLoaded().get(sm.getMetaData().getField("longField").getIndex()));
        q.closeAll();
        pm.close();
    }

    public void testSingleColumnClasslessQuery() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createQuery("javax.jdo.query.SQL", "select " + this._stringColName + " from " + this._fullTableName + " order by " + this._stringColName);
        Iterator itr = q.getCandidateCollection().iterator();
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        TestSQLQueries.assertEquals((Object)"1", itr.next());
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        TestSQLQueries.assertEquals((Object)"2", itr.next());
        TestSQLQueries.assertFalse((boolean)itr.hasNext());
        q.closeAll();
        q.setResultClass(Object[].class);
        itr = q.getCandidateCollection().iterator();
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        Object[] vals = (Object[])itr.next();
        TestSQLQueries.assertEquals((int)1, (int)vals.length);
        TestSQLQueries.assertEquals((Object)"1", (Object)vals[0]);
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        vals = (Object[])itr.next();
        TestSQLQueries.assertEquals((int)1, (int)vals.length);
        TestSQLQueries.assertEquals((Object)"2", (Object)vals[0]);
        TestSQLQueries.assertFalse((boolean)itr.hasNext());
        q.closeAll();
        pm.close();
    }

    public void testMultiColumnClasslessQuery() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createQuery("javax.jdo.query.SQL", "select " + this._intColName + ", " + this._stringColName + " from " + this._fullTableName + " order by " + this._stringColName);
        Iterator itr = q.getCandidateCollection().iterator();
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        Object[] vals = (Object[])itr.next();
        TestSQLQueries.assertEquals((int)2, (int)vals.length);
        TestSQLQueries.assertEquals((int)1, (int)((Number)vals[0]).intValue());
        TestSQLQueries.assertEquals((Object)"1", (Object)vals[1]);
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        vals = (Object[])itr.next();
        TestSQLQueries.assertEquals((int)2, (int)vals.length);
        TestSQLQueries.assertEquals((int)2, (int)((Number)vals[0]).intValue());
        TestSQLQueries.assertEquals((Object)"2", (Object)vals[1]);
        TestSQLQueries.assertFalse((boolean)itr.hasNext());
        q.closeAll();
        pm.close();
    }

    public void testResultClass() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createQuery("javax.jdo.query.SQL", "select * from " + this._fullTableName + " order by " + this._intColName);
        q.setResultClass(RuntimeTest1.class);
        q.setResultClass(Holder.class);
        Iterator itr = q.getCandidateCollection().iterator();
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        Holder holder = (Holder)itr.next();
        TestSQLQueries.assertEquals((int)0, (int)holder.I);
        TestSQLQueries.assertNull((Object)holder.S);
        TestSQLQueries.assertNotNull((Object)holder.pc);
        TestSQLQueries.assertEquals((String)"1", (String)holder.pc.getStringField());
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        holder = (Holder)itr.next();
        TestSQLQueries.assertEquals((int)0, (int)holder.I);
        TestSQLQueries.assertNull((Object)holder.S);
        TestSQLQueries.assertNotNull((Object)holder.pc);
        TestSQLQueries.assertEquals((String)"2", (String)holder.pc.getStringField());
        TestSQLQueries.assertFalse((boolean)itr.hasNext());
        q.closeAll();
        pm.close();
    }

    public void testClasslessProjection() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createQuery("javax.jdo.query.SQL", "select " + this._intColName + " as I, " + this._stringColName + " as S from " + this._fullTableName + " order by " + this._intColName);
        q.setResultClass(Holder.class);
        Iterator itr = q.getCandidateCollection().iterator();
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        Holder holder = (Holder)itr.next();
        TestSQLQueries.assertNull((Object)holder.pc);
        TestSQLQueries.assertEquals((int)1, (int)holder.I);
        TestSQLQueries.assertEquals((String)"1", (String)holder.S);
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        holder = (Holder)itr.next();
        TestSQLQueries.assertNull((Object)holder.pc);
        TestSQLQueries.assertEquals((int)2, (int)holder.I);
        TestSQLQueries.assertEquals((String)"2", (String)holder.S);
        TestSQLQueries.assertFalse((boolean)itr.hasNext());
        q.closeAll();
        pm.close();
    }

    public void relationLoadedTest() {
        this.deleteAll(AttachD.class);
        this.deleteAll(AttachA.class);
        AttachD d = new AttachD();
        AttachA a = new AttachA();
        d.setA(a);
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getTransaction().begin();
        pm.persist((Object)d);
        pm.getTransaction().commit();
        pm.close();
        JDBCConfiguration conf = (JDBCConfiguration)((OpenJPAEntityManagerFactorySPI)pm).getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        MappingRepository repos = conf.getMappingRepositoryInstance();
        ClassMapping mappingA = repos.getMapping(AttachD.class, pm.getClassLoader(), true);
        String tableNameA = mappingA.getTable().getName();
        String fullTableNameA = dict.getFullName(mappingA.getTable(), false);
        String relColNameA = mappingA.getFieldMapping("a").getColumns()[0].getName();
        ClassMapping mappingD = repos.getMapping(AttachA.class, pm.getClassLoader(), true);
        String tableNameD = mappingD.getTable().getName();
        String fullTableNameD = dict.getFullName(mappingD.getTable(), false);
        String pkColNameD = mappingD.getTable().getPrimaryKey().getColumns()[0].getName();
        pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createQuery("javax.jdo.query.SQL", "select t0.*, t1.* from " + fullTableNameA + " t0, " + fullTableNameD + " t1 " + "where t0." + relColNameA + " = t1." + pkColNameD);
        q.setResultClass(AttachD.class);
        Iterator itr = q.getCandidateCollection().iterator();
        TestSQLQueries.assertTrue((boolean)itr.hasNext());
        d = (AttachD)itr.next();
        OpenJPAStateManager sm = this.getStateManager(d, (EntityManager)pm);
        TestSQLQueries.assertTrue((boolean)sm.getLoaded().get(sm.getMetaData().getField("a").getIndex()));
        TestSQLQueries.assertNotNull((Object)d.getA());
        TestSQLQueries.assertFalse((boolean)itr.hasNext());
        q.closeAll();
        pm.close();
    }

    public static void main(String[] args) throws Exception {
        new TestSQLQueries().relationLoadedTest();
    }

    private static Object roundtrips(Object orig, boolean validateEquality) throws IOException, ClassNotFoundException {
        TestSQLQueries.assertNotNull((Object)orig);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(orig);
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bin);
        Object result = in.readObject();
        if (validateEquality) {
            TestSQLQueries.assertEquals((int)orig.hashCode(), (int)result.hashCode());
            TestSQLQueries.assertEquals((Object)orig, (Object)result);
        }
        return result;
    }

    public static class Holder {
        public RuntimeTest1 pc;
        public int I;
        public String S;

        public void setRuntimeTest1(RuntimeTest1 pc) {
            this.pc = pc;
        }
    }
}

