/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query.cache;

import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.datacache.AbstractQueryCache;
import org.apache.openjpa.datacache.ConcurrentQueryCache;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.query.cache.AbstractQueryCacheTest;
import org.apache.openjpa.persistence.jdbc.query.cache.PartBase;
import org.apache.openjpa.persistence.test.FilteringJDBCListener;

public class TestQueryTimestampEviction
extends AbstractQueryCacheTest {
    private List<String> _sql = new ArrayList<String>();

    @Override
    public void setUp() throws Exception {
        super.setUp("openjpa.DataCache", "true", "openjpa.QueryCache", "true(CacheSize=1000, EvictPolicy='timestamp')", "openjpa.RemoteCommitProvider", "sjvm", "openjpa.jdbc.JDBCListeners", new JDBCListener[]{new FilteringJDBCListener(this._sql)});
    }

    public void testEmptyResultTimeout() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select p from PartBase p where p.cost > ?1";
        OpenJPAQuery q = em.createQuery(query);
        q.setParameter(1, (Object)100000);
        List l = q.getResultList();
        TestQueryTimestampEviction.assertEquals((int)0, (int)l.size());
        em.getTransaction().begin();
        em.persist((Object)new PartBase());
        em.getTransaction().commit();
        TestQueryTimestampEviction.assertTrue((this._sql.size() > 0 ? 1 : 0) != 0);
        this._sql.clear();
        q = em.createQuery(query);
        q.setParameter(1, (Object)100000);
        q.getResultList();
        TestQueryTimestampEviction.assertEquals((int)1, (int)this._sql.size());
        em.close();
    }

    public void testTimestampEvictionEnablement() {
        ConcurrentQueryCache qc = this.getQueryCache();
        AbstractQueryCache.EvictPolicy ep = qc.getEvictPolicy();
        TestQueryTimestampEviction.assertTrue((ep == AbstractQueryCache.EvictPolicy.TIMESTAMP ? 1 : 0) != 0);
    }

    public void testLoadQueries() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        this.loadQueryCache();
        int cacheSizeBeforeUpdate = this.queryCacheGet();
        this.updateAnEntity();
        int cacheSizeAfterUpdate = this.queryCacheGet();
        TestQueryTimestampEviction.assertEquals((int)cacheSizeBeforeUpdate, (int)cacheSizeAfterUpdate);
        this.recreateData = false;
    }

    public void testWriteLock() throws Exception {
        final QueryCache qc = this.emf.getConfiguration().getDataCacheManagerInstance().getSystemQueryCache();
        Thread t2 = new Thread(){

            @Override
            public void run() {
                qc.writeLock();
                qc.writeUnlock();
            }
        };
        t2.start();
        t2.join(5000L);
        if (t2.getState().equals((Object)Thread.State.WAITING)) {
            TestQueryTimestampEviction.fail((String)"The thread is still waiting on a writeLock()!");
        }
    }
}

