/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query.sub;

import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.query.sub.MaxQueryEntity;
import org.apache.openjpa.persistence.jdbc.query.sub.MaxQueryMapEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestSubQuery
extends SingleEMFTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp(CLEAR_TABLES, MaxQueryEntity.class, MaxQueryMapEntity.class);
        this.populate();
    }

    public void populate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        MaxQueryEntity mqe = new MaxQueryEntity(1, 1, 1);
        MaxQueryMapEntity mqme = new MaxQueryMapEntity(1, 1, "A1");
        MaxQueryMapEntity mqme2 = new MaxQueryMapEntity(2, 2, "A2");
        mqme.setRefEntity(mqe);
        mqme2.setRefEntity(mqe);
        em.persist((Object)mqe);
        em.persist((Object)mqme);
        em.persist((Object)mqme2);
        mqe = new MaxQueryEntity(2, 2, 1);
        mqme = new MaxQueryMapEntity(3, 1, "B1");
        mqme.setRefEntity(mqe);
        em.persist((Object)mqe);
        em.persist((Object)mqme);
        mqme = new MaxQueryMapEntity(4, 2, "B2");
        mqme.setRefEntity(mqe);
        em.persist((Object)mqme);
        mqme = new MaxQueryMapEntity(5, 3, "B3");
        mqme.setRefEntity(mqe);
        em.persist((Object)mqme);
        mqe = new MaxQueryEntity(3, 3, 1);
        mqme = new MaxQueryMapEntity(6, 4, "C1");
        mqme.setRefEntity(mqe);
        em.persist((Object)mqe);
        em.persist((Object)mqme);
        tran.commit();
        em.close();
    }

    public void test() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query query = em.createQuery("SELECT e FROM MaxQueryEntity e, MaxQueryMapEntity map WHERE  map.revision = ( SELECT MAX(map_.revision)                       FROM MaxQueryMapEntity map_                       WHERE map_.refEntity = map.refEntity )");
        TestSubQuery.assertEquals((int)9, (int)query.getResultList().size());
        em.close();
    }
}

