/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query.xml;

import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.query.xml.TableNameInXmlEntity;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestTableNameInXml
extends SQLListenerTestCase {
    String containsSQL = " FROM TableNameInXml ";
    String notContainsSQL = " FROM TableNameInXmlEntity ";

    @Override
    public void setUp() {
        super.setUp(TableNameInXmlEntity.class);
    }

    public void testQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = em.createQuery("SELECT t FROM TableNameInXmlEntity t");
        q.getResultList();
        this.assertContainsSQL(this.containsSQL);
        this.assertNotSQL(this.notContainsSQL);
        em.close();
    }

    public void testNamedQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = em.createNamedQuery("TableNameInXmlEntity.findAll");
        q.getResultList();
        this.assertContainsSQL(this.containsSQL);
        this.assertNotSQL(this.notContainsSQL);
        em.close();
    }

    public void testBoth() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = em.createQuery("SELECT t FROM TableNameInXmlEntity t");
        q.getResultList();
        q = em.createNamedQuery("TableNameInXmlEntity.findAll");
        q.getResultList();
        this.assertContainsSQL(this.containsSQL);
        this.assertNotSQL(this.notContainsSQL);
        em.close();
    }

    @Override
    protected String getPersistenceUnitName() {
        return "TableNameInXml-PU";
    }
}

