/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.sqlcache;

import java.util.ArrayList;
import org.apache.openjpa.kernel.PreparedQueryCache;
import org.apache.openjpa.kernel.QueryStatistics;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDefaultQueryStatistics
extends SingleEMFTestCase {
    QueryStatistics<String> statistics;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.statistics = new QueryStatistics.Default();
    }

    public void testThreadSafety() throws Exception {
        final QueryStatistics<String> finalStats = this.statistics;
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 10000; ++i) {
                    finalStats.recordExecution((Object)("query " + Thread.currentThread().getId() + " " + i));
                }
            }
        };
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 10; ++i) {
            threads.add(new Thread(runner));
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        TestDefaultQueryStatistics.assertEquals((int)1000, (int)finalStats.keys().size());
    }

    public void testStatsSize() throws Exception {
        for (int i = 0; i < 10000; ++i) {
            this.statistics.recordExecution((Object)("query " + Thread.currentThread().getId() + " " + i));
        }
        TestDefaultQueryStatistics.assertEquals((int)1000, (int)this.statistics.keys().size());
    }

    public void testQueryStatisticsIsDisabledByDefault() {
        PreparedQueryCache cache = this.emf.getConfiguration().getQuerySQLCacheInstance();
        TestDefaultQueryStatistics.assertNotNull((Object)cache);
        QueryStatistics stats = cache.getStatistics();
        TestDefaultQueryStatistics.assertNotNull((Object)stats);
        TestDefaultQueryStatistics.assertTrue((boolean)stats.keys().isEmpty());
        TestDefaultQueryStatistics.assertEquals(QueryStatistics.None.class, stats.getClass());
    }
}

